#include "scim-bridge-agent-focus-changed-event.h"

ScimBridgeAgentFocusChangedEvent::ScimBridgeAgentFocusChangedEvent (scim_bridge_imcontext_id_t new_id, bool new_focus_in,  ScimBridgeAgentClientListener *new_client_listener):
ScimBridgeAgentEvent (FOCUS_CHANGED_EVENT),
imcontext_id (new_id), focus_in (new_focus_in), client_listener (new_client_listener)
{
}


ScimBridgeAgentFocusChangedEvent::~ScimBridgeAgentFocusChangedEvent ()
{
}


scim_bridge_imcontext_id_t ScimBridgeAgentFocusChangedEvent::get_imcontext_id () const
{
    return imcontext_id;
}


bool ScimBridgeAgentFocusChangedEvent::is_focus_in () const
{
    return focus_in;
}


ScimBridgeAgentClientListener *ScimBridgeAgentFocusChangedEvent::get_client_listener () const
{
    return client_listener;
}
