# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"

require "rast_test"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("calc.rb")

    class CalcTest < Test::Unit::TestCase
      def test_invoke
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "open-office-org.sxc")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          filter_module = ApplicationVndSunXmlCalc.new
          filter_module.invoke(filter, brigade,
                               "application/vnd.sun.xml.calc")
        end

        buf = ""
        filter.passed[0].brigade.each do |bucket|
          buf.concat(bucket.read)
        end

        assert_equal("データの種類\nこれはCalcのデータです\n7月11日\n本日は晴天なり\n7月12日\n明日は雨です\n", buf)
        assert_equal("text/plain; charset=UTF-8", filter.passed[0].mime_type)
        assert_equal(1, filter.passed.length)
        assert_equal("天気", filter.properties["title"])
        assert_equal("著者", filter.properties["author"])
        assert_equal("その他の情報1", filter.properties["Info 1"])
        assert_equal("その他の情報2", filter.properties["Info 2"])
        assert_equal("その他の情報3", filter.properties["Info 3"])
        assert_equal("その他の情報4", filter.properties["Info 4"])
        assert_equal(6, filter.properties.length)
      end
    end
  end
end
