# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

at_exit do
  GC.start # to avoid SEGV on finalizers of bdb.
end

require "pp"
require "test/unit"

# todo: special case
require "rast_test"

testdir = File.dirname(__FILE__)
$:.unshift(testdir)

runner = Test::Unit::AutoRunner.new(true)
if !runner.process_args(ARGV)
  runner.to_run.push(testdir)
end
if runner.pattern.empty?
  runner.pattern = [/-test\.rb\z/]
end
runner.exclude.push(/\b\.svn\b/)
exit(runner.run)
