/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include <apr_strings.h>
#include <st.h>

#include "rast/ruby.h"
#include "rast/config.h"
#include "rast/xmlrpc_client.h"

static VALUE
xmlrpc_client_initialize(int argc, VALUE *argv, VALUE self)
{
    return rast_rb_process_db_initialize(argc, argv, self,
                                         rast_xmlrpc_client_open);
}

void
Init_rast_xmlrpc_client()
{
    VALUE cDB, cXMLRPCClient;

    rb_require("rast");

    rast_xmlrpc_client_initialize();
    atexit(rast_xmlrpc_client_finalize);

    cDB = rb_const_get(rast_rb_mRast, rb_intern("DB"));

    cXMLRPCClient = rb_define_class_under(rast_rb_mRast, "XMLRPCClient", cDB);
    rb_define_method(cXMLRPCClient, "initialize",
                     xmlrpc_client_initialize, -1);
}

/* vim: set filetype=c sw=4 expandtab : */
