dnl AM_PATH_APU([MAJOR], [MINOR], [TEENY])
dnl Adds support for APR utils
AC_DEFUN([AM_PATH_APU],
[
  rast_lib_apu_major="$1"
  rast_lib_apu_minor="$2"
  rast_lib_apu_patch="$3"
  rast_lib_apu_version="$1.$2.$3"

  AC_ARG_WITH(apu-config,
  AC_HELP_STRING([--with-apu-config=PATH],[path to apu-config]),
  [
      AC_MSG_RESULT([using $withval for apu-config])
      APU_CONFIG="$withval"
  ], [
      AC_PATH_PROG(APU_CONFIG, apu-config, no)
  ])
  if test "$APU_CONFIG" = "no"; then
      AC_MSG_ERROR([apu-config is required])
  fi

  AC_MSG_CHECKING([APU version])    
  APU_VERSION="`$APU_CONFIG --version`"
  if test $? -ne 0; then
    AC_MSG_ERROR([apu-config --version failed])
  fi
  changequote(<<, >>)
  APU_MAJOR=`expr "$APU_VERSION" : '\(.*\)\..*\..*'`
  APU_MINOR=`expr "$APU_VERSION" : '.*\.\(.*\)\..*'`
  APU_PATCH=`expr "$APU_VERSION" : '.*\..*\.\(.*\)'`
  changequote([, ])
  if expr "$APU_MAJOR" '<' "$rast_lib_apu_major" > /dev/null; then
    AC_MSG_ERROR([$rast_lib_apu_version is required])
  fi
  if expr "$APU_MAJOR" '=' "$rast_lib_apu_major" > /dev/null; then
    if expr "$APU_MINOR" '<' "$rast_lib_apu_minor" > /dev/null; then
      AC_MSG_ERROR([$rast_lib_apu_version is required])
    fi
    if expr "$APU_MINOR" '=' "$rast_lib_apu_minor" > /dev/null; then
      if expr "$APU_PATCH" '<' "$rast_lib_apu_patch" > /dev/null; then
        AC_MSG_ERROR([$rast_lib_apu_version is required])
      fi
    fi
  fi
  AC_MSG_RESULT([$APU_VERSION])

  LDFLAGS="`$APU_CONFIG --ldflags` $LDFLAGS"
  APU_INCLUDES="`$APU_CONFIG --includes`"

  APU_LIBS_LD="`$APU_CONFIG --link-ld --libs`"
  APU_LIBS_LIBTOOL="`$APU_CONFIG --link-libtool --libs`"

  AC_SUBST(APU_INCLUDES)
  AC_SUBST(APU_LIBS_LD)
  AC_SUBST(APU_LIBS_LIBTOOL)
])
