/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include <string.h>
#include <apr_hash.h>
#include <apr_ring.h>

#include "rast/error.h"
#include "rast/property.h"

typedef struct rast_buf_ring_entry_t {
    APR_RING_ENTRY(rast_buf_ring_entry_t) link;
    char *buf;
    int nbytes;
} rast_buf_ring_entry_t;

APR_RING_HEAD(rast_buf_ring_head_t, rast_buf_ring_entry_t);
typedef struct rast_buf_ring_head_t rast_buf_ring_head_t;

static inline void *
rast_memchr(const void *s, int c, size_t n)
{
    /* todo: memchr is not standard */
    return memchr(s, c, n);
}

rast_error_t *rast_apr_hash_to_rast_value_array(const rast_property_t *,
                                                int num_properties,
                                                apr_hash_t *values,
                                                rast_value_t **result,
                                                apr_pool_t *pool);
