/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_RUBY_H
#define RAST_RUBY_H

#include <ruby.h>
#include <rubyio.h>
#include <apr_buckets.h>

#undef PACKAGE_NAME
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef PACKAGE_STRING

#include "rast/db.h"
#include "rast/error.h"
#include "rast/types.h"

extern VALUE rast_rb_cDate, rast_rb_cDateTime;
extern VALUE rast_rb_mRast;
extern VALUE rast_rb_eError, rast_rb_eRastError, rast_rb_eAprError;
extern VALUE rast_rb_eBDBError, rast_rb_eXMLRPCError, rast_rb_eRubyError;

void rast_rb_raise_error(rast_error_t *error);
rast_error_t *rast_rb_exception_to_rast_error(VALUE obj);
void rast_rb_initialize();

apr_pool_t *rast_rb_pool_new(VALUE *vpool);
apr_status_t rast_rb_pool_create_ex(apr_pool_t **new_pool, apr_pool_t *parent,
                                    apr_allocator_t *allocator);

char *rast_rb_hash_get_string(apr_pool_t *pool, VALUE hash, const char *name);
int rast_rb_hash_get_bool(VALUE hash, const char *name);
rast_type_e rast_rb_hash_get_property_type(VALUE hash, const char *name);
void rast_rb_get_bool_option(VALUE options, const char *name, int *dst);
void rast_rb_get_int_option(VALUE options, const char *name, int *dst);
void rast_rb_get_string_option(VALUE options, const char *name,
                               const char **dst);
const char *rast_rb_get_safe_string_ptr(VALUE str);

typedef struct {
    rast_db_t *db;
    apr_pool_t *pool;
    int closed;
} rast_rb_db_data_t;

void rast_rb_db_free(rast_rb_db_data_t *data);
VALUE rast_rb_process_db_initialize(int argc, VALUE *argv, VALUE self,
                                    rast_error_t *(*open)(rast_db_t **db,
                                                          const char *name,
                                                          int flags,
                                                          rast_db_open_option_t *
                                                          options,
                                                          apr_pool_t *pool));
rast_db_t *rast_rb_get_db(VALUE self);

apr_bucket_brigade *rast_rb_get_brigade(VALUE vbrigade);

VALUE rast_rb_brigade_new(apr_bucket_brigade *brigade);

#endif
