#!/bin/sh

# packagers: don't call this script from package building systems, please!

[ "`whoami`" = "root" ] || { 
	echo "Need superuser privileges."
	exit 1
}

echo -n "Copying script executable..."
cp src/pykompiz.py /usr/bin/pykompiz
chmod 0755 /usr/bin/pykompiz
echo "done."
echo -n "Copying logo pixmap..."
mkdir -p /usr/share/compiz
cp logo24.png /usr/share/compiz

mkdir -p /usr/share/icons/default.kde/22x22/apps
cp logo24.png /usr/share/icons/hicolor/22x22/apps/pykompiz.png

echo "done."

[ -e `which gset-compiz` ] || {
	echo "WARNING: gset-compiz isn't in your PATH. This is required"
	echo "for the Preferences menuitem to work. Install gset-compiz"
	echo "for full operation of this program."
}

echo ""
echo "Install complete. You need python bindings for KDE and Qt installed"
echo "for your default version of Python. (whatever is returned by"
echo "env python)"
echo ""
echo "be sure to check for errors in the output above."
