#
# wrapper.sh - Sample command wrappers (bash version)
# Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
# This file is part of NILFS and is licensed under the GPL.
#
# wrapper.sh,v 1.4 2006/03/17 13:57:59 ryusuke Exp
#
# Written by Ryusuke Konishi <ryusuke@osrg.net>
#
# usage:
#    1) Copy this file to the directory of your choice.
#       (e.g. ~/etc/scripts)
#    2) Insert the following line in ~/.bashrc to include this script.
#       source ~/etc/scripts/wrapper.sh
#
#    See docs/{sketch,tagcp}.txt for details.

function rm() {
     args="$@"
     while [ -n "$1" ]; do
	 case "$1" in
	     -*|--*) ;;
	     *)
		 if [ -e "$1" -a `df -t nilfs "$1" | wc -l` -eq 2 ]; then
		     /sbin/tagcp -n -t "Removing $1 ..." 2> /dev/null
		     break
		 fi ;;
	 esac
	 shift
     done
     /bin/rm $args
}

function tar() {
     expr index "$1" x > /dev/null &&
     /sbin/tagcp -n -t "Expanding $2" `pwd` 2> /dev/null
     /bin/tar $@
}
