/*
 * parse.c - NILFS tool inspector, command parser
 *
 * Copyright (C) 2005, 2006 Nippon Telegraph and Telephone Corporation.
 *
 * This file is part of NILFS.
 *
 * NILFS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NILFS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NILFS; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * parse.c,v 1.10 2006/04/28 01:34:05 amagai Exp
 *
 * Written by Amagai Yoshiji <amagai@osrg.net>
 */

#include "inspect.h"
#ifdef READLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif

/* command parse */
char vcom[NARG][LARG];
int gcnarg;

int
getcom(FILE *fd, char *prompt)
{
#ifndef READLINE
	char iline[256];
#endif
	char *ilinep = NULL;
	struct ins *c;
	int ret = -1;
	int i;

	c = inscom;
	for (;;) {
#ifdef READLINE
		if (ilinep)
			free(ilinep);
		ilinep = readline(prompt);
#else
		if (prompt) {fputs(prompt, stdout); fflush(stdout);}
		ilinep = fgets(iline, 256, fd);
#endif
		if (ilinep == NULL) {
			if (feof(fd)) {
				clearerr(fd);
				return -3; /* EOF */
			}
			if (ferror(fd)) return -4; /* ERROR */
			putchar('\n'); fflush(stdout);
			continue;
		}
		if (*ilinep == '\n') continue;
		for (i=0; i < NARG; i++) *vcom[i] = '\0';
		gcnarg = sscanf(ilinep, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s",
				vcom[0],vcom[1],vcom[2],vcom[3],vcom[4],vcom[5],vcom[6],vcom[7],
				vcom[8],vcom[9],vcom[10],vcom[11],vcom[12],vcom[13],vcom[14],vcom[15]);
		if (*vcom[0]) break;
	}
#ifdef READLINE
	add_history(ilinep);
#endif
	if (('0' <= vcom[0][0] && vcom[0][0] <= '9') || '#' == vcom[0][0]) {
		strncpy(vcom[1], vcom[0], sizeof(vcom[0]) - 1);
		strcpy(vcom[0], "number");
	}
	while (c->com) {
		if (strcmp(vcom[0], c->com) == 0) { /* command found */
			ret = c->comn;
			break;
		}
		c++;
	}
#ifdef READLINE
	if (ilinep)
		free(ilinep);
#endif
	return ret;
}

/*
 * leading #b means "block"
 * leading #s means "segment"
 * #s0 means first segment
 * #b0x100 means 256th block
 */

unsigned long int
gnumt(char *str, int base)
{
	char *t = NULL;
	unsigned long int n = strtoul(str, &t, base);

	if (t && *t) {
		switch (*t) {
		case 'k': n *= 1024; break;
		case 'm': n *= 1024 * 1024; break;
		case 'g': n *= 1024 * 1024 * 1024; break;
		case 's': n *= blksperseg; break;
		case 'b': break;
		}
	}
	return n;
}

int
gnum(char *str, int def)
{
	if (str == NULL || *str == 0) return def;
	if (strncmp(str, "0x", 2) == 0) return gnumt(str, 16);
	if (strncmp(str, "0", 1) == 0) return gnumt(str, 8);
	if ('1' <= *str && *str <= '9') return gnumt(str, 10);
	if (strncmp(str, "#b", 2) == 0) return gnum(str+2, def);	/* block number */
	if (strncmp(str, "#s", 2) == 0) return blksperseg * gnum(str+2, def); /* segment number -> block number */
	if (strncmp(str, ".", 1) == 0) return c_blk_n;
	return def;
}

#define optstr(var)\
  if (*++str) var = str;\
  else if (++i<argc) var = argv[i];\
  else usage();

#define optint(var)\
  if (*++str) var = atoi(str);\
  else if (++i<argc) var = atoi(argv[i]);\
  else usage();

void
mygetopt(int argc, char *argv[])
{
	int i;
	char *str;

	for (i=1; i<argc; i++) {
		str = argv[i];
		if (*str != '-') {
			devname = str;
		} else {
			switch(*++str) {
			case 'e':	/* get sketch data */
				date_in_epoch++;
				break;
			case 's':	/* get sketch data */
				optint(sketch_blk);
				break;
			case 'o':	/* sketch data output file */
				optstr(sketch_out);
				break;
			default:
				usage();
				exit(1);
			}
		}
	}
	return;
}

void
usage()
{
	fprintf(stderr, "%s [-e] [-s sketchblk] [-o outfile] devname\n", progname);
}

/* Local Variables:	*/
/* eval: (c-set-style "linux")	*/
/* End:			*/
