#!/bin/sh
# listpseg - partial segment viewer
# Copyright (C) 2006 Nippon Telegraph and Telephone Corporation.
# This file is part of NILFS and is licensed under the GPL.
#
# listpseg.sh,v 1.1 2006/03/20 08:53:46 ryusuke Exp
#
# Written by Ryusuke Konishi <ryusuke@osrg.net>
#
cmd=`basename $0`
inspect=/sbin/inspect

function show_help() {
    echo "Usage: $cmd <device>"
    echo "       $cmd <directory>"
}

function fs_dir2dev() {
    df -t $2 "$1" | sed -ne '2{s/^\(\S\+\)\s.*$/\1/;p;q}'
}

function is_autofs_dir() {
    sed -ne '\|^automount(\S\+)\s\+'"$1"'\s\+autofs\s|{x;s/^/y/;p;q}' /etc/mtab
}

function abort() { echo "$1" 1>&2; exit 1; }

if [ -z "$1" ]; then 
    show_help 1>&2; exit 1
elif [ -b "$1" ]; then
    device="$1"
elif [ -d "$1" ]; then
    device=`fs_dir2dev "$1" nilfs`
    if [ -z "$device" ]; then
	autofs=`is_autofs_dir "$1"`
	if [ "$autofs" = y -a -d $1/cur ]; then
	    device=`fs_dir2dev "$1/cur" nilfs`
	fi
    fi
else
    abort "Not directory nor device: $1";
fi

[ -n $device ] || abort "Not NILFS directory";
[ -r $device ] || abort "Device not readable";
[ -x $inspect ] || abort "Please install inspect";

(echo "listpseg"; echo "quit") | $inspect $device | sed -ne '/^nilfs> /,/^nilfs> /{s/^nilfs> //;p}'
