/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import viewer.common.Dialogs;

public class InfoDialog
extends JDialog {
    private JPanel btn_panel;
    private JButton close_btn;
    private double clicked_time;

    public InfoDialog(Frame frame, String string, double d) {
        super(frame, string);
        this.clicked_time = d;
        this.init();
    }

    public InfoDialog(Dialog dialog, String string, double d) {
        super(dialog, string);
        this.clicked_time = d;
        this.init();
    }

    private void init() {
        super.setDefaultCloseOperation(0);
        this.btn_panel = new JPanel();
        this.close_btn = new JButton("close");
        this.close_btn.setAlignmentX(0.5f);
        this.btn_panel.add(this.close_btn);
        this.btn_panel.setAlignmentX(0.0f);
        Dimension dimension = this.btn_panel.getPreferredSize();
        dimension.width = Short.MAX_VALUE;
        this.btn_panel.setMaximumSize(dimension);
    }

    public JButton getCloseButton() {
        return this.close_btn;
    }

    public JPanel getCloseButtonPanel() {
        return this.btn_panel;
    }

    public double getClickedTime() {
        return this.clicked_time;
    }

    public void setVisibleAtLocation(Point point) {
        this.setLocation(point);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    private class InfoDialogWindowListener
    extends WindowAdapter {
        private InfoDialog info_popup;

        public InfoDialogWindowListener(InfoDialog infoDialog2) {
            this.info_popup = infoDialog2;
        }

        public void windowClosing(WindowEvent windowEvent) {
            Dialogs.info(this.info_popup, "Use the CLOSE button please!", null);
        }
    }
}

