/*
  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

  $Id: writer.h,v 1.9 2006/07/09 11:26:27 taku-ku Exp $;

  Copyright (C) 2001-2006 Taku Kudo <taku@chasen.org>
  Copyright (C) 2004-2006 Nippon Telegraph and Telephone Corporation

*/

#include <string>
#include "mecab.h"
#include "utils.h"
#include "scoped_ptr.h"
#include "string_buffer.h"

namespace MeCab {

  class Param;

  class Writer {
  private:
    scoped_string  node_format_;
    scoped_string  bos_format_;
    scoped_string  eos_format_;
    scoped_string  unk_format_;
    whatlog what_;

    bool writeNode(StringBuffer&, const char*, const char*, Node*);
    bool writeLattice(StringBuffer&, const char*, Node*);
    bool writeWakati(StringBuffer&, const char*, Node*);
    bool writeNone(StringBuffer&, const char*, Node*);
    bool writeUser(StringBuffer&, const char*, Node*);
    bool writeDump(StringBuffer&, const char*, Node*);

    bool (Writer::*_write)(StringBuffer&, const char*, Node*);

  public:
    explicit Writer();
    virtual ~Writer();
    bool open(Param &);
    void close();
    bool writeNode(StringBuffer &, const char*, Node *);
    bool write(StringBuffer &, const char*, Node *);
    const char *what() { return what_.str(); }
  };
}

