/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mobile Application Link.
 *
 * The Initial Developer of the Original Code is AvantGo, Inc.
 * Portions created by AvantGo, Inc. are Copyright (C) 1997-1999
 * AvantGo, Inc. All Rights Reserved.
 *
 * Contributors: Jason Day <jasonday@worldnet.att.net>
 *               Reinhold Kainhofer (reinhold@kainhofer.com)
 *
 */

#ifndef __LIBMAL_H__
#define __LIBMAL_H__

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include <AGUtil.h>
#include <AGClientProcessor.h>
#include <AGProtocol.h>
#include <AGBufferReader.h>
#include <AGPalmProtocol.h>
#include <AGUserConfig.h>
#include <AGServerConfig.h>
#include <AGSyncCommon.h>
#include <AGCommandProcessor.h>
#include <AGDesktopInfoPalm.h>
#include <AGTimeoutMessageBox.h>
#include <AGMobileLinkSettings.h>
#include <AGMD5.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

typedef struct {

    AGDeviceInfo * deviceInfo;
    AGUserConfig * userConfig;
    AGServerConfig * currentServerConfig;
    AGClientProcessor * clientProcessor;
    AGPlatformCalls * platform;
    AGRecord * record;
    AGDBConfig * currentDb;
    AGCommandProcessor *commandProcessor;
    AGBool quit;

    /* For .sub files -- JLD */
    char *subBuf;
    long subBufferSize;
    AGBool sentCommand;

    /* Pilot-specific */
    AGBool currentDBIsResourceType;
    int pilot_rHandle;
    int pilot_RecIndex;
    recordid_t id;
    uint8  *pilot_buffer;
    int pilot_buffer_size;

    /* Secure Network Library Stuff */
    AGBool          hasseclib;

} PalmSyncInfo;

typedef sword (*netInitFunc)(AGNetCtx *ctx);
typedef sword (*netCloseFunc)(AGNetCtx *ctx);
typedef int32 (*netCtxSizeFunc)(void);
typedef void  (*netPreSyncHook) (AGNetCtx *ctx,
                                 AGServerConfig *sc,
                                 AGLocationConfig *lc,
                                 AGSyncProcessor *sp,
                                 AGBool connectSecure);
typedef void  (*netPostSyncHook) (AGNetCtx *ctx,
                                  AGServerConfig *sc,
                                  AGLocationConfig *lc,
                                  AGSyncProcessor *sp,
                                  AGBool connectSecure);

/* These two are deprecated */
typedef int (*printStatusHook)(const char *format, ...);
typedef int (*printErrorHook)(const char *format, ...);

/* ----------------------------------------------------------------------------*/
/* Function Prototypes */


PalmSyncInfo *syncInfoNew (void);
void syncInfoFree (PalmSyncInfo * pInfo);
int getIndexFromPlatformData(uint8 *platformData);
void Connect (PalmSyncInfo *pi);
void Disconnect (void);
int loadSecLib (void);


AGBool submitSubFile (PalmSyncInfo * pInfo, AGNetCtx *ctx);
int malsync (int sd, PalmSyncInfo *pInfo);
/* deprecated */
void register_printStatusHook (printStatusHook pfn);
/* deprecated */
void register_printErrorHook (printStatusHook pfn);
void setHttpProxy (char *str);
void setHttpProxyPort (int port);
void setSocksProxy (char *str);
void setSocksProxyPort (int port);
void setProxyUsername (char *str);
void setProxyPassword (char *str);

#ifdef __cplusplus
}
#endif
#endif /* __LIBMAL_H__ */
