/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kktwidget.h"
#include "kktcategoryview.h"
#include "kktthumbnailview.h"
#include "kktthumbnailitem.h"
#include "kktitem.h"
#include "../kkdesigner/kkddoc.h"
#include "../kkdesigner/kkdview.h"

#include <kglobal.h>
#include <kconfig.h>
#include <klistview.h>
#include <qwidget.h>
#include <kaction.h>
#include <klocale.h>
#include <kdebug.h>
#include <kurl.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <qfile.h>

using namespace KKTemplate;

KKTWidget::KKTWidget( KCommandHistory* cmdHistory, QWidget* parent, const char* name )
	: KKWidgetBase( cmdHistory, parent, name )
{
	m_tvwCategory = new KKTCategoryView( this );
	m_spl = new QSplitter( Qt::Vertical, this );
	m_lvwThumbnail = new KKTThumbnailView( m_spl );
	m_doc = new KKDesigner::KKDDoc( this );
	m_pvw = new KKDesigner::KKDView( KKDesigner::KKDItemBase::PreviewMode, m_doc, m_spl );

	connect( m_tvwCategory, SIGNAL( selectionChanged( QListViewItem* ) ), m_lvwThumbnail, SLOT( categoryChanged( QListViewItem* ) ) );
	connect( m_lvwThumbnail, SIGNAL( selectionChanged( QListViewItem* ) ), this, SLOT( preview( QListViewItem* ) ) );
	connect( m_tvwCategory, SIGNAL( selectionChanged( QListViewItem* ) ), this, SLOT( preview() ) );

	connect( m_lvwThumbnail, SIGNAL( doubleClicked( QListViewItem*, const QPoint&, int ) ), this, SLOT( open( QListViewItem* ) ) );

	KStdAction::openNew( this, SLOT( open() ), actionCollection() );
/*	new KAction( i18n( "&Download" ), "kget", 0, this, SLOT( download() ), actionCollection(), "download" );
	setActionEnabled( "download", false );*/
}

KKTWidget::~KKTWidget()
{
}

bool KKTWidget::closable()
{
	return true;
}

void KKTWidget::tabChanged( bool enabled )
{
	setActionEnabled( "file_new", enabled );
}

void KKTWidget::download()
{
	setActionEnabled( "download", false );
	QString lang = KGlobal::locale()->language();
	KURL url( "http://linux-life.net/program/cc/kde/app/kreetingkard/?mode=download" );
	QString fileName;
	if( !KIO::NetAccess::download( url, fileName, this ) ){
		KMessageBox::sorry( this, KIO::NetAccess::lastErrorString() );
		setActionEnabled( "download", true );
		return;
	}

	if( !fileName.isEmpty() ){
		QFile file( fileName );
		if ( !file.open( IO_ReadOnly ) ){
			KMessageBox::sorry( this, i18n("KreetingKard can not open the file.") );
			setActionEnabled( "download", true );
			return;
		}
/*		QTextStream ts( &file );
		while( !ts.atEnd() ){
			QString str( ts.readLine() );
			if( str.isEmpty() ){
				continue;
			}
			QStringList temp = QStringList::split( "\t", str, true );
			cannadic[m_code2index[temp[0]]].category = temp[1];
			cannadic[m_code2index[temp[0]]].name = temp[2];
			cannadic[m_code2index[temp[0]]].example = temp[3];
			m_code2item[temp[0]]->setText( 2, temp[1] );
			m_code2item[temp[0]]->setText( 3, temp[2] );
			m_code2item[temp[0]]->setText( 4, temp[3] );
		}*/
		file.close();
	}
	KIO::NetAccess::removeTempFile( fileName );
	setActionEnabled( "download", true );
}

void KKTWidget::readConfig( KConfig* conf )
{
	conf->setGroup("Template");

	if( conf->hasKey( "HSplit" ) )
	{
		setSizes( conf->readIntListEntry( "HSplit" ) );
	}

	if( conf->hasKey( "VSplit" ) )
	{
		m_spl->setSizes( conf->readIntListEntry( "VSplit" ) );
	}
}

void KKTWidget::saveConfig( KConfig* conf )
{
	conf->setGroup("Template");
	conf->writeEntry( "HSplit", sizes() );
	conf->writeEntry( "VSplit", m_spl->sizes() );
}

void KKTWidget::preview( QListViewItem* item )
{
	if( item == NULL )
	{
		m_doc->close();
	}
	else
	{
		m_doc->open( ((KKTThumbnailItem*)item)->item()->filename() );
	}
}

void KKTWidget::preview()
{
	m_doc->close();
}

void KKTWidget::open()
{
	open( m_lvwThumbnail->currentItem() );
}

void KKTWidget::open( QListViewItem* item )
{
	if( item != NULL )
	{
		emit open( ((KKTThumbnailItem*)item)->item()->filename() );
	}
}

