/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kannadic.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kglobal.h>
#include <kuniqueapplication.h>
#include <kdebug.h>

static const char description[] =
	I18N_NOOP("KDE based user dictionary editor");

static const char version[] = "2.0.3";

static KCmdLineOptions options[] =
{
	{ "+file",          I18N_NOOP("Files to load"), 0 },
	KCmdLineLastOption
};


int main(int argc, char **argv)
{
	KAboutData about( "kannadic", I18N_NOOP("KannaDic"), version, description, KAboutData::License_GPL, "", I18N_NOOP("(c)2003, Tasuku Suzuki"), "http://linux-life.net/program/cc/kde/app/kannadic/", "tasuku@linux-life.net" );
	about.addAuthor( I18N_NOOP("Tasuku Suzuki"), I18N_NOOP("Author"), "tasuku@linux-life.net", "http://linux-life.net/" );

	about.addAuthor( I18N_NOOP("MaR"), I18N_NOOP("Icon Creater"), "info@milkn.com", "http://milkn.com/" );

	KCmdLineArgs::init(argc, argv, &about);
	KannaDic *mainWin = 0;
#if 1
	KCmdLineArgs::addCmdLineOptions( options );
//	kdDebug() << "Multi Mode" << endl;
	KApplication app;

	if (app.isRestored())
	{
		RESTORE(KannaDic);
	}
	else
	{
		mainWin = new KannaDic();
		app.setMainWidget( mainWin );
		mainWin->show();
	}

#else
// 	kdDebug() << "Uniq Mode" << endl;
	KUniqueApplication::addCmdLineOptions();

	if ( !KUniqueApplication::start() ) {
		kdDebug() << QString( I18N_NOOP( "%1 is already running!\n" ) ).arg( about.appName() ) << endl;
		exit(0);
	}

	KUniqueApplication app;
	app.disableSessionManagement();

	if( app.isRestored() ){
		RESTORE( KannaDic )
	}else{
		mainWin = new KannaDic();
		mainWin->show();
	}
#endif
	return app.exec();
}
