/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "importmsimecommand.h"
#include "word.h"
#include "cannadic.h"

#include <qcursor.h>
#include <kconfig.h>
#include <kurl.h>
#include <qtextcodec.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qapplication.h>
#include <kio/netaccess.h>
#include <qfile.h>
#include <qtextstream.h>

ImportMSIMECommand::ImportMSIMECommand( KListView* parent )
{
	m_succeed = false;
	m_parent = parent;

	KConfig *conf = KGlobal::config();
	conf->setGroup("ImportMSIMECommand");
	QString startdir = conf->readEntry( "StartDir", QString::null );

	KURL url = KFileDialog::getOpenURL( startdir
		, i18n("*.txt|Microsoft IME style text dictionary files(*.txt)\n*.*|All files"), parent );

	if( url.isEmpty() ) return;

	QString fileName;
	bool blLocal = url.isLocalFile();
	if( blLocal ){
		fileName = url.path();
		conf->writeEntry( "StartDir", url.directory() );
	}else{
		if( !KIO::NetAccess::download( url, fileName, parent ) ){
			KMessageBox::sorry( parent, KIO::NetAccess::lastErrorString() );
			return;
		}
	}

	if( !fileName.isEmpty() ){
		QFile file( fileName );
		if ( !file.open( IO_ReadOnly ) ){
			KMessageBox::sorry( parent, i18n("KannaDic can not open the file.") );
			return;
		}
		QString comment;
		QTextStream ts( &file );
		ts.setCodec( QTextCodec::codecForName("Shift-JIS") );
		QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
		while( !ts.atEnd() ){
			QString str( ts.readLine() );
			if( str.isEmpty() ){
				continue;
			}else if( str.at(0) == '!' ){
				comment += str;
				comment += "\n";
				continue;
			}
			Word word;
			QStringList temp = QStringList::split( "\t", str );
			word.from = temp[0];
			word.to = temp[1];
			word.type = CannaDic::instance().code2type( win2canna( temp[2] ) );
			word.freq = 1;
			m_item.append( new WordItem( m_parent, word ) );
		}
		file.close();
		QApplication::restoreOverrideCursor();
		if( !comment.isEmpty() ){
			KMessageBox::information( parent, comment, i18n("Exclude line(s)"), QString::null, KMessageBox::AllowLink );
		}
	}
	if( !blLocal ){
		KIO::NetAccess::removeTempFile( fileName );
	}
	m_succeed = true;
}


bool ImportMSIMECommand::succeed()
{
	return m_succeed;
}

QString ImportMSIMECommand::name() const
{
	return i18n( "Import MSIME text dic" );
}

void ImportMSIMECommand::execute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->insertItem( item );
		m_parent->setSelected( item, true );
	}
	m_parent->ensureItemVisible( m_item.at(m_item.count()-1) );
	QApplication::restoreOverrideCursor();
}

void ImportMSIMECommand::unexecute()
{
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	m_parent->clearSelection();
	for( WordItem* item = m_item.first(); item; item=m_item.next() ){
		m_parent->takeItem( item );
	}
	QApplication::restoreOverrideCursor();
}

QString ImportMSIMECommand::win2canna( QString from )
{
	static QMap<QString, QString> table;
	if( table.empty() ){
		int count = sizeof(trans_ime2canna)/sizeof(struct Trans);
		for( int i = 0; i != count; i++ ){
			table[QString::fromLocal8Bit( trans_ime2canna[i].from )] = trans_ime2canna[i].to;
		}
	}
	return table[from];
}
