/***************************************************************************
                          sender.h  -  description
                             -------------------
    begin                : Wed Feb 5 2003
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/04/27 19:38:47 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SENDER_H
#define SENDER_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#include <qthread.h>
#include <qstring.h>



class BChannel
{

public:

	BChannel( const QString &n, unsigned int pv, unsigned int pa, char a, unsigned int spid, unsigned int pg, unsigned int an, unsigned int tp, const QString &lg );
	QString name;
	unsigned int pida, pidv;
	char ac3;
	unsigned int subpid, page, id, type;
	QString lang;
};



class Sender : public QThread
{

public:

	Sender();
	~Sender();
	void run();
	void stop();
	void go();

	int senderSocket;
	struct sockaddr_in senderAddr;

protected:

	bool makeSenderSocket( const QString &addr, int m_senderPort );
	void closeSender();

	bool isRunning;
	QPtrList<BChannel> bchan;

};

#endif
