/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: vidsurf2.h,v 1.1.1.1.42.1 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _VIDSURF2_H_
#define _VIDSURF2_H_

///////////////////////////////////////////////////////////////////////////////
// CVideoSurface2 is the default impelmentation of IHXVideoSurface2.
// It implements a cross platform ColorConvert function based on the
// color conversion routines returned from the GetColorConverter routines.
//
// Each OS needs to make an OSSurface2 that iherits OSSurface and this class.
// Look at CWinSurface2 for reference.
///////////////////////////////////////////////////////////////////////////////
class CVideoSurface2 : public IHXVideoSurface2
{
public:

   /*
    * IUnknown methods
    */
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)(THIS);
    STDMETHOD_(ULONG32,Release)(THIS);
   
   /*
    * IHXVideoSurface2 methods
    */ 
    STDMETHOD (SetProperties) (THIS_ 
                               /*IN/OUT*/ HXBitmapInfoHeader* bmi,
                               /*IN/OUT*/ REF(UINT32) ulNumBuffers,
                               IHXRenderTimeLine* pTimeLine);
                                                
                                                
    STDMETHOD (GetVideoMem) (THIS_
                             VideoMemStruct* pVidMem,
                             UINT32 ulFlags);

    STDMETHOD (ColorConvert) (THIS_
                              INT32 cidIn, 
                              HXxSize *pSrcSize,
                              HXxRect *prSrcRect,
                              SourceInputStruct *pInput,
                              INT32 cidOut,
                              UCHAR *pDestBuffer, 
                              HXxSize *pDestSize, 
                              HXxRect *prDestRect, 
                              int nDestPitch);

    STDMETHOD (ReleaseVideoMem) (THIS_ VideoMemStruct* pVidMem);

    STDMETHOD (Present) (THIS_
                         VideoMemStruct* pVidMem,
                         INT32 lTime,
                         UINT32 ulFlags,
                         HXxRect* prDestRect,
                         HXxRect* prSrcRect);

    STDMETHOD_(void, Flush)(THIS);

    STDMETHOD (PresentIfReady) (THIS);

    /*
     * Misc
     */

     virtual CHXBaseSite* GetSite() = 0;
     virtual BOOL GetColorConverter(int cidIn, int cidOut) = 0;
     virtual BOOL GetColorConverter2(int cidIn, int cidOut) = 0;
     virtual int  ColorConvert(INT32 cidOut, unsigned char *dest_ptr,
                               int dest_width, int dest_height,
                               int dest_pitch, int dest_x, int dest_y,
                               int dest_dx, int dest_dy,
                               INT32 cidIn, unsigned char *src_ptr,
                               int src_width, int src_height,
                               int src_pitch, int src_x, int src_y,
                               int src_dx, int src_dy) = 0;

     virtual int  ColorConvert2(INT32 cidOut, unsigned char *dest_ptr,
                                int dest_width, int dest_height,
                                int dest_pitch, int dest_x, int dest_y,
                                int dest_dx, int dest_dy,
                                INT32 cidIn, unsigned char *pY,
                                unsigned char *pU, unsigned char *pV,
                                int src_width, int src_height,
                                int yPitch, int uPitch, int vPitch,
                                int src_x, int src_y, int src_dx, int src_dy) = 0;


protected:

    IUnknown*           m_pIUnknown;

    CVideoSurface2(IUnknown* pIUnkOuter);
    virtual ~CVideoSurface2();
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME

};

#endif //_VIDSURF2_H_
