/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: winsurf2.h,v 1.4.34.1 2004/07/09 01:58:48 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _WINSURF2_H_
#define _WINSURF2_H_

#include "winroot.h"
#include "vidsurf2.h"

//#define FILTER_SCAN_LINE
#ifdef FILTER_SCAN_LINE
#define SCAN_LINE_FILTER_DEPTH 8192
#endif // FILTER_SCAN_LINE

class CWinSurface2 : public CWinSurface,
                     public CVideoSurface2
{

public:

    friend class CWinRootSurface;

    CWinSurface2(IUnknown* pContext, CHXBaseSite* pSite);
    virtual ~CWinSurface2();

    // IUnknown methods
    STDMETHOD(QueryInterface)(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)(THIS);
    STDMETHOD_(ULONG32,Release)(THIS);
    
    // IHXVideoSurface Overrides for VS2->VS1 transitions
    STDMETHOD(Blt)(THIS_
                   UCHAR*               pImageData,
                   HXBitmapInfoHeader* pBitmapInfo,
                   REF(HXxRect)         rDestRect,
                   REF(HXxRect)         rSrcRect);

    STDMETHOD(BeginOptimizedBlt)(THIS_ HXBitmapInfoHeader* pBitmapInfo);
    
    virtual void        _CreateBuffer();
    virtual HX_RESULT   _CreateOverlay(BOOL bOverlay, int cid, int x, int y);

    virtual HX_RESULT 
     ByPassCompositionSurface(UCHAR*               pImageData,
                              HXBitmapInfoHeader* pBitmapInfo,
                              HXxRect&             rDestRect,
                              HXxRect&             rSrcRect,
                              UCHAR*               pSurface,
                              LONG32               nSurfPitch);
    
    virtual void        _ReleaseSurface(CBaseRootSurface* pSurface);
    virtual void        _ReleaseSurface(CWinBaseRootSurface* pSurface);
    virtual void        _ReleaseSurface();
    
    virtual void        ReInitSurfaces();
    virtual BOOL        _IsDisplaySurfaceYuv();
    virtual BOOL        _AllowsOverlayShrinking();

    virtual void        _WaitForQueuedFrames();
    virtual void        _LockBlitter();
    virtual void        _UnlockBlitter();
    virtual void        _FlushSurfaces();

    
    // IHXVideoSurface2 Methods
    STDMETHOD (SetProperties) (THIS_ HXBitmapInfoHeader* bmi,
                                     REF(UINT32) ulNumBuffers,
                                     IHXRenderTimeLine* pTimeLine);
    STDMETHOD (GetVideoMem) (THIS_
                             VideoMemStruct* pVidMem,
                             UINT32 ulFlags);

    STDMETHOD (ColorConvert) (THIS_
                              INT32 cidIn, 
                              HXxSize *pSrcSize,
                              HXxRect *prSrcRect,
                              SourceInputStruct *pInput,
                              INT32 cidOut,
                              UCHAR *pDestBuffer, 
                              HXxSize *pDestSize, 
                              HXxRect *prDestRect, 
                              int nDestPitch);

    STDMETHOD (ReleaseVideoMem) (THIS_ VideoMemStruct* pVidMem);

    STDMETHOD (Present) (THIS_
                         VideoMemStruct* pVidMem,
                         INT32 lTime,
                         UINT32 ulFlags,
                         HXxRect *prDestRect,
                         HXxRect *prSrcRect);

    STDMETHOD_(void, Flush)(THIS);
    STDMETHOD (PresentIfReady) (THIS);

    // CVideoSurface2 Methods
    CHXBaseSite* GetSite() {return m_pSite;}
    BOOL GetColorConverter(int cidIn, int cidOut);
    BOOL GetColorConverter2(int cidIn, int cidOut);
    int  ColorConvert(INT32 cidOut, unsigned char *dest_ptr,
                      int dest_width, int dest_height,
                      int dest_pitch, int dest_x, int dest_y,
                      int dest_dx, int dest_dy,
                      INT32 cidIn, unsigned char *src_ptr,
                      int src_width, int src_height,
                      int src_pitch, int src_x, int src_y,
                      int src_dx, int src_dy);

    int  ColorConvert2(INT32 cidOut, unsigned char *dest_ptr,
                       int dest_width, int dest_height,
                       int dest_pitch, int dest_x, int dest_y,
                       int dest_dx, int dest_dy,
                       INT32 cidIn, unsigned char *pY,
                       unsigned char *pU, unsigned char *pV,
                       int src_width, int src_height,
                       int yPitch, int uPitch, int vPitch,
                       int src_x, int src_y, int src_dx, int src_dy);


    virtual HX_RESULT RelinquishOverlay();
    virtual HX_RESULT AcquireOverlay();

protected:
    /*
     *  Render thread members
     */
    static DWORD    WINAPI ThreadProc(CWinSurface2* pThis);
    DWORD           RenThread();
    HANDLE          m_hRenThread,
                    m_hFrameSem,
                    m_hReinit,
                    m_hAbort,
                    m_hForceRender,
                    m_hSurfaceMutex;
    BOOL            m_bCont,
                    m_bBoostRenderThread,
                    m_bDoAlphaCheck,
                    m_bQueryMonitorFreq,
                    m_bUseVBlankFlip,
                    m_bIngnorePresentIfReady;
    BOOL            m_bScratchSurface,
                    m_bGDISurface;
    INT32           m_nScratchIndex,
                    m_nLastDisplayTime;
    HXxRect         m_rcLast;
    CHXSimpleList*  m_pListOfFrames;
    
    CRITICAL_SECTION m_csDisplay,
                     m_csFallback,
                     m_csList,
                     m_csScale;

    IHXRenderTimeLine* m_pTimeLine;

    // double          m_bBaseTime;
    // It's important to remake all of pnvideo if FILTER_SCAN_LINE is defined!
#ifdef FILTER_SCAN_LINE
    double          m_dMaxRegression;
    double          m_dPhasePoint;
    UINT32          m_ulScanLineFilterDepth;
    double          m_scanLineFilter[SCAN_LINE_FILTER_DEPTH][2];
#endif // FILTER_SCAN_LINE

    BOOL            CanLockSurface(INT32 nIndex, int nBltMode, BOOL bBlock);
    HX_RESULT       DisplayFrame(tFrameElement* pItem);
    HX_RESULT       ForceUpdateOverlay(HXxRect *pDst, HXxRect *pSrc, DWORD dwFlags, BOOL bCheckPos=FALSE);
    HX_RESULT       HandleDisplayModeChange();
    BOOL            HandleDirectDrawLoss(BOOL bLockedTLSMutex);
    HX_RESULT       ReleaseSurface(VideoMemStruct* pVidStruct, BOOL bDiscard=FALSE, BOOL bDeleteAlphaList=TRUE);
    HX_RESULT       WaitForTimeLine(INT32 lTimeStamp);
    HX_RESULT       WaitForQueuedFrames();

    /*
     *  Fall-back surface
     */
    HX_RESULT       CreateFallbackSurface(int nSurfaceCID, HXxSize* pSize, int *pcidList=NULL, int nListSize=0);
    HX_RESULT       DestroyFallbackSurface();
    HX_RESULT       LockFallbackSurface(UCHAR* &pVidMem, INT32 &nPitch, BOOL bBlock=TRUE);
    HX_RESULT       TryNewFallback();

    HX_RESULT       CreateSysMemSurface(int nSurfaceCID, HXxSize* pSize, int nBuffers);
    HX_RESULT       LockSysMemSurface(UCHAR* &pVidMem, INT32 &nPitch, BOOL bBlock=TRUE);
    HX_RESULT       DestroySysMemSurface();
    INT32           GetBitsPerPixel(int nSurfaceID);

    WINDRAWSURFACE  m_fallbackSurface;
    HANDLE          m_hFallbackEmpty;
    HXxSize         m_allocatedFallbackSize;
    int             m_nFallbackSurfaceCID;
    BOOL            m_bFallbackSurfaceCreated;

    /*
     *  System memory surface
     */
    typedef struct tagSysMemSurf
    {
        UCHAR   *pBuffer;
        HANDLE  hEmpty;
    } tSysMemSurf;

    tSysMemSurf     *m_pSysMemSurf;
    HXxSize         m_allocatedSysMemSurfSize;
    INT32           m_nSysMemSurfCount,
                    m_nSysMemSurfPitch,
                    m_nSysMemSurfSize,
                    m_nNextSysMemBuffer;
    int             m_nSysMemSurfID;
    BOOL            m_bUseSysMemSurface;

    /*
     *  GDI surface
     */
    HX_RESULT       CreateGdiSurface(HXxSize* pSize);
    HX_RESULT       LockGdiSurface(UCHAR* &pVidMem, INT32 &nPitch, BOOL bBlock=TRUE);
    HX_RESULT       DestroyGdiSurface();

    WINDRAWSURFACE  m_GDIsurface;
    HXxSize         m_allocatedGdiSize;
    INT32           m_nGdiSurfaceCount,
                    m_nLastGdiSurface,
                    m_nNextGdiSurface;
    int             m_nGdiSurfaceCID;
    BOOL            m_bGdiSurfaceCreated;

    /*
     *  Misc
     */
    UINT32          m_ulFillColoryKeyCount;
    BOOL            m_bFlushing,
                    m_bFrameHasHWAlphaBlend,
                    m_bSurfaceRequiresOverlay,
                    m_bSwitchingingOverlay,
                    m_bUseDDColorControls,
                    m_bWaitingForFlush,
                    m_bWasInVidSurf2;
    double          m_dLastXScale,
                    m_dLastYScale;
    int             m_nOverlayBackBuffersCreated;
    double          m_dLastBlitError;

    int             GetBestBltMode();
    BOOL            IsShrinking();
    void            ResetBufferTimes(INT32 nTime);
    void            SetLastScale(HXxRect *pSrc, HXxRect *pDest);
    BOOL            SetYUVPriorityList(int cidIn);
    void            _WaitForFlush();

    void            CreateAlphaList(VideoMemStruct* pVidStruct);

    void            YuvAlphaBlend(AlphaStruct* pList,
                                  UINT32 ulCount,
                                  UCHAR* pDest,
                                  UINT32 ulFourCC,
                                  INT32  lPitch,
                                  HXxSize* pDestDim);

    HX_RESULT       _ScheduleFrameForDisplay(void* pOsData,
                                             tFrameElement* pItem,
                                             UINT32 nResolution);

    double          FilterScanLine(UINT32 ulScanLine, double dTickAtStreamTime,
                                   WINDRAW* pWindraw, BOOL bResetFilter = FALSE);
};

#endif
