/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: basesite.h,v 1.6.34.3 2004/07/09 01:58:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _BASESITE_H_
#define _BASESITE_H_

#include "hxslist.h"
#include "chxpckts.h"
#include "hxwin.h"
#include "hxwintyp.h"
#include "hxsite2.h"
#include "hxvctrl.h"
#include "hxcomm.h"
#include "hxengin.h"
#include "region.h"
#include "sitetran.h"
#include "coloracc.h"

class   CHXBaseSite;
class   CBaseSurface;
class   CBaseRootSurface;
class   CHXSiteStatusText;
class   BaseSiteCallback;
class   ScrollSiteCallback;
class   HXMutex;
class   HXThread;

/*
 *  reasons to schedule call backs.
 */

#define REPAINT    0
#define CLIP       1
#define MOUSE      2  
#define REDRAW_ALL 3
#define MOVE       4

#if defined(_UNIX) || defined(_MACINTOSH)
#  define HX_SHOW_WINDOW 1
#  define HX_HIDE_WINDOW 2
#endif

#if defined(_WINDOWS)
#  define HX_SHOW_WINDOW SW_SHOW
#  define HX_HIDE_WINDOW SW_HIDE
#endif

//Defines for sensitivity.
#define SENSITIVITY_NOT_SET     -3
#define SENSITIVITY_OPAQUE      -2
#define SENSITIVITY_TRANSPARENT -1


/****************************************************************************
 * 
 *  Class:
 *
 *      NonDelegatingUnknown
 *
 *  Purpose:
 *
 *      Same signature as IUnknown, allows an object to implement 
 *      aggregation.
 *
 */
class SiteNonDelegatingUnknown
{
  public:
    /*
     * DelegatingUnknown methods
     */
    STDMETHOD(SiteNonDelegatingQueryInterface) (THIS_ REFIID riid, void** ppvObj) PURE;
    STDMETHOD_(ULONG32,SiteNonDelegatingAddRef) (THIS) PURE;
    STDMETHOD_(ULONG32,SiteNonDelegatingRelease) (THIS) PURE;
};

/****************************************************************************
 * 
 *  Class:
 *
 *      CHXBaseSite
 *
 *  Purpose:
 *
 *      Implementation for IHXSite objects which are associated with
 *      platform specific window objects on Microsoft Windows and X-Windows.
 *
 */
class CHXBaseSite : 
public SiteNonDelegatingUnknown,
 public IHXSite2,
 public IHXSiteTreeNavigation,
 public IHXSiteWindowed,
 public IHXSiteWindowless,
 public IHXCallback,
 public IHXStatusMessage,
 public IHXSiteFullScreen,
 public IHXVideoControl,
 public IHXInterruptSafe,
 public IHXSiteTransition,
 public IHXSiteComposition,
 public IHXKeyBoardFocus,
 public IHXDrawFocus,
 public IHXSubRectSite
{
  public:
    
    static CHXBaseSite* CreateSite( IUnknown* pContext,
                                    IUnknown* pUnkOuter = NULL,
                                    INT32 lZorder = 0);
    static BOOL             zm_bInFullScreenTest;
    ColorFuncAccess*        zm_pColorAcc;
    static CHXSimpleList    zm_YUVSiteList;

    LONG32                 m_lRefCount;
    IUnknown*              m_pUnkOuter;
    CHXHeader*             m_pValues;
    CHXMapPtrToPtr         m_ChildrenMap;
    CHXSimpleList          m_ChildrenInZOrder;
    CHXSimpleList          m_PassiveSiteWatchers;
    IHXSiteUser*          m_pUser;
    CHXBaseSite*           m_pParentSite;
    CHXBaseSite*           m_pTopLevelSite;
    CHXBaseSite*           m_pFocusSite;
    CBaseSurface*          m_pVideoSurface;
    CHXSiteStatusText*     m_pStatusText;
    UINT32                 m_nStatusTextExpireTime;
    BaseSiteCallback*      m_pCallback;
    ScrollSiteCallback*    m_pScrollSiteCallback;
    IHXCommonClassFactory*m_pCCF;
    IHXSiteWatcher*       m_pWatcher;
    IUnknown*              m_pContext;
    HXxSize                m_size;
    HXMutex*              m_pMutex;
    HXxPoint               m_position;
    HXxPoint               m_positionOrig;
    HXxPoint               m_CreateWindowPos;
    HXxPoint               m_topleft;
    INT32                  m_lZOrder;
    BOOL                   m_bIsVisible;
    LONG32                 m_lBltEntryCount;
    BOOL                   m_bInDestructor;
    BOOL                   m_bIsChildWindow;
    BOOL                   m_bRecomputeClipScheduled;
    BOOL                   m_bForceRedrawNeeded;
    BOOL                   m_bRepaintScheduled;
    BOOL                   m_bInFullScreen;
    BOOL                   m_bSettingDisplayMode;
    BOOL                   m_bDisableForceRedraw;
    BOOL                   m_bProcessRepaint;
    BOOL                   m_bWasTopMost;
    BOOL                   m_bModeSharpness;
    BOOL                   m_bAboutToBlt;
    CBaseRootSurface*      m_pRootSurface;
    HXREGION*                m_pDirtyRegion;
    BOOL                   m_bSetCaptureOn;
    IHXSiteUser*          m_pCaptureUser;
    IHXSiteUser*          m_pLastUser;
    CHXBaseSite*           m_pMouseInSite;
    CallbackHandle         m_CallbackHandle;
    CallbackHandle         m_ScrollSiteCallbackHandle;
    IHXScheduler*         m_pScheduler;
    HXxPoint               m_windowPosition;
    HXxSize                m_windowSize;
    HXxPoint               m_screenOffset;
    BOOL                   m_bDoNotGenerateWMPPaint;
    UINT32                 m_nLastMoveTime;
    BOOL                   m_bAttachWindowPending;
    BOOL                   m_bDetachWndMsgPending;
    UINT16                 m_nOldBitsPerPixel;
    UINT16                 m_nOldHorzRes;
    UINT16                 m_nOldVertRes;
    float                  m_fSharpness;
    float                  m_fHue;
    float                  m_fSaturation;
    float                  m_fContrast;
    float                  m_fBrightness;
    INT32                  m_XSliderPos;   
    INT32                  m_YSliderPos;   
    INT32                  m_XSliderRange;
    INT32                  m_YSliderRange;
    CHXSimpleList          m_PendingTaskList;
    TransitionType         m_fpTransitionEffect;
    HXxWindow              m_TopLevelWindow;
    HXxWindow*             m_pWindow;
    HXxRect                m_rectOldClientRect;
    HXREGION*                m_Region;
    HXREGION*                m_RegionForMouse;
    HXREGION*                m_RegionWithoutChildren;
    INT32                  m_nDelayFillBorders;
    INT32                  m_nTransitionState;
    BOOL                   m_bTransitionReversed;
    BOOL                   m_bTransitionTranIn;
    INT32                  m_nTransitionVertRepeat;
    INT32                  m_nTransitionHorzRepeat;
    INT32                  m_nTransitionBorderWidth;
    tranLines              m_TransitionBorderLines;
    ULONG32                m_ulTransitionBorderColor;
    ULONG32                m_ulTransitionFadeColor;
    BOOL                   m_bTransitionBlendBorder;
    BOOL                   m_bTransitionCoordinated;
    BOOL                   m_bTransitionCoordTranIsParentClip;
    BOOL                   m_bRegionIsValid;
    BOOL                   m_bWindowCreatedByCreate;
    BOOL                   m_bCalledComputeClipFromTransition;
    INT32                  m_nEventSensitivity;
    CHXMapPtrToPtr         m_upgradeMap;
    BOOL                   m_bScheduleUpgrade;
    CHXSimpleList          m_ListOfRealVideoSites;
    BOOL                   m_bVideoUnderTransition;
    BOOL                   m_bInForceRedraw;
    BOOL                   m_bSiteRefresh;
    BOOL                   m_bTestWindowing;
    INT32                  m_nWindowColor;
    BOOL                   m_bPostageStamp;
    BOOL                   m_bBltHasBeenCalled;
    HXxRect                m_UpdateBltStatsRect;
    BOOL                   m_bScrollingSite;
   
    // IHXKeyBoardFocus
    IHXSiteUser*          m_pKeyBoardFocusUser;

    // IHXDrawFocus
    enum
        {
            DRAW_RECT           = 1, 
            DRAW_ELLIPSE        = 1<<1, 
            DRAW_POLYGON        = 1<<2
        };
    
    typedef struct _FocusRect_t
    {
        union
        {
            HXxRect rcFocus;
            
            struct
            {
                HXxPoint* pFocusPoints;
                UINT32    ulFocusPoints;
            } polygon;
        };
        
        UINT32     ulShape;
        UINT32     ulLineStyle;
        UINT32     ulLineWidth;
      
        UINT8      red, green, blue;
        UINT8      red2, green2, blue2;

        IHXBuffer *pCustomPattern;
        UINT32     ulCustomEntries;

        BOOL       bRectActive;
        BOOL       bSecondaryColors;
        
    } tFocusRect;
    
    tFocusRect             m_rcFocusRect;
   
    typedef enum 
    {
        ONMOVEWINDOW = 0
        , ONUPDATEWINDOW
        , ONSHOWWINDOW
        , ONSETWINDOWPOS
        , ONSETWINDOWREGION
        , ONSETXSLIDER
        , ONSETYSLIDER
        , ONSETFOCUS
        , ONSETSIZE
        , ONSETPOSITION
    } PendingTaskType;

    struct PendingTask
    {
        PendingTask( PendingTaskType uTaskType,
                     CHXBaseSite*    pThis,
                     void*           ulArg1 = 0,
                     void*           ulArg2 = 0,
                     void*           ulArg3 = 0,
                     void*           ulArg4 = 0,
                     void*           ulArg5 = 0,
                     void*           ulArg6 = 0,
                     void*           ulArg7 = 0
                     )
            {
                m_pThis    = pThis;
                m_TaskType = uTaskType;
                m_ulArg1   = ulArg1;
                m_ulArg2   = ulArg2;
                m_ulArg3   = ulArg3;
                m_ulArg4   = ulArg4;
                m_ulArg5   = ulArg5;
                m_ulArg6   = ulArg6;
                m_ulArg7   = ulArg7;
            };
      
        PendingTaskType m_TaskType;
        CHXBaseSite*    m_pThis;
        void*           m_ulArg1;
        void*           m_ulArg2;
        void*           m_ulArg3;
        void*           m_ulArg4;
        void*           m_ulArg5;
        void*           m_ulArg6;
        void*           m_ulArg7;
    };


    /*
     * SiteNonDelegatingUnknown methods
     */
    STDMETHOD(SiteNonDelegatingQueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,SiteNonDelegatingAddRef) (THIS);
    STDMETHOD_(ULONG32,SiteNonDelegatingRelease) (THIS);
    
    /*
     * IUnknown
     */
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef) (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     * IHXSiteWindowless
     */
    STDMETHOD(EventOccurred)(THIS_ HXxEvent* /*IN*/ pEvent);
    STDMETHOD_(HXxWindow*,GetParentWindow)(THIS);

    /*
     * IHXSiteWindowed
     */

    STDMETHOD(AttachWindow) (THIS_ HXxWindow* /*IN*/ pWindow);
    STDMETHOD(DetachWindow) (THIS);
    STDMETHOD(Create) (THIS_ void* ParentWindow, UINT32 style);
    STDMETHOD(Destroy) (THIS);
    STDMETHOD_(HXxWindow*,GetWindow)(THIS);

    /*
     * IHXSite methods
     */

    STDMETHOD(AttachUser) (THIS_ IHXSiteUser*   /*IN*/  pUser);
    STDMETHOD(DetachUser) (THIS);
    STDMETHOD(GetUser) (THIS_ REF(IHXSiteUser*) /*OUT*/ pUser);
    STDMETHOD(CreateChild) (THIS_ REF(IHXSite*)  /*OUT*/ pChildSite);
    STDMETHOD(DestroyChild) (THIS_ IHXSite*       /*IN*/  pChildSite);
    STDMETHOD(AttachWatcher) (THIS_ IHXSiteWatcher* /*IN*/ pWatcher);
    STDMETHOD(DetachWatcher) (THIS);
    STDMETHOD(SetPosition) (THIS_ HXxPoint position);
    STDMETHOD(GetPosition) (THIS_ REF(HXxPoint) position);
    STDMETHOD(SetSize) (THIS_ HXxSize size);
    STDMETHOD(GetSize) (THIS_ REF(HXxSize) size);
    STDMETHOD(DamageRect) (THIS_ HXxRect rect);
    STDMETHOD(DamageRegion) (THIS_ HXxRegion region);
    STDMETHOD(ForceRedraw) (THIS);

    //
    // IHXComposition methods
    //
    STDMETHOD(LockComposition) (THIS);
    STDMETHOD(UnlockComposition) (THIS);
    STDMETHOD(BltComposition) (THIS);
    STDMETHOD(SetCompositionMode) (THIS_ BOOL OnOrOff);
    STDMETHOD_(BOOL, IsCompositionLocked) (THIS);
    STDMETHOD_(BOOL, IsCompositionMode) (THIS);

    /*
     * IHXSite2 methods
     */

    STDMETHOD(UpdateSiteWindow) (THIS_ HXxWindow* /*IN*/ pWindow);
    STDMETHOD(ShowSite) (THIS_ BOOL    bShow);
    STDMETHOD_(BOOL, IsSiteVisible) (THIS);
    STDMETHOD(SetZOrder) (THIS_ INT32 lZOrder);
    STDMETHOD(GetZOrder) (THIS_ REF(INT32) lZOrder);
    STDMETHOD(MoveSiteToTop) (THIS);
    STDMETHOD(GetVideoSurface) (THIS_ REF(IHXVideoSurface*) pSurface);
    STDMETHOD_(UINT32,GetNumberOfChildSites) (THIS);
    STDMETHOD(AddPassiveSiteWatcher) (THIS_ IHXPassiveSiteWatcher* pWatcher);
    STDMETHOD(RemovePassiveSiteWatcher) (THIS_ IHXPassiveSiteWatcher* pWatcher);
    STDMETHOD(SetCursor) (THIS_ HXxCursor cursor, REF(HXxCursor) oldCursor);

    /*
     * IHXSiteTreeNavigation methods
     */

    STDMETHOD(GetParentSite) (THIS_ REF(IHXSite*) pParentSite);

    STDMETHOD(GetNthChildSite) (THIS_ ULONG32 ulIndex, REF(IHXSite*) pSite);

    /*
     *  IHXCallback methods
     */
    STDMETHOD(Func) (THIS);

    /*
     * IHXStatusMessage methods
     */
    
    STDMETHOD(SetStatus) (THIS_ const char* pText);

    /*
     * IHXSiteFullScreen methods
     */
    STDMETHOD(EnterFullScreen) (THIS);
    STDMETHOD(ExitFullScreen) (THIS);
    STDMETHOD(TestFullScreen) (THIS_ void* hTestBitmap,const char* pszStatusText);
    STDMETHOD_(BOOL, IsFullScreen) (THIS);
    
    /*
     * IHXVideoControls methods
     */

    STDMETHOD_(float, GetBrightness) (THIS);
    STDMETHOD(SetBrightness) (THIS_ float Brightness);
    STDMETHOD_(float, GetContrast) (THIS);
    STDMETHOD(SetContrast) (THIS_ float Contrast);
    STDMETHOD_(float, GetSaturation) (THIS);
    STDMETHOD(SetSaturation) (THIS_ float Saturation);
    STDMETHOD_(float, GetHue) (THIS);
    STDMETHOD(SetHue) (THIS_ float Hue);
    STDMETHOD_(float, GetSharpness) (THIS);
    STDMETHOD(SetSharpness) (THIS_ float Sharpness);
    STDMETHOD(SetModeSharpness) (THIS_ UINT16 dFlag);

    /************************************************************************
     *  Method:
     *      IHXInterruptSafe::IsInterruptSafe
     *  Purpose:
     *      This is the function that will be called to determine if
     *      interrupt time execution is supported.
     */
    STDMETHOD_(BOOL,IsInterruptSafe) (THIS);

    /*
     * IHXSiteTransition methods
     */

    STDMETHOD(Initialize) (THIS_ IHXValues* pParams) ;
    STDMETHOD(SetPercentage) (THIS_ UINT32 nThousandnthsComplete) ;

    /*
     * IHXKeyBoardFocus methods
     */

    STDMETHOD(SetKeyboardFocus)(THIS_ IHXSiteUser* pSiteUser );
    STDMETHOD(GetKeyboardFocus)(THIS_ IHXSiteUser* &pSiteUser );

    /*
     * IHXDrawFocus methods
     */

    STDMETHOD(SetStyle)(THIS_ IHXValues* pProperties);
    STDMETHOD(ClearFocus)(THIS);
    STDMETHOD(SetFocusPolygon)(THIS_  HXxPoint* pPoints, ULONG32 numPoints);
    STDMETHOD(SetFocusRect) (THIS_ HXxRect* pRect);
    STDMETHOD(SetFocusEllipse) (THIS_ HXxRect* pRect);

    /*
     * IHXSubRectSite methods
     */
    STDMETHOD(SendSubRectMessages) (THIS_ BOOL bRet );
    STDMETHOD(SubRectDamageRegion) (THIS_ HXxBoxRegion* pRegion );
    STDMETHOD(GetSubRectVideoSurface)(THIS_ REF(IHXSubRectVideoSurface*) pSurface );


    //
    // Debug methods...
    //

    void DisplaySiteData(const char *);
    void DisplayChildSiteData(const char *);
    void DisplayAllSiteData();
    void VerifyNoDups( CHXMapPtrToPtr& map, HXREGION* reg );

   
    //
    //InLine Methods
    //
    void SetOrigin(HXxPoint* pOrigin) {memcpy(&m_topleft, pOrigin, sizeof(HXxPoint));} /* Flawfinder: ignore */
    HXxPoint* GetOrigin() {return &m_topleft;}
    void SetInternalZOrder(INT32 lZOrder) {m_lZOrder = lZOrder;};
    void SetFocusSite(CHXBaseSite* pFocusSite) {m_pFocusSite = pFocusSite;}
    CHXBaseSite* GetFocusSite() {return m_pFocusSite;}
    BOOL IsMoving() {return FALSE;}//m_bMoving;}
   
    //
    // Internal Functions
    //
    CHXBaseSite(IUnknown* pContext, IUnknown* pUnkOuter = NULL, INT32 lZorder = 0);
    virtual         ~CHXBaseSite();

    CBaseRootSurface* GetRootSurface();

   
    void            SetParentSite(CHXBaseSite* pParentSite);
    void            SetTopLevelSite(CHXBaseSite* pTop);
    CHXBaseSite*    GetParentSite() {return m_pParentSite;}
    CHXBaseSite*    GetTopLevelSite();
    CHXBaseSite*    GetContainingCHXBaseSite();
    void            UpdateZOrder( CHXBaseSite* pUpdatedChildSite,
                                  INT32 lOldZOrder,
                                  INT32 lNewZOrder);
    HXxPoint        GetScreenOffset();
    void            SetXSliderRange(INT32);
    INT32           GetXSliderRange();
    void            SetYSliderRange(INT32);
    INT32           GetYSliderRange();
    INT32           GetXSliderPos();
    INT32           GetYSliderPos();
    INT32           GetSliderWidth();
    INT32           GetSliderHeight();
    void            GetWindowRect(HXxRect* pRect);
    void            GetExtentsWithoutChildren(HXxRect* pRect);
    void            RecursiveSizeSliders();
    void            SizeSliders();
    void            FuncSizeSliders();
    HX_RESULT       ConvertStringToXYDepth(const char* pszModeString,
                                           REF(INT32) x,
                                           REF(INT32) y,
                                           REF(INT32) depth);
    void            SetDisplayMode();
    BOOL            GenerateMouseLeaveMessage();
    void            CheckExposeEvents();
    BOOL            ComputeSubRects();
    void            BuildParnetClipping( HXREGION* hClip, CHXBaseSite* pChild );
    BOOL            m_bUsingList;
    void            SetClipping();
    BOOL            AreVideoControlsActive();
    BOOL            IsHigherZOrderTranstitionActive();
    void            FindLinkedSites();
   
    //Alpha blending support....
    CHXMapPtrToPtr  m_AlphaBlendSites;     //Who is under us that we blend with
    CHXMapPtrToPtr  m_AlphaBlendNotifiers; //who we notify when we change.
    BOOL            m_bSiteNeverBlts;
    BOOL            _CheckForVisibleChild();
    void            AlphaBlendComputeSubRects( CHXBaseSite* pIgnoredSite );
    void            AlphaBlendBuildParnetClipping( HXREGION* hClip,
                                                   CHXBaseSite* pChild,
                                                   CHXBaseSite* pIgnoredSite );
    void            _RemoveAllNotifiers();
    void            _RemoveAllYUVImageLists();

    void            _EmptyBlenderList();
    void            _EmptyNotifierList();
    void            _AlphaBlendAddNotifier(CHXBaseSite* it);

    void            _RemoveHigherOrderSiblings( HXREGION* hClip, CHXBaseSite* pChild );

    BOOL            _BlendedBordersActive();
    BOOL            _FadeTransitionActive();
    BOOL            _BordersActive();
    BOOL            _IsAlphaBlending();
   
    //End alpha support....

    //IHXComposition support
    BOOL            m_bCompositionLocked;
    BOOL            m_bCompositionMode;

    void            UpdateModes();
    BOOL            DoesPrefExist(INT32 resolutionX,
                                  INT32 resolutionY,
                                  INT32 colorDepth);
    void            UpdatePrefs(INT32 resolutionX,
                                INT32 resolutionY,
                                INT32 colorDepth,
                                ULONG32 ulBltTime,
                                BOOL bPassed,
                                BOOL bTested);
   
    void              ScheduleCallback( INT32 nWhichCallback,
                                        INT32 nMilliseconds,
                                        BOOL  bOverrideCompositionMode=FALSE);

    BOOL            IsPointInClippingRegion(HXxPoint* pPoint);
    void            SetEvent(REF(HXxEvent) theEvent,
                             ULONG32 event,
                             void* window,
                             void* param1,
                             void* param2);
    void            CheckDisplayMode(void* hdc);
    void            ChangeResolution();
    void            DestroySurfaces();
    void            ReInitSurfaces();
    void            RecomputeClip();
    void             FindVideoSites();

    INT32           GetTopMostSiteZOrder();
    void            SetParentWindow(HXxWindow* pWindow);
    void            SetRootSurface(CBaseRootSurface* pSurface);
    virtual void    CheckColorSettings();
    BOOL            SharpenImage( HXBitmapInfoHeader* pOptimizedFormat,
                                  UCHAR* pImageBits,
                                  REF(HXxRect) rSrcRect);
    void            SiteMoving(INT32 x, INT32 y);
    void            ResetOrigin();
    void            GetAbsoluteCords(REF(HXxPoint) point);
    void            AboutToBlt();
    void            FillColorKey();
    BOOL            SafeMoveWindow(void* hWnd,
                                   INT32 X,
                                   INT32 Y,
                                   INT32 nWidth,
                                   INT32 nHeight,
                                   BOOL bRepaint);
    BOOL            SafeUpdateWindow(void* hWnd);
    BOOL            SafeShowWindow(void* hWnd, INT32 nCmdShow);
    BOOL            SafeSetWindowPos(void* hWnd,
                                     void* hWndInsertAfter,
                                     INT32 X,
                                     INT32 Y,
                                     INT32 cx,
                                     INT32 cy,
                                     UINT uFlags);
    INT32           SafeSetWindowRgn(void* hWnd, HXREGION* hRgn, BOOL bRedraw);
    void            SafeSetXSliderRange(INT32 range);
    void            SafeSetYSliderRange(INT32 range);
    void            SafeSetFocus(HXxWindow* pWindow);
    HX_RESULT       _SafeSetSize(HXxSize size);
    HX_RESULT       _SafeSetPosition(HXxPoint position);
   
    void            ExecutePendingTasks();
    void            RemovePendingTasks(CHXBaseSite*);
    void            ResetUpdateOverlay();
    void            SiteNotMoving();

    void            _ForceRedrawAll();
    void            InternalForceRedraw();
    void            LockBlitters();
    void            UnlockBlitters();
    void            FlushSurfaces();
    
    void            DisableColorControls(float &fBrightness,
                                         float &fContrast,
                                         float &fSaturation,
                                         float &fHue);

    void            EnableColorControls(float fBrightness,
                                        float fContrast,
                                        float fSaturation,
                                        float fHue);
    /*
     *	Small HXColor support
     */
    void ColorConverterRequest(int CIDin, int CIDout, BOOL bFoundConverter);
    void InternalColorConverterRequest(int CIDin, int CIDout, BOOL bFoundConverter, CHXBaseSite* pSite);
    void ScheduleUpgrade();
    void InternalScheduleUpgrade(UINT32 CIDIn, UINT32 CIDOut, IHXSite* pSite);

    /*
     *  OS Specific Functions
     */

    /************************************************************************
     *  Method:
     *      _NeedWindowedSite
     *  Purpose:
     *      Create a windowed site
     */
    virtual void        _NeedWindowedSite() = 0;

    /************************************************************************
     *  Method:
     *      _AttachWindow
     *  Purpose:
     *      A window is assigned to the site so perform any required window
     *      initialization code.
     */
    virtual void        _AttachWindow() = 0;

    /************************************************************************
     *  Method:
     *      _DetachWindow
     *  Purpose:
     *      The window is removed from the site so perform any required window
     *      clean-up code.
     */
    virtual void        _DetachWindow() = 0;

    /************************************************************************
     *  Method:
     *      _Create
     *  Purpose:
     *      Create a window of type style with ParentWindow as its parent
     */
    virtual void*       _Create(void* ParentWindow, UINT32 style) = 0;

    /************************************************************************
     *  Method:
     *      _Destroy
     *  Purpose:
     *      Destroy this window
     */
    virtual void        _Destroy(HXxWindow* pWindow) = 0;

    /************************************************************************
     *  Method:
     *      _SetSize
     *  Purpose:
     *      Set the size of the window to size
     */
    virtual void        _SetSize(HXxSize size) = 0;

    /************************************************************************
     *  Method:
     *      _SetPosition
     *  Purpose:
     *      Set the position of the window to position
     */
    virtual void        _SetPosition(HXxPoint position) = 0;

    /************************************************************************
     *  Method:
     *      _DamageRect
     *  Purpose:
     *      Mark this area of the window for redrawing
     */
    virtual void        _DamageRect(HXxRect rect) = 0;

    /************************************************************************
     *  Method:
     *      _DamageRegion
     *  Purpose:
     *      Mark this area of the window for redrawing
     */
    virtual void        _DamageRegion(HXxRegion rect) = 0;

    /************************************************************************
     *  Method:
     *      _ShouldEnterForceRedraw
     *  Purpose:
     *      Serialize our drawing routines
     */
    virtual BOOL        _ShouldEnterForceRedraw() = 0;

    /************************************************************************
     *  Method:
     *      _ExitForceRedraw
     *  Purpose:
     *      Serialize our drawing routines
     */
    virtual void        _ExitForceRedraw() = 0;

    /************************************************************************
     *  Method:
     *      _SendOSUpdateMessage
     *  Purpose:
     *      Instruct the window to update itself
     */
    virtual void        _SendOSUpdateMessage() = 0;

    /************************************************************************
     *  Method:
     *      _ShowSite
     *  Purpose:
     *      Show/hide the site
     */
    virtual void        _ShowSite(BOOL bShow) = 0;

    /************************************************************************
     *  Method:
     *      _AtSystemTime
     *  Purpose:
     *      Determines if this call is on the main app thread
     */
    virtual BOOL        _AtSystemTime() = 0;

    /************************************************************************
     *  Method:
     *      _EventOccurred
     *  Purpose:
     *      Process the current event
     */
    virtual HX_RESULT   _EventOccurred(HXxEvent* /*IN*/ pEvent) = 0;

    /************************************************************************
     *  Method:
     *      _GetDeviceCaps
     *  Purpose:
     *      Query the current display mode for bit depth, width and height
     */
    virtual void        _GetDeviceCaps( void* hdc,
                                        UINT16& uBitesPerPixel,
                                        UINT16& uHorzRes,
                                        UINT16& uVertRes) = 0;

    /************************************************************************
     *  Method:
     *      _GetWindowRect
     *  Purpose:
     *      Get the screen coordinates of the window
     */
    virtual void        _GetWindowRect(HXxRect* destRect) = 0;

    /************************************************************************
     *  Method:
     *      _DestroySliders
     *  Purpose:
     *      Destroys the x/y scroll bars
     */
    virtual void        _DestroySliders() = 0;

    /************************************************************************
     *  Method:
     *      _HandleOSEvents
     *  Purpose:
     *      Handle this event
     */
    virtual BOOL        _HandleOSEvents(HXxEvent* /*IN*/ pEvent) = 0;

    /************************************************************************
     *  Method:
     *      _ConvertToHXEvent
     *  Purpose:
     *      Convert an OS event to a Helix event
     */
    virtual BOOL        _ConvertToHXEvent( HXxEvent* pEvent ) = 0;

    /************************************************************************
     *  Method:
     *      _GenerateOSEvent
     *  Purpose:
     *      Generate an OS event from a Helix event
     */
    virtual void        _GenerateOSEvent(HXxEvent* pEvent, HXxEvent* pEvent2) = 0;

    /************************************************************************
     *  Method:
     *      _GenerateSetCursorEvent
     *  Purpose:
     *      Generate as OS set cursor event
     */
    virtual void        _GenerateSetCursorEvent() = 0;

    /************************************************************************
     *  Method:
     *      _EnterFullScreen
     *  Purpose:
     *      Enter into full screen display mode
     */
    virtual HX_RESULT   _EnterFullScreen() = 0;

    /************************************************************************
     *  Method:
     *      _ExitFullScreen
     *  Purpose:
     *      Leave full screen display mode
     */
    virtual HX_RESULT   _ExitFullScreen() = 0;

    /************************************************************************
     *  Method:
     *      _TestFullScreen
     *  Purpose:
     *      Test full screen performance
     */
    virtual HX_RESULT   _TestFullScreen( void* hTestBitmap,
                                         const char* pszStatusText) = 0;

    /************************************************************************
     *  Method:
     *      _TryCreateXSlider
     *  Purpose:
     *      Create a horizontal scroll bar
     */
    virtual void _TryCreateXSlider() = 0;

    /************************************************************************
     *  Method:
     *      _SetXSliderValues
     *  Purpose:
     *      Set the range and step size of the horizontal scroll bar
     */
    virtual void _SetXSliderValues(INT32 range, INT32 pageSize) = 0;

    /************************************************************************
     *  Method:
     *      _TryCreateYSlider
     *  Purpose:
     *      Create a vertical scroll bar
     */
    virtual void _TryCreateYSlider() = 0;

    /************************************************************************
     *  Method:
     *      _SetYSliderValues
     *  Purpose:
     *      Set the range and step size of the vertical scroll bar
     */
    virtual void _SetYSliderValues(INT32 range, INT32 pageSize) = 0;

    /************************************************************************
     *  Method:
     *      _GetSystemSizeOfSliders
     *  Purpose:
     *      Get the pixel size of a scroll bar
     */
    virtual void _GetSystemSizeOfSliders(INT32* pWidth, INT32* pHeight) = 0;

    /************************************************************************
     *  Method:
     *      _IsWindowVisible
     *  Purpose:
     *      Is this site's window visible
     */
    virtual BOOL _IsWindowVisible() = 0;

    /************************************************************************
     *  Method:
     *      _ShowXSlider
     *  Purpose:
     *      Show/hide the horizontal scroll bar
     */
    virtual void _ShowXSlider(BOOL bShow) = 0;

    /************************************************************************
     *  Method:
     *      _MoveXSlider
     *  Purpose:
     *      Set the size and position of the horizontal scroll bar
     */
    virtual void _MoveXSlider(INT32 left, INT32 top,
                              INT32 right, INT32 bottom,
                              BOOL bRedraw) = 0;
    /************************************************************************
     *  Method:
     *      _ShowXSlider
     *  Purpose:
     *      Show/hide the vertical scroll bar
     */
    virtual void _ShowYSlider(BOOL bShow) = 0;

    /************************************************************************
     *  Method:
     *      _MoveYSlider
     *  Purpose:
     *      Set the size and position of the vertical scroll bar
     */
    virtual void _MoveYSlider(INT32 left, INT32 top,
                              INT32 right, INT32 bottom,
                              BOOL bRedraw) = 0;
    
    /************************************************************************
     *  Method:
     *      _DoesXSliderExist
     *  Purpose:
     *      Have we created a horizontal slider
     */
    virtual BOOL _DoesXSliderExist() = 0;

    /************************************************************************
     *  Method:
     *      _GetContainingWindow
     *  Purpose:
     *      Get the window that contains the full screen window
     */
    virtual void*_GetContainingWindow() = 0; // XXXAH void*? Not HXxWindow??

    /************************************************************************
     *  Method:
     *      _GetCursorPos
     *  Purpose:
     *      Get the position of the cursor in screen coordinates
     */
    virtual void _GetCursorPos(HXxPoint* pPoint) = 0;

    /************************************************************************
     *  Method:
     *      _MapPointToOSWindow
     *  Purpose:
     *      Find which window contains this point
     */
    virtual void _MapPointToOSWindow(HXxPoint* pPt, void** pWindowHandle) = 0;
   
    /************************************************************************
     *  Method:
     *      _GetWindowWithCursor
     *  Purpose:
     *      This returns the OS specific window handle, as void*, that the
     *      pointer is currently in.
     */
    virtual void* _GetWindowWithCursor() = 0;

    /************************************************************************
     *  Method:
     *      _ReInitPrimarySurface
     *  Purpose:
     *      Restore the primary surface, if necessary, after a mode/resolution
     *      change.
     */
    virtual void  _ReInitPrimarySurface() = 0; // XXXAH may want to move this to root.
                 
    /************************************************************************
     *  Method:
     *      _MoveWindow
     *  Purpose:
     *      Change the size and position of the window.  For the top level
     *      site, these are screen coordinates, for children sites, they
     *      are relative.
     */
    virtual BOOL  _MoveWindow( void* ,
                               INT32 X, INT32 Y,
                               INT32 nWidth, INT32 nHeight,
                               BOOL bRepaint) = 0;

    /************************************************************************
     *  Method:
     *      _UpdateWindow
     *  Purpose:
     *      Sends an OS message to the window to updat the client area
     */
    virtual BOOL  _UpdateWindow(void* hWnd) = 0;

    /************************************************************************
     *  Method:
     *      _ShowWindow
     *  Purpose:
     *      Show/hide the window
     */
    virtual BOOL  _ShowWindow(void* hWnd, INT32 nCmdShow) = 0;

    /************************************************************************
     *  Method:
     *      _SetWindowPos
     *  Purpose:
     *      Sets the size, position, and z-order of the window
     */
    virtual BOOL  _SetWindowPos(void* hWnd,
                                void* hWndInsertAfter,
                                INT32 X, INT32 Y,
                                INT32 cx, INT32 cy,
                                INT32 uFlags) = 0;

    virtual void  _DrawFocusRect(UCHAR* pImage,
                                 HXBitmapInfoHeader* pImageInfo,
                                 HXxRect* pImageSize,
                                 void* pOsSpecificData=NULL);

    BOOL           HasFocusRect() {return m_rcFocusRect.bRectActive;}
    
    void ManageExposeEvents( HXxRect* dirtyRect );
    void _RecursiveDamageRect( HXxRect* dirtyRect, BOOL bForce=FALSE );
    void DamageRectWindowRel(HXxRect rect);

    // this is going to be a nice one.
    virtual BOOL _SetWindowRgn(void* hWnd, HXREGION* hRgn, BOOL bRedraw) = 0;
    // XXXAH it would be nice to get the return value here
    virtual void _SetFocus(void* pWindow) = 0;
    BOOL         _TakesPartInAlphaChain();
    HXREGION*      Transition(INT32 left, INT32 top, INT32 right, INT32 bottom, tranLines* lines = NULL);

    //XXXgfw just some hacks to help us get trylocks with the top
    //level site mutexes.
    void _TLSLock();
    void _TLSUnlock();
    BOOL _TLSIsLocked();
    inline BOOL SiteScaleingInfoAvailable(){
        return m_bSiteScalingInfo;
    }
    

  protected:
    void         _HandleMouseEvent(HXxEvent* pEvent);
    CHXBaseSite* _GetSiteFromPixel(HXxPoint& point);

    virtual void CreateColorAccess(IUnknown* pUnk) {zm_pColorAcc = new ColorFuncAccess(pUnk);}
    
    INT32      m_nTLSMutexLockCount;
    UINT32     m_ulTLSMutexOwningThread;
    HXThread* m_pDummyThread;
    BOOL       m_bMoving;
    BOOL       m_bUserWantsSubRects;
    BOOL       m_bSiteScalingInfo;

};


class BaseSiteCallback : public IHXCallback
{
  public:
    CHXBaseSite*  m_pSite;
    CBaseSurface* m_pSurf;
   
    BaseSiteCallback(CHXBaseSite* pSite);
    ~BaseSiteCallback();
    /*
     *  IUnknown methods
     */
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef) (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     *  IHXCallback methods
     */
    STDMETHOD(Func) (THIS);

  protected:

    LONG32 m_lRefCount;
};

class ScrollSiteCallback : public IHXCallback
{
public:
    ScrollSiteCallback(CHXBaseSite* pSite);
    ~ScrollSiteCallback();

    /*
     *  IUnknown methods
     */
    STDMETHOD(QueryInterface) (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef) (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     *  IHXCallback methods
     */
    STDMETHOD(Func) (THIS);
protected:
    LONG32       m_lRefCount;
    CHXBaseSite* m_pSite;
};


#endif /* _BASESITE_H_ */




