/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: baseroot.cpp,v 1.6.4.2 2004/07/26 10:27:16 pankajgupta Exp $
 *
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 *
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 *
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 *
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 *
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 *
 * Contributor(s):
 *
 * ***** END LICENSE BLOCK ***** */

#include "hxcom.h"
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxvsurf.h"
#include "hxslist.h"
#include "hxthread.h"

#if defined(_WINDOWS)
#include "winroot.h"	// must be included before colormap.h
#endif

#include "baseroot.h"
#include "coloracc.h"
#include "colormap.h"
//XXXgfw just to cletbiean up the code. We still *REALLY* need to clean
//this up.
#ifdef _WIN32
#define GETBITMAPCOLOR(x) GetBitmapColor( (LPBITMAPINFO)(x) )
#else
#define GETBITMAPCOLOR(x) GetBitmapColor( (HXBitmapInfo*)(x))
#endif
#ifdef _WIN32
#define GETBITMAPPITCH(x) GetBitmapPitch( (LPBITMAPINFO)(x) )
#else
#define GETBITMAPPITCH(x) GetBitmapPitch( (HXBitmapInfo*)(x))
#endif

#include "basesurf.h"
#include "basesite.h"
#include "hxprefs.h"
#include "hxtick.h"

#if defined(_UNIX) && !defined(_MAC_UNIX)
#  include "unixroot.h"
#endif

#if defined(_MACINTOSH) || defined(_MAC_UNIX)
#include "platform/mac/macroot.h"
#endif

#include "sitefact.h"

#if defined(HELIX_FEATURE_PREFERENCES)
#include "hxprefs.h"
#include "hxprefutil.h"
#endif /* HELIX_FEATURE_PREFERENCES */

#ifdef _DEBUG
#undef HX_THIS_FILE
static const char HX_THIS_FILE[] = __FILE__;
#endif

#define RED     0x00ff0000
#define GREEN   0x0000ff00
#define BLUE    0x000000ff

//#define _CHECK_CONVERSION_DATA
//#define _WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG

CBaseRootSurface::CBaseRootSurface(IUnknown* pContext, CHXBaseSite* pSite)
    : m_lRefCount(0)
    , m_pContext(pContext)
    , m_pSite(pSite)
    , m_fSurfaceType(0)
    , m_pMutex(NULL)
    , m_pCompMutex(NULL)
    , m_nBLTMode(0)
    , m_pCompositionSurface(NULL)
    , m_bCompositionSurfaceCreated(FALSE)
#ifdef _WINDOWS
    , m_pPlayer(NULL)
#endif
    , m_bUseCardMemory(FALSE)
    , m_pUnlockingSite(NULL)
    , zm_pColorAcc(NULL)
{
#ifdef _BLT_IN_DEBUG
   m_nBLTMode = HX_WINDOWLESS_DEBUG;
#else
   m_nBLTMode = HX_WINDOWLESS_MINIMAL;
#endif

   HX_ASSERT( m_pContext );
   HX_ASSERT( m_pSite );
   m_pContext->AddRef();
   m_pSite->AddRef();

#if defined(THREADS_SUPPORTED) || defined(_UNIX_THREADS_SUPPORTED)
   HXMutex::MakeMutex(m_pMutex);
   HXMutex::MakeMutex(m_pCompMutex);
#else
   HXMutex::MakeStubMutex(m_pMutex);
   HXMutex::MakeStubMutex(m_pCompMutex);
#endif

    CreateColorAccess(pContext);
    zm_pColorAcc->InitColorConverter();

   /*
    *  Determine what level of Video 'Acceleration' we want to use.
    */

   // XXXAH    we will want to unify all of the OSes to use the same value.
   //          Something like VideoAcceleration or something.
   //          For now ... "Don't break windows" (tm).

   BOOL    bUseWindraw     = TRUE;

   IHXPreferences*    pPreferences    = NULL;
   IHXBuffer*         pBuffer         = NULL;

   if (HXR_OK == m_pContext->QueryInterface(IID_IHXPreferences,(void**)&pPreferences))
   {
       ReadPrefBOOL(pPreferences, "UseWinDraw", bUseWindraw);
       ReadPrefBOOL(pPreferences, "UseCardMemory", m_bUseCardMemory);
       HX_RELEASE(pBuffer);
   }
   HX_RELEASE(pPreferences);

   if (bUseWindraw)
   {
      m_fSurfaceType  = HX_ACCELERATION_ON;
      if (m_bUseCardMemory)
      {
         m_fSurfaceType |= HX_USE_VIDEO_MEMORY;
      }
      else
      {
         m_fSurfaceType |= HX_USE_SYSTEM_MEMORY;
      }
   }
   m_boundsRect.left   = 65536;
   m_boundsRect.top    = 65536;
   m_boundsRect.right  = 0;
   m_boundsRect.bottom = 0;
}

CBaseRootSurface::~CBaseRootSurface()
{
   /*
    * Clean up the color access functions
    */
   HX_DELETE(zm_pColorAcc);

#ifdef _WINDOWS
   HX_RELEASE(m_pPlayer);
#endif

   HX_DELETE(m_pMutex);
   HX_DELETE(m_pCompMutex);
   HX_RELEASE(m_pContext);
   HX_RELEASE(m_pSite);

   while(m_pBltRects.GetCount())
   {
        HXxRect* pRect = (HXxRect*) m_pBltRects.RemoveHead();
        HX_DELETE(pRect);
   }
}


/************************************************************************
 *  Method:
 *    IUnknown::QueryInterface
 */
STDMETHODIMP CBaseRootSurface::QueryInterface(REFIID riid, void** ppvObj)
{
   if (IsEqualIID(riid, IID_IUnknown))
   {
      AddRef();
      *ppvObj = (IUnknown*)(IHXVideoSurface*)this;
      return HXR_OK;
   }

   *ppvObj = NULL;
   return HXR_NOINTERFACE;
}

/************************************************************************
 *  Method:
 *    IUnknown::AddRef
 */
STDMETHODIMP_(ULONG32)
   CBaseRootSurface::AddRef()
{
   return InterlockedIncrement(&m_lRefCount);
}

/************************************************************************
 *  Method:
 *    IUnknown::Release
 */
STDMETHODIMP_(ULONG32)
   CBaseRootSurface::Release()
{
   if (InterlockedDecrement(&m_lRefCount) > 0)
   {
      return m_lRefCount;
   }

   delete this;
   return 0;
}

void CBaseRootSurface::BltComposition()
{
    HXxRect rSrcRect;
    rSrcRect.top    = 0;
    rSrcRect.left   = 0;
    rSrcRect.right  = m_compositionSize.cx;
    rSrcRect.bottom = m_compositionSize.cy;

    //Blt the entire presentation.
    m_boundsRect.right   = m_compositionSize.cx;
    m_boundsRect.bottom  = m_compositionSize.cy;
    m_boundsRect.left    = 0;
    m_boundsRect.top     = 0;

    if( IsCompositionEnabled() )
    {
#if defined(_WINDOWS)
        _MinimalUnlock(m_pSite->GetWindow());
#else
        _MinimalBlt(rSrcRect, rSrcRect);
#endif
    }
}

STDMETHODIMP CBaseRootSurface::Blt( UCHAR*               pImageData,
                                    HXBitmapInfoHeader* pBitmapInfo,
                                    REF(HXxRect)         rDestRect,
                                    REF(HXxRect)         rSrcRect,
				    CHXBaseSite*	 pSite)
{
   HX_RESULT retVal = HXR_FAIL;

   if( NULL == pImageData || NULL == pBitmapInfo )
       return retVal;

   switch (m_nBLTMode)
   {
      case HX_WINDOWLESS_DEBUG:
         retVal = DebugBlt(pImageData, pBitmapInfo, rDestRect, rSrcRect);
         break;
      case HX_WINDOWLESS_MINIMAL:
         retVal = MinimalBlt(pImageData, pBitmapInfo, rDestRect, rSrcRect, pSite);
         break;
   }
   return retVal;
}

HX_RESULT CBaseRootSurface::DebugBlt( UCHAR*               pImageData,
                                      HXBitmapInfoHeader* pBitmapInfo,
                                      REF(HXxRect)         rDestRect,
                                      REF(HXxRect)         rSrcRect)
{
   // Use OS services to draw solid boxes with outlines. Just to see
   // what kind of freakiness is going on.
   return _DebugBlt(pImageData, pBitmapInfo, rDestRect, rSrcRect);
}

HX_RESULT CBaseRootSurface::MinimalBlt( UCHAR*               pImageData,
                                        HXBitmapInfoHeader* pBitmapInfo,
                                        REF(HXxRect)         rDestRect,
                                        REF(HXxRect)         rSrcRect,
					CHXBaseSite*	     pSite)
{
   // color convert into the surface
   HX_RESULT retVal = HXR_FAIL;

   int cidIn   = GETBITMAPCOLOR(pBitmapInfo);
   int pitchIn = GETBITMAPPITCH(pBitmapInfo);
   int nRet = 0;

#ifdef _WINDOWS
   zm_pColorAcc->SetPlayer(GetPlayer());
#endif


   BOOL bConverter = zm_pColorAcc->CheckColorConverter(cidIn, m_nCompositionSurfaceCID);
   pSite->ColorConverterRequest(cidIn, m_nCompositionSurfaceCID, bConverter);

   int dxDst = rDestRect.right  - rDestRect.left;
   int dyDst = rDestRect.bottom - rDestRect.top;
   int dxSrc = rSrcRect.right   - rSrcRect.left;
   int dySrc = rSrcRect.bottom  - rSrcRect.top;

   //Please do not freak out the color converter!
   if (dxSrc > pBitmapInfo->biWidth)
   {
      dxSrc = pBitmapInfo->biWidth;
   }

   if (dySrc > pBitmapInfo->biHeight)
   {
      dySrc = pBitmapInfo->biHeight;
   }

   //At this point I should be checking to see if the bitmap is going
   //to be stretched. If so I should consider using Direct Draw to do
   //the stretching.

   //If our input is YUV and not I420 it is unlikely that we will have
   //a color converter. So we will convert to I420 1st. Yeah, yeah, it
   //blows. Big deal.  For the moment we only look for an input in the
   //form of YUY2, XING's format.
   if(!bConverter)
   {
        UINT32 width, height;
        _GetYUVScratchWidthHeight(&width, &height);

        if (width != (UINT32) pBitmapInfo->biWidth || height != (UINT32) pBitmapInfo->biHeight)
        {
            _CreateYUVScratchSurface(pBitmapInfo->biWidth, pBitmapInfo->biHeight);
        }

        UCHAR* pYUVBits;
        INT32  nYUVPitch;
        _GetYUVScratchSurfacePointer(&pYUVBits, &nYUVPitch);
        if (pYUVBits)
        {
            #ifdef _WINDOWS
            zm_pColorAcc->SetPlayer(GetPlayer());
            #endif

            bConverter = zm_pColorAcc->CheckColorConverter(cidIn, 0);
            pSite->ColorConverterRequest(cidIn, 0, bConverter);

            if (bConverter)
            {
                nRet = zm_pColorAcc->ColorConvert(0, pYUVBits,
                                 pBitmapInfo->biWidth, pBitmapInfo->biHeight,
                                 nYUVPitch, 0, 0,
                                 pBitmapInfo->biWidth, pBitmapInfo->biHeight,
                                 cidIn, pImageData, pBitmapInfo->biWidth,
                                 pBitmapInfo->biHeight, pitchIn,
                                 0, 0, pBitmapInfo->biWidth, pBitmapInfo->biHeight);

                if (nRet == -1)
                {
                    retVal = HXR_FAIL;
                    bConverter = FALSE;
                }
                else
                {
                    cidIn       = 0;
                    pImageData  = pYUVBits;
                    pitchIn     = nYUVPitch;

                    bConverter = zm_pColorAcc->CheckColorConverter(cidIn, m_nCompositionSurfaceCID);
                    pSite->ColorConverterRequest(cidIn, m_nCompositionSurfaceCID, bConverter);
                }
            }
            else
                retVal = HXR_FAIL;
        }
   }

   if (bConverter)
   {
      m_pSite->CheckColorSettings();
#ifdef _CHECK_CONVERSION_DATA
      FILE* f1 = ::fopen("/tmp/ConversionData.txt", "a+"); /* Flawfinder: ignore */
      ::fprintf(f1, "ColorConversion (%d -> %d) (%d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d %d)\n",
                cidIn, m_nCompositionSurfaceCID, m_pCompositionSurface,
                m_allocatedCompositionSize.cx, m_allocatedCompositionSize.cy,
                m_nCompositionPitch, rDestRect.left, rDestRect.top,
                dxDst, dyDst, pImageData, pBitmapInfo->biWidth,
                pBitmapInfo->biHeight, pitchIn,
                rSrcRect.left, rSrcRect.top, dxSrc, dySrc);
      ::fclose(f1);
#endif
      int returnVal = E_FAIL;
      if (returnVal!=NOERROR)
      {
#ifdef _WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG
         /* working around a bug in the color convertor for strecth
          * larger than doubel size for YUV to RGB 16 bit conversion */
//          BOOL bUseScratch = HXDebugOptionEnabled("zUseScratch");

         if (IsYUV(cidIn) && (rSrcRect.left || rSrcRect.top))
         {
            // The color converter does not like it when we are going
            // from YUV->RGB with sub rects.  To work around this we
            // will convert THE WHOLE THING to RGB. Then we will use
            // the RGB converter to select the portion that we
            // want. BWHAHAHA!^ This sucks, HUGE.

            HXxSize tempSize;
            tempSize.cx = pBitmapInfo->biWidth;
            tempSize.cy = pBitmapInfo->biHeight;
            CreateScratchSurface(m_nCompositionSurfaceCID, &tempSize);

            UCHAR*  pScratchBits;
            INT32   nScratchPitch;
            ScratchLock(&pScratchBits, &nScratchPitch);

            // if somehow scratch surface creation failed
            if (!pScratchBits)
            {
               goto regularConvert;
            }

            returnVal = zm_pColorAcc->ColorConvert(
                                         m_nCompositionSurfaceCID,
                                         pScratchBits,
                                         m_allocatedScratchSize.cx,
                                         m_allocatedScratchSize.cy,
                                         nScratchPitch, 0, 0,
                                         pBitmapInfo->biWidth,
                                         pBitmapInfo->biHeight,
                                         cidIn, pImageData,
                                         pBitmapInfo->biWidth,
                                         pBitmapInfo->biHeight, pitchIn,
                                         0, 0, pBitmapInfo->biWidth,
                                         pBitmapInfo->biHeight);

            ScratchUnlock(pScratchBits);

            // Instead of using the RGB color converter we will simply
            // use OS services to BLT to the surface at this point (since
            // it MAY be faster at blt-ing than we are. HOWEVER, it may
            // be faster by using pixel rep to stretch. This will cause
            // visually unsatisifing blts.  But then again ... DO NOT
            // BREAK WINDOWS. XXXAH we may want to use the color
            // converter here.
            if (returnVal != -1)
                _BltFromScratchToComposition(rDestRect, rSrcRect);
         }
         else if ((IsYUV(cidIn) &&
                   (m_nCompositionSurfaceCID == CID_RGB565 ||
                    m_nCompositionSurfaceCID == CID_RGB555) &&
                   (dxDst > 2*dxSrc  ||
                    dyDst > 2*dySrc))) // || bUseScratch)
         {
            HXxSize tempSize;
            tempSize.cx = dxSrc;
            tempSize.cy = dySrc;
            CreateScratchSurface(m_nCompositionSurfaceCID, &tempSize);

            UCHAR*  pScratchBits;
            INT32   nScratchPitch;
            ScratchLock(&pScratchBits, &nScratchPitch);

            // if somehow scratch surface creation failed
            if (!pScratchBits)
            {
               goto regularConvert;
            }

            returnVal = zm_pColorAcc->ColorConvert(
                                         m_nCompositionSurfaceCID,
                                         pScratchBits,
                                         m_allocatedScratchSize.cx,
                                         m_allocatedScratchSize.cy,
                                         nScratchPitch,
                                         rSrcRect.left, rSrcRect.top,
                                         dxSrc, dySrc,
                                         cidIn, pImageData,
                                         pBitmapInfo->biWidth,
                                         pBitmapInfo->biHeight,
                                         pitchIn,
                                         rSrcRect.left, rSrcRect.top,
                                         dxSrc, dySrc);

            ScratchUnlock(pScratchBits);

            if (returnVal != -1)
                _BltFromScratchToComposition(rDestRect, rSrcRect);
         }
         else
#endif /*_WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG*/
         {
           regularConvert:
            int nCompPitch = m_nCompositionPitch;
            returnVal = zm_pColorAcc->ColorConvert(
                                          m_nCompositionSurfaceCID,
                                          m_pCompositionSurface,
                                          m_allocatedCompositionSize.cx,
                                          m_allocatedCompositionSize.cy,
                                          nCompPitch,
                                          rDestRect.left, rDestRect.top,
                                          dxDst, dyDst,
                                          cidIn,
                                          pImageData, pBitmapInfo->biWidth,
                                          pBitmapInfo->biHeight, pitchIn,
                                          rSrcRect.left, rSrcRect.top, dxSrc, dySrc);

            //XXXgfw this is weird. We only want to redraw the Dest
            //Rect right? The src is mostly always zero..
            if( !m_pSite->IsCompositionLocked() && returnVal != -1)
                _MinimalBlt(rSrcRect, rDestRect);
         }
      }
      if (!returnVal)
      {
         retVal = HXR_OK;
         ModifyBoundsRect(&rDestRect);
      }
   }
   else
   {
#ifndef _WINDOWS
      HX_ASSERT(!"Failed to get a color convertor!!!");
#endif
   }

   return retVal;
}

void CBaseRootSurface::_MinimalBlt(HXxRect&, HXxRect&)
{}

void CBaseRootSurface::DrawFocusRect(int nSurfaceCID,
                                     HXxSize *pSurfaceSize,
                                     UCHAR *pVidMem,
                                     CHXBaseSite* pSite)
{
    // Draw the focus for this site
    HXBitmapInfoHeader info;
    memset(&info, 0, sizeof(info));

#ifdef _WIN32
    BITMAPINFO bmiInfo;
    memset(&bmiInfo, 0, sizeof(bmiInfo));

    MakeBitmap(&bmiInfo, sizeof(info), nSurfaceCID,
            pSurfaceSize->cx, pSurfaceSize->cy, NULL, 0);

    info = *((HXBitmapInfoHeader*)&bmiInfo.bmiHeader);
#else
    HXBitmapInfo bmiInfo;
    memset(&bmiInfo, 0, sizeof(bmiInfo));

    MakeBitmap(&bmiInfo, sizeof(info), nSurfaceCID,
            pSurfaceSize->cx, pSurfaceSize->cy, NULL, 0);

    info = *((HXBitmapInfoHeader*)&bmiInfo.bmiHeader);
#endif

    HXxRect rc = {0,0,pSurfaceSize->cx, pSurfaceSize->cy};

    pSite->_DrawFocusRect(pVidMem,
                          &info,
                          &rc);
}

HX_RESULT CBaseRootSurface::Lock(UINT32 nID)
{
   m_pMutex->Lock();
   HX_RESULT retVal = HXR_FAIL;

   switch (m_nBLTMode)
   {
      case HX_WINDOWLESS_DEBUG:
         retVal = HXR_OK;
         break;
      case HX_WINDOWLESS_MINIMAL:
         retVal = MinimalLock();
         break;
   }

   if (HXR_OK != retVal)
   {
      m_pMutex->Unlock();
   }

   return retVal;
}

HX_RESULT CBaseRootSurface::Unlock(UINT32 nID, HXxWindow* pWindow, CHXBaseSite* pSite)
{
   HX_RESULT retVal = HXR_FAIL;
   m_pUnlockingSite = pSite;

   switch (m_nBLTMode)
   {
      case HX_WINDOWLESS_DEBUG:
         retVal = HXR_OK;
         break;
      case HX_WINDOWLESS_MINIMAL:
         retVal = MinimalUnlock(pWindow);
         break;
   }

   m_pUnlockingSite = NULL;

   m_pMutex->Unlock();
   return retVal;
}

HX_RESULT CBaseRootSurface::MinimalUnlock(HXxWindow* pWindow)
{
   // XXXAH yeah I know this sucks, but the call is ALL OS services.
    HX_RESULT retVal = HXR_OK;
    retVal = _MinimalUnlock(pWindow);
//     m_pCompositionSurface   = 0;
//     m_nCompositionPitch     = 0;
   return retVal;
}

HX_RESULT CBaseRootSurface::MinimalLock()
{
   HX_RESULT retVal = HXR_FAIL;
   HXxSize size;
   memcpy(&size, &m_pSite->m_size, sizeof(HXxSize)); /* Flawfinder: ignore */

    if (HXR_OK == SizeChanged())
    {
        if (HXR_OK == _LockComposition(&m_pCompositionSurface, &m_nCompositionPitch))
        {
            m_boundsRect.left   = 65536;
            m_boundsRect.top    = 65536;
            m_boundsRect.right  = 0;
            m_boundsRect.bottom = 0;
            retVal = HXR_OK;

            while(m_pBltRects.GetCount())
            {
                HXxRect* pRect = (HXxRect*) m_pBltRects.RemoveHead();
                HX_DELETE(pRect);
            }

            HX_ASSERT(m_pCompositionSurface);
        }
    }
    return retVal;
}

void CBaseRootSurface::ModifyBoundsRect(HXxRect* pRect)
{
    if (pRect->left < m_boundsRect.left)
    {
      m_boundsRect.left = pRect->left;
    }
    if (pRect->top < m_boundsRect.top)
    {
      m_boundsRect.top = pRect->top;
    }
    if (pRect->right > m_boundsRect.right)
    {
      m_boundsRect.right= pRect->right;
    }
    if (pRect->bottom > m_boundsRect.bottom)
    {
      m_boundsRect.bottom= pRect->bottom;
    }

    HXxRect* pTempRect = new HXxRect();
    *pTempRect = *pRect;
    m_pBltRects.AddHead(pTempRect);
}

HX_RESULT CBaseRootSurface::SizeChanged()
{
   m_pMutex->Lock();
   m_pCompMutex->Lock();
   HX_RESULT retVal = HXR_FAIL;
   HX_ASSERT(m_pSite);
   memcpy(&m_compositionSize, &m_pSite->m_size, sizeof(HXxSize)); /* Flawfinder: ignore */

   if (!m_bCompositionSurfaceCreated ||
       (m_compositionSize.cx > m_allocatedCompositionSize.cx ||
        m_compositionSize.cy > m_allocatedCompositionSize.cy)
       )
   {
      if(HXR_OK == _DestroyCompositionSurface())
      {
         if(HXR_OK == _CreateCompositionSurface())
         {
            retVal = HXR_OK;
         }
      }
   }
   else
   {
      retVal = HXR_OK;
   }

   m_pCompMutex->Unlock();
   m_pMutex->Unlock();
   return retVal;
}


void CBaseRootSurface::LockCompMutex()
{
    if( m_pCompMutex)
        m_pCompMutex->Lock();
}

void CBaseRootSurface::UnlockCompMutex()
{
    if(m_pCompMutex)
        m_pCompMutex->Unlock();
}

void CBaseRootSurface::DestroySurfaces()
{
    m_pCompMutex->Lock();
   _DestroyCompositionSurface();
   m_pCompMutex->Unlock();
}

void CBaseRootSurface::ReInitSurfaces()
{
    m_pCompMutex->Lock();
    if(HXR_OK == _DestroyCompositionSurface())
    {
        _CreateCompositionSurface();
    }
    m_pCompMutex->Unlock();
}

void CBaseRootSurface::FillBorders()
{
   _FillBorders();
}

void CBaseRootSurface::SetBltLock(BOOL bSet)
{
   //XXXgfw what does this do???? It just returns on windows????
}

BOOL CBaseRootSurface::IsCompositionEnabled()
{
   return m_bCompositionSurfaceCreated;
}


STDMETHODIMP CBaseRootSurface::BeginOptimizedBlt(HXBitmapInfoHeader* pBitmapInfo)
{
#ifdef _DEBUG
   fprintf( stderr, "CBaseRootSurface::BeginOptimizedBlt needs to be written...\n" );
#endif
   return HXR_NOTIMPL;
}

BOOL CBaseRootSurface::_OptimizedSurfaceOpened()
   {
       return TRUE;
   }

STDMETHODIMP CBaseRootSurface::OptimizedBlt( UCHAR* pImageBits,
                                             REF(HXxRect) rDestRect,
                                             REF(HXxRect) rSrcRect)
{
#ifdef _DEBUG
   fprintf( stderr, "CBaseRootSurface::OptimizedBlt needs to be written...\n" );
#endif
   return HXR_NOTIMPL;
}

STDMETHODIMP CBaseRootSurface::EndOptimizedBlt(void)
{
#ifdef _DEBUG
   fprintf( stderr, "CBaseRootSurface::EndOptimizedBlt needs to be written...\n" );
#endif
   return HXR_NOTIMPL;
}

STDMETHODIMP CBaseRootSurface::GetOptimizedFormat(REF(HX_COMPRESSION_TYPE) ulType)
{
#ifdef _DEBUG
   fprintf( stderr, "CBaseRootSurface::GetOptimizedFormat needs to be written...\n" );
#endif
   return HXR_NOTIMPL;
}

STDMETHODIMP CBaseRootSurface::GetPreferredFormat(REF(HX_COMPRESSION_TYPE) ulType)
{
#ifdef _DEBUG
   fprintf( stderr, "CBaseRootSurface::GetPreferredFormat needs to be written...\n" );
#endif
   return HXR_NOTIMPL;
}

void CBaseRootSurface::SetResolution( int x, int y, int depth, void* pWindow)
{
   HX_ASSERT( "Must override"==NULL );
}

void CBaseRootSurface::GetDisplayModes( CModesDesc* pModesDesc, INT32* nNumModes )
{
   HX_ASSERT( "Must override"==NULL );
}

BOOL CBaseRootSurface::_RectOnNthMonitor(HXxRect rect, UINT32 uMonitor, HXxRect& intersectRect)
{
    // until multiple monitor support exists, simply return the original rect.
    // Override, if appropriate, in the platform-specific code.
    intersectRect = rect;
    return TRUE;
}

BOOL CBaseRootSurface::_IsHardwareAccelerationAvail()
{
    return FALSE;
}

BOOL CBaseRootSurface::_AcquireHardwareAcceleration()
{
    return FALSE;
}

BOOL CBaseRootSurface::_LoseHardwareAcceleration()
{
    return FALSE;
}

BOOL CBaseRootSurface::_EnableHardwareAcceleration()
{
    return FALSE;
}

BOOL CBaseRootSurface::_DisableHardwareAcceleration()
{
    return FALSE;
}

#ifdef _WINDOWS
IHXPlayer* CBaseRootSurface::GetPlayer()
{
   if (!m_pPlayer)
   {
       IHXClientEngineMapper* pCleng = NULL;

       m_pContext->QueryInterface(IID_IHXClientEngineMapper, (void**)&pCleng);
       if (pCleng)
       {
            IUnknown* pUnknown = NULL;
	    if (HXR_OK != pCleng->GetPlayerBySite(m_pSite, pUnknown))
            {
                // check our children
                CHXMapPtrToPtr::Iterator i = m_pSite->m_ChildrenMap.Begin();
                for ( ; i != m_pSite->m_ChildrenMap.End(); ++i)
                {
                    CHXBaseSite* pSite = (CHXBaseSite*) *i;
	            if (HXR_OK == pCleng->GetPlayerBySite(pSite, pUnknown))
                        break;
                }
            }
            if (pUnknown)
            {
	        pUnknown->QueryInterface(IID_IHXPlayer, (void**)&m_pPlayer);
	        HX_RELEASE(pUnknown);
            }
       }
   }

   return m_pPlayer;
}
#endif
