/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: HXClientEngine.mm,v 1.3.6.3 2004/07/09 01:49:35 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#import "HXClientEngine.h"
#import "HXEventRecordUtils.h"
#include "CHXClientEngine.h"
#include "CHXClientDebug.h"

#include "enter_hx_headers.h"
#include "hxwintyp.h"
#include "hxplugn.h"

#include "hxsmartptr.h"
HX_SMART_POINTER_INLINE( SPIHXPluginReloader, IHXPluginReloader );
#include "exit_hx_headers.h"

static HXClientEngine* gClientEngine = nil;
static const NSTimeInterval kEngineIdlerInterval = 0.03;
static id gEngineObserver = nil;

@interface NSObject ( HXPlayerToObserver )

- (BOOL)hasFeature:(NSString*)featureName;

@end

static bool DoesEngineHaveFeature( const char* featureName )
{
	if ( [gEngineObserver respondsToSelector:@selector( hasFeature: )] )
	{
		BOOL hasFeature = [gEngineObserver hasFeature:[NSString stringWithCString:featureName]];
		return ( hasFeature ? true : false );
	}
	return false;
}

HXClientEngineCallbacks gEngineToObserverCallbacks =
{
	NULL,
	NULL,
	NULL,
	DoesEngineHaveFeature
};

@implementation HXClientEngine

- (id)init
{
	self = [super init];
	if ( self )
	{
	}
	return self;
}

- (void)dealloc
{
	if ( gClientEngine == self )
	{
		gClientEngine = nil;
	}
	if ( idleEngineTimer )
	{
		[idleEngineTimer invalidate];
		[idleEngineTimer release];
		idleEngineTimer = nil;
	}
	if ( m_pIClientEngine )
	{
		m_pIClientEngine->Release();
		m_pIClientEngine = NULL;
	}
	[super dealloc];
}

+ (HXClientEngine*)sharedClientEngine
{
	if ( !gClientEngine )
	{
		gClientEngine = [[[HXClientEngine alloc] init] autorelease];
	}
	return gClientEngine;
}

+ (HXClientEngine*)sharedClientEngineNoCreate
{
	return gClientEngine;
}

+ (void)setObserver:(id)observer
{
	gEngineObserver = observer;
	CHXClientEngine::SetClientEngineCallbacks( ( nil != gEngineObserver ) ? &gEngineToObserverCallbacks : NULL );
}

- (void)createEngine
{
	if ( !m_pIClientEngine )
	{
		if ( CHXClientEngine::CreateEngine( &m_pIClientEngine ) )
		{
			if ( !idleEngineTimer )
			{
				CHXASSERT( NSApp ); // @"This doesn't appear to be a Cocoa application, so the idle timer won't get time."
				
				idleEngineTimer = [[NSTimer scheduledTimerWithTimeInterval:kEngineIdlerInterval target:[self class] selector:@selector(idleTimerFired:) userInfo:nil repeats:YES] retain];
				[[NSRunLoop currentRunLoop] addTimer:idleEngineTimer forMode:NSEventTrackingRunLoopMode];
			}
		}
	}
}

- (IHXClientEngine*)coreEngine
{
	[self createEngine];
	return m_pIClientEngine;
}

+ (void)idleTimerFired:(NSTimer *)timer
{	
	EventRecord nullClassicEvent;
	[HXEventRecordUtils createNullEvent:&nullClassicEvent];
	[[HXClientEngine sharedClientEngineNoCreate] handleClassicEvent:&nullClassicEvent];
}

- (BOOL)handleClassicEvent:(EventRecord *)classicEvent;
{
	BOOL eventHandled = NO;
	if ( m_pIClientEngine )
	{
		HXxEvent hxEvent;
		memset( &hxEvent, 0, sizeof( HXxEvent ) );
		hxEvent.event = classicEvent->what;
		hxEvent.param1 = ( void* ) classicEvent;
		
		m_pIClientEngine->EventOccurred( &hxEvent );
		
		eventHandled = hxEvent.handled ? YES : NO; // XXXSEH: Is this reliable?
	}
	return eventHandled;
}

- (void)reloadPlugins
{
	[self createEngine];
	if ( m_pIClientEngine )
	{
		SPIHXPluginReloader spPluginReloader = m_pIClientEngine;
		if ( spPluginReloader.IsValid() )
		{
			spPluginReloader->ReloadPlugins();
		}
	}
}

@end
