#!/usr/bin/env python

# ***** BEGIN LICENSE BLOCK *****
# Source last modified: $Id: preparchive.py,v 1.4.2.2 2004/07/09 02:02:53 hubbe Exp $
# 
# Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
# 
# The contents of this file, and the files included with this file,
# are subject to the current version of the RealNetworks Public
# Source License (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the current version of the RealNetworks Community
# Source License (the "RCSL") available at
# http://www.helixcommunity.org/content/rcsl, in which case the RCSL
# will apply. You may also obtain the license terms directly from
# RealNetworks.  You may not use this file except in compliance with
# the RPSL or, if you have a valid RCSL with RealNetworks applicable
# to this file, the RCSL.  Please see the applicable RPSL or RCSL for
# the rights, obligations and limitations governing use of the
# contents of the file.
# 
# Alternatively, the contents of this file may be used under the
# terms of the GNU General Public License Version 2 or later (the
# "GPL") in which case the provisions of the GPL are applicable
# instead of those above. If you wish to allow use of your version of
# this file only under the terms of the GPL, and not to allow others
# to use your version of this file under the terms of either the RPSL
# or RCSL, indicate your decision by deleting the provisions above
# and replace them with the notice and other provisions required by
# the GPL. If you do not delete the provisions above, a recipient may
# use your version of this file under the terms of any one of the
# RPSL, the RCSL or the GPL.
# 
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the
# portions it created.
# 
# This file, and the files included with this file, is distributed
# and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
# KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
# ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
# OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
# ENJOYMENT OR NON-INFRINGEMENT.
# 
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
# 
# Contributor(s):
# 
# ***** END LICENSE BLOCK *****
######################################################################


import sys, getopt
import os.path

def formatoutput(archive, type, extractor = None):
    print "#ifndef __archive_info_h"
    print "#define __archive_info_h"
    print "\n/* auto-generated by preparchive.py-- DO NOT EDIT! */\n"
    print "#define ARCHIVE_TYPE\t\"%s\"" % type
    print "#define ARCHIVE_SIZE\t%d" % os.path.getsize(archive)
    if extractor:
        print "#define ARCHIVE_PROG_SIZE\t%d" % os.path.getsize(extractor)
    print "\n#endif /* #ifndef __archive_info_h */"
    
    
def usage():
    print "USAGE: preparchive.py [-e <extractor>] -a <archive> -t <type>"
    print "       preparchive.py -h"
    print "-e, --extractor\tpath to the extractor program (optional)"
    print "-a, --archive\tpath to the archive file"
    print "-t, --type\tthe type of the archive (eg: bz2)"
    print "-h, --help\tdisplay usage"


if __name__ == "__main__":
    try:
        opts, args = getopt.getopt(sys.argv[1:], 
				   "a:e:t:h", 
				   ["archive", "extractor", "type", "help"])
    except getopt.GetoptError:
        usage()
        sys.exit(2)
        
    archive = None
    extractor = None
    type = None
    for o, a in opts:
        if o in ("-h", "--help"):
            usage(0)
            sys.exit()
        elif o in ("-a", "--archive"):
            archive = a
        elif o in ("-e", "--extractor"):
            extractor = a
        elif o in ("-t", "--type"):
            type = a

    if not archive or not type:
        usage()
        sys.exit(1)

    if extractor and not os.path.isfile(extractor):
        print "invalid extractor path \"%s\"" % extractor
        usage()
        sys.exit(3)

    if not os.path.isfile(archive):
        print "invalid archive path \"%s\"" % archive
        usage()
        sys.exit(3)

    formatoutput(archive, type, extractor)
