/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: mfsiface.h,v 1.1.1.1.40.1 2004/07/09 02:03:30 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __MFSIFACE_H
#define __MFSIFACE_H


struct IHXFileResponse;

/*
 * global defines
 */
#define MEMFS_RECURSION_DEPTH	"MemFSDepth"


/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXMemoryFileContext
 * 
 *  Purpose:
 * 
 *	Object that memory file may call into to request actions.
 * 
 *    IID_IHXMemoryFileContext:	
 *
 *	{00001000-b4c8-11d0-9995-00a0248da5f0}
 * 
 */

DEFINE_GUID(IID_IHXMemoryFileContext,	0x00001000, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0);

#undef  INTERFACE
#define INTERFACE   IHXMemoryFileContext

DECLARE_INTERFACE_(IHXMemoryFileContext, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /*
     *	IHXMemoryFileContext methods
     */

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileContext::RequestOpen
     *	Purpose:
     *	    Open the requested URL and begin streaming it.
     */
    STDMETHOD(RequestOpen)	(THIS_
				const char* pURL) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileContext::RequestRead
     *	Purpose:
     *	    Request the context read some data- used for pulling.
     */
    STDMETHOD(RequestRead)	(THIS_
				void*	pID,
				ULONG32 ulBytes) PURE;


};


/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXMemoryFileSystem
 * 
 *  Purpose:
 * 
 *	Allows adding and removing files from a memory file system.
 * 
 *    IID_IHXMemoryFileSystem:	
 *
 *	{00001001-b4c8-11d0-9995-00a0248da5f0}
 * 
 */

DEFINE_GUID(IID_IHXMemoryFileSystem,	0x00001001, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0);

#undef  INTERFACE
#define INTERFACE   IHXMemoryFileSystem

DECLARE_INTERFACE_(IHXMemoryFileSystem, IUnknown)
{
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /*
     *	IHXMemoryFileSystem methods
     */

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Add
     *	Purpose:
     *	    Add the specified URL to the file system and create a new
     *	    chunky res for it.
     */
    STDMETHOD(Add)		(THIS_
				const char*		pURL,
				IHXMemoryFileContext*	pContext,
				void*			pID,
				const char*		pMime) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Remove
     *	Purpose:
     *	    Remove the specified URL from the file system and discard its
     *	    chunky res.
     */
    STDMETHOD(Remove)		(THIS_
				void* pID) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Exists
     *	Purpose:
     *	    Returns TRUE if the given URL exists in the file system and
     *	    FALSE if it doesn't.
     */
    STDMETHOD_(BOOL, Exists)	(THIS_
				const char* pURL) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Append
     *	Purpose:
     *	    Appends data to the end of the specified memory file object.
     */
    STDMETHOD(Append)		(THIS_
				void*		pID,
				unsigned char*	pData,
				ULONG32		ulLen) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Finish
     *	Purpose:
     *	    Marks a memory file as having been completely downloaded.
     */
    STDMETHOD(Finish)		(THIS_
				void*		pID) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Shutdown
     *	Purpose:
     *	    Informs the memory file system that it is time to 
     *	    release all of its members, if they have not 
     *	    been released yet.
     */
    STDMETHOD(Shutdown)		(THIS) PURE;

};


/****************************************************************************
 * 
 *  Interface:
 * 
 *	IHXMemoryFileSystem2
 * 
 *  Purpose:
 * 
 *	Allows adding and removing files from a memory file system.
 * 
 *    IID_IHXMemoryFileSystem2:	
 *
 *	{00001002-b4c8-11d0-9995-00a0248da5f0}
 * 
 */

DEFINE_GUID(IID_IHXMemoryFileSystem2,	0x00001002, 0xb4c8, 0x11d0, 0x99, 0x95, 0x0, 0xa0, 0x24, 0x8d, 0xa5, 0xf0);

#undef  INTERFACE
#define INTERFACE   IHXMemoryFileSystem2

DECLARE_INTERFACE_(IHXMemoryFileSystem2, IUnknown)
{

    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)	(THIS) PURE;

    STDMETHOD_(ULONG32,Release)	(THIS) PURE;

    /*
     *	IHXMemoryFileSystem2 methods
     */

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::SetDefaultContext
     *	Purpose:
     *	    Provides a default memory file system context for requesting
     *	    new file objects.
     */
    STDMETHOD(SetDefaultContext)    (THIS_ 
				    IHXMemoryFileContext* pContext) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::RequestURL
     *	Purpose:
     *	    Request that the memory file system ask the default context to
     *	    open the specified URL.
     */
    STDMETHOD(RequestURL)    (THIS_ 
				const char* pURL,
				IHXFileResponse* pFileResponse) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::CancelRequest
     *	Purpose:
     *	    Cancels a pending URL request
     */
    STDMETHOD(CancelRequest)    (THIS_ 
				const char* pURL,
				HX_RESULT result) PURE;

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::AddWithSize
     *	Purpose:
     *	    Add the specified URL to the file system and create a new
     *	    chunky res for it.  Specify the size in advance.
     */
    STDMETHOD(AddWithSize)	(THIS_
				const char*		pURL,
				IHXMemoryFileContext*	pContext,
				void*			pID,
				const char*		pMime,
				UINT32			uSize) PURE;

};


#endif
