/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: memfsys.h,v 1.1.1.1.40.1 2004/07/09 02:03:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _MEMFSYS_H_
#define _MEMFSYS_H_
#include <stdio.h>

#ifndef NOTIMPL
#define NOTIMPL	    { return HXR_NOTIMPL; }
#endif


/****************************************************************************
 * 
 *  Function:
 * 
 *	HXCreateInstance()
 * 
 *  Purpose:
 * 
 *	Function implemented by all plugin DLL's to create an instance of 
 *	any of the objects supported by the DLL. This method is similar to 
 *	Window's CoCreateInstance() in its purpose, except that it only 
 *	creates objects from this plugin DLL.
 *
 *	NOTE: Aggregation is never used. Therefore an outer unknown is
 *	not passed to this function, and you do not need to code for this
 *	situation.
 * 
 */
STDAPI HXCreateInstance(IUnknown**  /*OUT*/	ppIUnknown);


/****************************************************************************
 * 
 *  Function:
 * 
 *	HXShutdown()
 * 
 *  Purpose:
 * 
 *	Function implemented by all plugin DLL's to free any *global* 
 *	resources. This method is called just before the DLL is unloaded.
 *
 */
STDAPI HXShutdown(void);



class CMemoryFileStatus
{
public:
    CMemoryFileStatus(IHXMemoryFileContext* pContext, void* pID, const char* pMime);
    ~CMemoryFileStatus();

    IHXMemoryFileContext*  GetContext();
    void*		    GetID() const		    { return m_pID; }
    ULONG32		    GetSize() const		    { return m_ulSize; }
    BOOL		    GetDone() const		    { return m_bDone; }
    ULONG32		    GetContentSize() const	    { return m_ulContentSize ? m_ulContentSize : m_ulSize; }
    void		    SetSize(ULONG32 ulSize)	    { m_ulSize = ulSize; }
    void		    SetContentSize(ULONG32 ulSize)  { m_ulContentSize = ulSize; }
    void		    SetDone(BOOL bDone);
    char*		    GetMime() const		    { return m_pMime; }
    void		    SetMime(const char* pMime);

    // Not really a COM object- just need to keep track of how many objs are using it
    LONG32		    AddRef();
    LONG32		    Release();
    LONG32		    GetRefCount() const		    { return m_lRefCount; }

protected:
    ULONG32		    m_ulSize;
    ULONG32		    m_ulContentSize;
    BOOL		    m_bDone;
    IHXMemoryFileContext*  m_pContext;
    void*		    m_pID;
    char*		    m_pMime;
    LONG32		    m_lRefCount;
};





/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//  	CMemoryFileSystem
//
//  Purpose:
//
//  	Example implementation of a basic file system.
//

class CMemoryFileSystem :   public IHXPlugin, 
			    public IHXFileSystemObject,
			    public IHXMemoryFileSystem,
			    public IHXMemoryFileSystem2,
			    public IHXValues
{
private:
    LONG32			m_lRefCount;
    static const IID            zm_myIID;
    static const char*          zm_pDescription;
    static const char*          zm_pCopyright;
    static const char*          zm_pMoreInfoURL;
    static const char*		zm_pShortName;
    static const char*		zm_pProtocol;
    CHXString			m_base_path;
    IUnknown*			m_pContext;
    IHXValues*                 m_options;
    CHXMapPtrToPtr		m_mapFileToContext;

public:
    CMemoryFileSystem();

    ~CMemoryFileSystem();


    // *** IUnknown methods ***
    STDMETHOD(QueryInterface)	(THIS_
    	    	    	    	REFIID riid,
    	    	    	    	void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    // *** IHXPlugin methods ***

    /************************************************************************
     *	Method:
     *	    IHXPlugin::GetPluginInfo
     *	Purpose:
     *	    Returns the basic information about this plugin. Including:
     *
     *	    bLoadMultiple	whether or not this plugin DLL can be loaded
     *				multiple times. All File Formats must set
     *				this value to TRUE.
     *	    pDescription	which is used in about UIs (can be NULL)
     *	    pCopyright		which is used in about UIs (can be NULL)
     *	    pMoreInfoURL	which is used in about UIs (can be NULL)
     */
    STDMETHOD(GetPluginInfo)	(THIS_
				REF(BOOL)        /*OUT*/ bLoadMultiple,
				REF(const char*) /*OUT*/ pDescription,
				REF(const char*) /*OUT*/ pCopyright,
				REF(const char*) /*OUT*/ pMoreInfoURL,
				REF(ULONG32)	 /*OUT*/ ulVersionNumber
				);

    /************************************************************************
     *	Method:
     *	    IHXPlugin::InitPlugin
     *	Purpose:
     *	    Initializes the plugin for use. This interface must always be
     *	    called before any other method is called. This is primarily needed 
     *	    so that the plugin can have access to the context for creation of
     *	    IHXBuffers and IMalloc.
     */
    STDMETHOD(InitPlugin)   (THIS_
			    IUnknown*   /*IN*/  pContext);

    // *** IHXFileSystemObject methods ***
    STDMETHOD(GetFileSystemInfo)    (THIS_
				    REF(const char*) /*OUT*/ pShortName,
				    REF(const char*) /*OUT*/ pProtocol);

    STDMETHOD(InitFileSystem) (THIS_ IHXValues* options);

    STDMETHOD(CreateFile)	(THIS_
				IUnknown**    /*OUT*/	ppFileObject);

    STDMETHOD(CreateDir)        (THIS_
                                IUnknown**     /*OUT*/  ppDirObject);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Add
     *	Purpose:
     *	    Add the specified URL to the file system and create a new
     *	    chunky res for it.
     */
    STDMETHOD(Add)		(THIS_
				const char*		pURL,
				IHXMemoryFileContext*	pContext,
				void*			pID,
				const char*		pMime);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Remove
     *	Purpose:
     *	    Remove the specified URL from the file system and discard its
     *	    chunky res.
     */
    STDMETHOD(Remove)		(THIS_
				void* pID);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Exists
     *	Purpose:
     *	    Returns TRUE if the given URL exists in the file system and
     *	    FALSE if it doesn't.
     */
    STDMETHOD_(BOOL, Exists)	(THIS_
				const char* pURL);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Append
     *	Purpose:
     *	    Appends data to the end of the specified memory file object.
     */
    STDMETHOD(Append)		(THIS_
				void*		pID,
				unsigned char*	pData,
				ULONG32		ulLen);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Finish
     *	Purpose:
     *	    Marks a memory file as having been completely downloaded.
     */
    STDMETHOD(Finish)		(THIS_
				void*	pID);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem::Shutdown
     *	Purpose:
     *	    Informs the memory file system that it is time to 
     *	    release all of its members, if they have not 
     *	    been released yet.
     */
    STDMETHOD(Shutdown)		(THIS);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::SetDefaultContext
     *	Purpose:
     *	    Provides a default memory file system context for requesting
     *	    new file objects.
     */
    STDMETHOD(SetDefaultContext)    (THIS_ 
				    IHXMemoryFileContext* pContext);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::RequestURL
     *	Purpose:
     *	    Request that the memory file system ask the default context to
     *	    open the specified URL.
     */
    STDMETHOD(RequestURL)    (THIS_ 
				const char* pURL,
				IHXFileResponse* pFileResponse);

    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::CancelRequest
     *	Purpose:
     *	    Cancels a pending URL request
     */
    STDMETHOD(CancelRequest)    (THIS_ 
				const char* pURL,
				HX_RESULT result);


    /************************************************************************
     *	Method:
     *	    IHXMemoryFileSystem2::AddWithSize
     *	Purpose:
     *	    Add the specified URL to the file system and create a new
     *	    chunky res for it.  Specify the size in advance.
     */
    STDMETHOD(AddWithSize)	(THIS_
				const char*		pURL,
				IHXMemoryFileContext*	pContext,
				void*			pID,
				const char*		pMime,
				UINT32			uSize);

    /*
     *	IHXValues methods
     */
    STDMETHOD(SetPropertyULONG32)	(THIS_
					const char*      pPropertyName,
					ULONG32          uPropertyValue);

    STDMETHOD(GetPropertyULONG32)	(THIS_
					const char*      pPropertyName,
					REF(ULONG32)     uPropertyName);

    STDMETHOD(GetFirstPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)     uPropertyValue) NOTIMPL

    STDMETHOD(GetNextPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)     uPropertyValue) NOTIMPL

    STDMETHOD(SetPropertyBuffer)	(THIS_
					const char*      pPropertyName,
					IHXBuffer*      pPropertyValue) NOTIMPL

    STDMETHOD(GetPropertyBuffer)	(THIS_
					const char*      pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL
    
    STDMETHOD(GetFirstPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL

    STDMETHOD(GetNextPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL

    STDMETHOD(SetPropertyCString)	(THIS_
					const char*      pPropertyName,
					IHXBuffer*      pPropertyValue) NOTIMPL

    STDMETHOD(GetPropertyCString)	(THIS_
					const char*      pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL

    STDMETHOD(GetFirstPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL

    STDMETHOD(GetNextPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue) NOTIMPL

    static IHXMemoryFileContext* z_pMemCtx;

    static UINT32  z_uMaxRecursionLevel;

};

/////////////////////////////////////////////////////////////////////////////
// 
//  Class:
//
//  	CMemoryFileObject
//
//  Purpose:
//
//  	Example implementation of a basic file system file object.
//

class CMemoryFileObject :   public IHXFileObject, 
			    public IHXFileStat,
			    public IHXFileExists,
			    public IHXGetFileFromSamePool,
			    public IHXFileMimeMapper,
			    public IHXRequestHandler,
			    public IHXPendingStatus,
			    public IHXFileResponse
{
private:
    UINT32		    m_ulPos;
    BOOL		    m_bCanBeReOpened;
    LONG32		    m_lRefCount;
    ULONG32	    	    m_ulFlags;
    IHXScheduler*	    m_pScheduler;
    IUnknown*		    m_pContext;
    IHXCommonClassFactory* m_pCommonClassFactory;
    IHXFileResponse*	    m_pFileResponse;
    IHXFileSystemObject*   m_pFileSystem;
    IHXRequest*	    m_pRequest;
    CChunkyRes*		    m_pChunkyRes;
    BOOL		    m_bLocalClose;
    char*		    m_pFilename;
    CHXString		    m_base_path;
    UINT16		    m_uRecursionCount;
    BOOL		    m_bInReadDone;
    UINT32		    m_ulPendingReadCount;
    BOOL		    m_bReadCancelled;
    BOOL		    m_bSeekPending;
    BOOL		    m_bAsynchInit;
    BOOL		    m_bClosed;
    CMemoryFileStatus*	    m_pStatus;
    CHXString		    m_strHeaderContentType;

    void		    Process(void);
    void		    UpdateFileNameMember(void);
    IHXMemoryFileSystem*   GetMemoryFileSystem(void);
    IHXMemoryFileSystem2*  GetMemoryFileSystem2(void);

    class SMPLFileObjCallback : public IHXCallback
    {
    private:
	LONG32		    m_lRefCount;
			    ~SMPLFileObjCallback();

	PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME
    public:

	BOOL		    m_bIgnoreCallback;

			    SMPLFileObjCallback(CMemoryFileObject* pFileObject);

	CMemoryFileObject*  m_pSMPLFileObject;
	BOOL		    m_bCallbackPending;
	ULONG32		    m_ulPendingCallbackID;

	/*
	 *	IUnknown methods
	 */
	STDMETHOD(QueryInterface)	(THIS_
					REFIID riid,
					void** ppvObj);

	STDMETHOD_(ULONG32,AddRef)	(THIS);

	STDMETHOD_(ULONG32,Release)	(THIS);

	/*
	 *	IHXCallback methods
	 */
	STDMETHOD(Func)			(THIS);
    };

    friend class SMPLFileObjCallback;

    SMPLFileObjCallback*		m_pCallback;

public:
    CMemoryFileObject
    (
	CHXString& base_path, 
	IHXFileSystemObject*, 
	IUnknown*
    );
    ~CMemoryFileObject();

    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
    	    	    	    	REFIID riid,
    	    	    	    	void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)	(THIS);

    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     *	IHXFileObject methods
     */

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Init
     *	Purpose:
     *	    Associates a file object with the file response object it should
     *	    notify of operation completness. This method should also check
     *	    for validity of the object (for example by opening it if it is
     *	    a local file).
     */
    STDMETHOD(Init)		(THIS_
				ULONG32		    /*IN*/	ulFlags,
				IHXFileResponse*   /*IN*/	pFileResponse);

    /************************************************************************
     *  Method:
     *      IHXFileObject::GetFilename
     *  Purpose:
     *      Returns the filename (without any path information) associated
     *      with a file object.
     */
    STDMETHOD(GetFilename)      (THIS_
				REF(const char*)    /*OUT*/  pFilename);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Close
     *	Purpose:
     *	    Closes the file resource and releases all resources associated
     *	    with the object.
     */
    STDMETHOD(Close)	    	(THIS);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Read
     *	Purpose:
     *	    Reads a buffer of data of the specified length from the file
     *	    and asynchronously returns it to the caller via the 
     *	    IHXFileResponse interface passed in to Init.
     */
    STDMETHOD(Read)		(THIS_
    	    	    	    	ULONG32	    	    ulCount);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Write
     *	Purpose:
     *	    Writes a buffer of data to the file and asynchronously notifies
     *	    the caller via the IHXFileResponse interface passed in to Init,
     *	    of the completeness of the operation.
     */
    STDMETHOD(Write)	    	(THIS_
    	    	    	    	IHXBuffer*	    pBuffer);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Seek
     *	Purpose:
     *	    Seeks to an offset in the file and asynchronously notifies
     *	    the caller via the IHXFileResponse interface passed in to Init,
     *	    of the completeness of the operation.
     */
    STDMETHOD(Seek)		(THIS_
    	    	    	    	 ULONG32	    ulOffset,
				 BOOL               bRelative);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Stat
     *	Purpose:
     *	    Collects information about the file that is returned to the
     *      caller in an IHXStat object
     */
    STDMETHOD(Stat)		(THIS_
				IHXFileStatResponse* pFileStatResponse);

    /************************************************************************
     *	Method:
     *	    IHXFileObject::Advise
     *	Purpose:
     *      To pass information to the File Object
     */
    STDMETHOD(Advise)	(THIS_
			ULONG32 ulInfo);


    /************************************************************************
     *	Method:
     *	    IHXGetFileFromSamePool::GetFileObjectFromPool
     *	Purpose:
     *      To get another FileObject from the same pool. 
     */
    STDMETHOD(GetFileObjectFromPool)	(THIS_
					 IHXGetFileFromSamePoolResponse*);

    // IHXFileExists interface
    /************************************************************************
     *	Method:
     *	    IHXFileExists::DoesExist
     *	Purpose:
     */
    STDMETHOD(DoesExist) (THIS_
			const char*		/*IN*/  pPath, 
			IHXFileExistsResponse* /*IN*/  pFileResponse);


    //IHXRequestHandler methods
    /************************************************************************
     *	Method:
     *	    IHXRequestHandler::SetRequest
     *	Purpose:
     *	    Associates an IHXRequest with an object
     */
    STDMETHOD(SetRequest)   	(THIS_
			    	IHXRequest*        /*IN*/  pRequest);

    /************************************************************************
     *	Method:
     *	    IHXRequestHandler::GetRequest
     *	Purpose:
     *	    Gets the IHXRequest object associated with an object
     */
    STDMETHOD(GetRequest)   	(THIS_
			    	REF(IHXRequest*)  /*OUT*/  pRequest);


    /*
     *	IHXFileMimeMapper methods
     */

    /************************************************************************
     *	Method:
     *	    IHXFileMimeMapper::FindMimeType
     *	Purpose:
     */
    STDMETHOD(FindMimeType) (THIS_
			    const char*			/*IN*/  pURL, 
			    IHXFileMimeMapperResponse* /*IN*/  pMimeMapperResponse
			    );


    /*
     * IHXPendingStatus methods
     */

    /************************************************************************
     *	Method:
     *	    IHXPendingStatus::GetStatus
     *	Purpose:
     *	    Called by the user to get the current pending status from an object
     */
    STDMETHOD(GetStatus)	(THIS_
				REF(UINT16) uStatusCode, 
				REF(IHXBuffer*) pStatusDesc, 
				REF(UINT16) ulPercentDone);

    /*
     *	IHXFileResponse methods
     */

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::InitDone
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    initialization of the file is complete. If the file is not valid 
     *	    for the file system, the status HXR_FAILED should be 
     *	    returned.
     */
    STDMETHOD(InitDone)			(THIS_
					HX_RESULT	    status);

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::CloseDone
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    close of the file is complete.
     */
    STDMETHOD(CloseDone)		(THIS_
					HX_RESULT	    status);

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::ReadDone
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    last read from the file is complete and a buffer is available.
     */
    STDMETHOD(ReadDone)			(THIS_ 
					HX_RESULT	    status,
					IHXBuffer*	    pBuffer);

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::WriteDone
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    last write to the file is complete.
     */
    STDMETHOD(WriteDone)		(THIS_ 
					HX_RESULT	    status);

    /************************************************************************
     *	Method:
     *	    IHXFileResponse::SeekDone
     *	Purpose:
     *	    Notification interface provided by users of the IHXFileObject
     *	    interface. This method is called by the IHXFileObject when the
     *	    last seek in the file is complete.
     */
    STDMETHOD(SeekDone)			(THIS_ 
					HX_RESULT	    status);

    /************************************************************************
     *	Method:
     *	    Private interface::_OpenFile
     *	Purpose:
     *	    open chunky res
     */
    STDMETHOD(_OpenFile)    (THIS_
			    ULONG32 ulFlags);

    /************************************************************************
     *	Method:
     *	    Private interface::_CloseFile
     *	Purpose:
     *	    close chunky res
     */
    STDMETHOD(_CloseFile) (THIS_);

};

#endif // ndef _MEMFSYS_H_
