/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: binrymap.cpp,v 1.3.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// system
#include "hlxclib/memory.h"
#ifdef _MACINTOSH
#include <string.h>
#endif
// include
#include "hxtypes.h"
#include "hxresult.h"
// rmasmil
#include "binrymap.h"
// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

CRNBinaryMap::CRNBinaryMap()
{
    m_ulNumRows   = 0;
    m_ulNumCols   = 0;
    m_ulRowSize32 = 0;
    m_pMap        = NULL;
}

CRNBinaryMap::~CRNBinaryMap()
{
    HX_VECTOR_DELETE(m_pMap);
}

HX_RESULT CRNBinaryMap::Init(UINT32 ulNumRows, UINT32 ulNumCols)
{
    HX_RESULT retVal = HXR_FAIL;

    if (ulNumRows && ulNumCols)
    {
        // Compute the number of UINT32's we need
        m_ulRowSize32  = (ulNumCols + 31) >> 5;
        UINT32 ulNum32 = m_ulRowSize32 * ulNumRows;
        // Allocate the array of UINT32's
        HX_VECTOR_DELETE(m_pMap);
        m_pMap = new UINT32 [ulNum32];
        if (m_pMap)
        {
            // Zero out the entire array
            memset((void*) m_pMap, 0, ulNum32 << 2);
            // Save the number of rows and cols
            m_ulNumRows = ulNumRows;
            m_ulNumCols = ulNumCols;
            // Clear the return value
            retVal = HXR_OK;
        }
    }

    return retVal;
}

void CRNBinaryMap::Set(UINT32 ulRow, UINT32 ulCol)
{
    if (ulRow < m_ulNumRows && ulCol < m_ulNumCols)
    {
        // Find the index of the UINT32 we want
        UINT32 ulColIndex32   = ulCol >> 5;
        UINT32 ulArrayIndex   = ulRow * m_ulRowSize32 + ulColIndex32;
        // Compute the bit index within the UINT32
        UINT32 ulBitIndex     = ulCol & 0x0000001F;
        // Set the bit
        m_pMap[ulArrayIndex] |= 1 << ulBitIndex;
    }
}

BOOL CRNBinaryMap::IsSet(UINT32 ulRow, UINT32 ulCol)
{
    BOOL bRet = FALSE;

    if (ulRow < m_ulNumRows && ulCol < m_ulNumCols)
    {
        // Find the index of the UINT32 we want
        UINT32 ulColIndex32   = ulCol >> 5;
        UINT32 ulArrayIndex   = ulRow * m_ulRowSize32 + ulColIndex32;
        UINT32 ulBitIndex     = ulCol & 0x0000001F;
        // Check the bit
        if (m_pMap[ulArrayIndex] & (1 << ulBitIndex))
        {
            bRet = TRUE;
        }
    }

    return bRet;
}
