/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: sm1doc.h,v 1.2.12.1 2004/07/09 01:57:34 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _SM1DOC_H_
#define _SM1DOC_H_

#include "hxthread.h"
#include "baseobj.h"

class CSmil1Renderer;
class CSmil1Parser;
class CSmil1BasicRegion;
class CSmil1RootLayout;
class CHXHeader;
struct SMIL1PlayToAssoc;
struct SMIL1SourceInfo;
class CSmil1LayoutEvent;
class CSmil1ShowSiteEvent;
class CSmil1EventHook;
class CSmil1PassiveSiteWatcher;
class CResourceLoader;
class ProcessElementCallback;

#ifdef _WINDOWS
class CHXDIBits;
#endif

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
#include <X11/Xlib.h>
#include <X11/Xutil.h>

typedef ULONG32 COLORTYPE;


class XData
{
  public:
      XData()
      {
	  m_Pixmap = 0;
	  m_Display = 0;
      }

      ~XData()
      {
	  if (m_Pixmap != 0)
	  {
              XFreePixmap(m_Display, m_Pixmap);
	  }
      }

  public:
      HXBitmapInfoHeader m_backgroundBitmapInfoHeader;
      Pixmap m_Pixmap;
      Display* m_Display;
      Colormap m_colormap;
};
#endif    // _UNIX


class CSmil1DocumentRenderer:  public IHXSiteUser,
			       public IHXRendererAdviseSink,
			       public IHXGroupSink,
			       public IHXValues,
			       public CSmil1ElementHandler,
			       public IHXPassiveSiteWatcher,
                               public CHXBaseCountingObject
{
public:
    CSmil1DocumentRenderer	    (CSmil1Renderer* pParent,
				    IUnknown* pContext);
    virtual ~CSmil1DocumentRenderer  ();

    HX_RESULT close		    (CSmil1Renderer* pParent);
    HX_RESULT setDocument	    (const char* pFragment);
    HX_RESULT onPacket		    (IHXBuffer* pBuffer,
				    BOOL bIsFinal);

    HX_RESULT handleLButtonUp	    (const char* pID,
				    UINT16 uXPos,
				    UINT16 uYPos);

    HX_RESULT handleMouseMove	    (void* pWindow,
				    const char* pID,
				    UINT16 uXPos,
				    UINT16 uYPos);
    BOOL handleSetCursor	    ();

    HX_RESULT detachSite	    (IHXSite* pSite);

    double			    getResizeXScale()
				    {
					return m_dResizeXScale;
				    }
    double			    getResizeYScale()
				    {
					return m_dResizeYScale;
				    }

    HX_RESULT addShowEvents	    (const char* pRegionName,
				    IHXSite* pSite);

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	    (THIS_
				    REFIID riid,
				    void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)	    (THIS);
    STDMETHOD_(ULONG32, Release)    (THIS);

    /*
     * IHXSiteUser methods
     */
    STDMETHOD(AttachSite)	    (THIS_
				    IHXSite* pSite);
    STDMETHOD(DetachSite)	    (THIS);
    STDMETHOD(HandleEvent)	    (THIS_
				    HXxEvent* pEvent);
    STDMETHOD_(BOOL,NeedsWindowedSites)	(THIS);

    /*
     * IHXRendererAdviseSink methods
     */
    STDMETHOD(TrackDurationSet)		(THIS_
					UINT32 ulGroupIndex,
					UINT32 ulTrackIndex,
					UINT32 ulDuration,
					UINT32 ulDelay,
					BOOL   bIsLive);

    STDMETHOD(RepeatedTrackDurationSet)	(THIS_
					const char*  pID,
					UINT32 ulDuration,					
				        BOOL   bIsLive);

    STDMETHOD(RendererInitialized)	(THIS_
					IHXRenderer* pRend,
					IUnknown* pStream,
					IHXValues* pInfo);

    STDMETHOD(RendererClosed)		(THIS_
					IHXRenderer* pRend,
					IHXValues* pInfo);

    // /POST-RP8REV release IHXRendererAdviseSink method:
    STDMETHOD(TrackUpdated)             (THIS_ UINT32 ulGroupIndex, UINT32 ulTrackIndex,
                                               IHXValues* pValues);


    /*
     * IHXGroupSink methods
     */
    STDMETHOD(GroupAdded)		(THIS_
					UINT16		uGroupIndex,
					IHXGroup*	pGroup);

    STDMETHOD(GroupRemoved)		(THIS_
					UINT16		uGroupIndex,
					IHXGroup*	pGroup);

    STDMETHOD(AllGroupsRemoved)		(THIS);

    STDMETHOD(TrackAdded)		(THIS_
					UINT16		uGroupIndex,
					UINT16		uTrackIndex,
					IHXValues*	pTrack);

    STDMETHOD(TrackRemoved)		(THIS_
					UINT16		uGroupIndex,
					UINT16		uTrackIndex,
					IHXValues*	pTrack);

    STDMETHOD(TrackStarted)		(THIS_
					UINT16		uGroupIndex,
					UINT16		uTrackIndex,
					IHXValues*	pTrack);

    STDMETHOD(TrackStopped)		(THIS_
					UINT16		uGroupIndex,
					UINT16		uTrackIndex,
					IHXValues*	pTrack);

    STDMETHOD(CurrentGroupSet)		(THIS_
					UINT16		uGroupIndex,
					IHXGroup*	pGroup);

    /*
     * IHXValues methods
     */
    STDMETHOD(SetPropertyULONG32)	(THIS_
					const char*	 pPropertyName,
					ULONG32		 uPropertyValue);

    STDMETHOD(GetPropertyULONG32)	(THIS_
					const char*	 pPropertyName,
					REF(ULONG32)	 uPropertyValue);

    STDMETHOD(GetFirstPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)	 uPropertyValue);

    STDMETHOD(GetNextPropertyULONG32)	(THIS_
					REF(const char*) pPropertyName,
					REF(ULONG32)	 uPropertyValue);

    STDMETHOD(SetPropertyBuffer)	(THIS_
					const char*	 pPropertyName,
					IHXBuffer*	 pPropertyValue);

    STDMETHOD(GetPropertyBuffer)	(THIS_
					const char*	 pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    STDMETHOD(GetFirstPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    STDMETHOD(GetNextPropertyBuffer)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    STDMETHOD(SetPropertyCString)	(THIS_
					const char*	 pPropertyName,
					IHXBuffer*	 pPropertyValue);

    STDMETHOD(GetPropertyCString)	(THIS_
					const char*	 pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    STDMETHOD(GetFirstPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    STDMETHOD(GetNextPropertyCString)	(THIS_
					REF(const char*) pPropertyName,
					REF(IHXBuffer*) pPropertyValue);

    /*
     *	IHXPassiveSiteWatcher methods
     */
    STDMETHOD(PositionChanged) (THIS_
				HXxPoint* /*IN*/ pPoint);

    STDMETHOD(SizeChanged) 	(THIS_
				HXxSize* /*IN*/ pSize);

    /*
     * CSmil1ElementHandler methods
     */
    HX_RESULT handleAddGroup		(CSmil1AddGroup* pAddGroup);
    HX_RESULT handleRegion		(CSmil1Region* pRegion);
    HX_RESULT handleRootLayout		(CSmil1RootLayout* pRootLayout);
    HX_RESULT handleSource		(CSmil1Source* pSource);
    HX_RESULT handleMeta		(CSmil1Meta* pMeta);
    HX_RESULT handleEndLayout		(CSmil1EndLayout* pSource);
    HX_RESULT handleRendererPreFetch	(CSmil1RendererPreFetch* pRend);
    HX_RESULT handleSourceUpdate	(CSmil1SourceUpdate* pUpdate);

    /*
     * CSmil1Parser methods
     */
    HX_RESULT onHeader			(IHXValues* pHeader);
    HX_RESULT onTimeSync		(UINT32 ulTimeValue);
    HX_RESULT onPreSeek			(UINT32 ulOldTime,
					UINT32 ulNewTime);
    HX_RESULT endStream			();

    HX_RESULT seekTo			(const char* pElementID);

    CSmil1BasicRegion* getRegion		(const char* pID);
    void resizeRegion			(const char* pRegionName,
					HXxSize* pNewSize);
    void repositionRegion		(const char* pRegionName,
					HXxPoint* pNewPosition);
    void setTopLevelSiteSize		();

    HX_RESULT HandleSurfaceUpdate	(HXxEvent* pEvent,
					IHXSite* pSite,
					HXxColor ulBGColor);

    HX_RESULT getErrorInfo		(REF(UINT32) ulErrorLine,
					 REF(UINT32) ulErrorColumn,
					 REF(IHXBuffer*) pErrorText);

    HX_RESULT		 GetElementProperties(UINT16		uGroupID, 
					      UINT16		uTrackID, 
					      REF(IHXValues*)	pProperties);

    HX_RESULT		 GetElementStatus(UINT16	    uGroupID,
					  UINT16	    uTrackID,
					  UINT32	    ulCurrentTime,
					  REF(IHXValues*)  pStatus);

    HX_RESULT		 AttachElementLayout(UINT16	    uGroupID,
					     UINT16	    uTrackID,
					     IHXRenderer*  pRenderer,
					     IHXStream*    pStream,
					     IHXValues*    pProps);
    HX_RESULT		 DetachElementLayout(IUnknown*	    pLSG);

    BOOL				m_bSiteChangingSize;
    BOOL				m_bNeedToAdjustSites;
    UINT32				m_ulNoRootLayoutHeight;
    UINT32				m_ulNoRootLayoutWidth;

    BOOL                                isRootLayoutWidthSet() const  { return m_bRootLayoutWidthSet;  }
    BOOL                                isRootLayoutHeightSet() const { return m_bRootLayoutHeightSet; }

    friend class CSmil1Renderer;

private:
    HX_RESULT addSiteForRenderer	(SMIL1PlayToAssoc* pPlayToAssoc,
					SMIL1SourceInfo* pSMIL1SourceInfo,
					IHXRenderer* pRenderer,
					BOOL bNoRegion);
    void setPlayToAssoc			(UINT16 uGroupIndex, 
					UINT16 uTrackIndex, 
					const char* pID,
					const char* pRepeatID, // /For SHAZAM
					const char* pPlayTo,
					const char* pRegionName);
    SMIL1PlayToAssoc* getPlayToAssoc	(UINT16 uGroupIndex, 
					UINT16 uTrackIndex);
    SMIL1PlayToAssoc* getPlayToAssoc	(const char* pName); 
    void removeAllPlayToAssoc		();
    void removeGroupsPlayToAssoc	(UINT16	uGroupIndex);
    void removeSourcemap		(SMIL1PlayToAssoc* pPlayToAssoc);
    HX_RESULT insertEvent		(CSmil1ShowSiteEvent* pEvent);
    CSmil1ShowSiteEvent* getShowHideEvent(IHXSite* pRegionSite,
					  IHXSite* pRendererSite,
                                          BOOL	    bShowEvent);
    HX_RESULT insertSiteInfo		(void* pInfo);
    void removeGroupEvents		(UINT16 uGroupIndex);
    void showSite			(IHXSite* pSite, 
					BOOL bShow);
    void resizeSite			(HXxSize newSize);
    void resizeSite			(IHXSite* pSite,
					double dXScale,
					double dYScale);
    void resizeRegionSiteAbs(CSmil1BasicRegion* pRegion,
                             double            dXAbsScale,
                             double            dYAbsScale);
    BOOL draw				(HXxEvent* pEvent,
					IHXSite* pSite,
					HXxColor ulBgColor);
    void insertZOrder			(IHXSite* pSite, 
					INT32 lZOrder);
    void setZOrder			();
    HX_RESULT handleElements		();
    void setProperty			(IHXValues* pValues, 
					const char* pName, 
					const char* pValue);
    HX_RESULT parseDimension		(const char* pDimensionString,
					REF(UINT32) ulValue,
					REF(BOOL) bIsPercent);
    HX_RESULT regionToRect		(CSmil1Region* pElement,
					HXxRect* pRect,
					BOOL& bWidthUnspecified,
					BOOL& bHeightUnspecified);
    CSmil1AAnchorElement*
	findHyperlinkElement		(const char* pID,
					UINT16 uXPos,
					UINT16 uYPos);
    HX_RESULT convertURL		(const char* pURL,
					CHXString& newURL);
    HX_RESULT updateStreamTiming	(const char* pElementID,
					UINT32 ulDuration);
    HX_RESULT updateStreamDelay		(UINT16 uGroupIndex,
					UINT32 ulDelay);
    HX_RESULT updateSiteEvents		(UINT16 uGroupIndex);
    HX_RESULT createRegionSites		();

    void      RemoveEvents		(UINT32 ulGroupIndex, IHXSite* pSite);
    HX_RESULT flushAllEvents		(UINT32 ulFlushToTime, BOOL bBreak=FALSE );
    inline HX_RESULT flushAllEvents () { return flushAllEvents( m_ulCurrentTime ); }

    BOOL      IsFullScreen();
    void      computeMediaFitSize(HXxSize cRegSize, HXxSize cMedSize,
                                  const char* pszFitAttr, REF(HXxSize) rcFitSize);
    HX_RESULT getPreference(IUnknown*        pContext,
                            const char*      pszKey,
                            REF(IHXBuffer*) rpValue);
    HX_RESULT getBooleanPreference(IUnknown*   pContext, 
                                   const char* pszKey,
                                   REF(BOOL)   rbValue);

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    void ConvertPNxColorToXColor(HXxColor hxxColor, XColor& xcolor);
    XData* InitXVisualSupport(IHXSite* pSite, HXxWindow* pWnd);
#endif

    CSmil1Renderer*			m_pParent;
    CSmil1Parser*			m_pSmilParser;
    HX_RESULT				m_ulParseResult;
    IHXSite*				m_pMISUSSite;
    IHXScheduler*			m_pScheduler;
public:
    HXxSize				m_topSiteSize;
    HXxSize				m_topSiteOriginalSize;
private:
    IHXValues*				m_pValues;
    char*				m_pFragment;
    CHXMapStringToOb*			m_pRegionMap;
    CHXMapPtrToPtr*			m_pSiteInfoByRendererMap;
    CHXMapPtrToPtr*			m_pSiteWatcherMap;
    CHXMapLongToObj*			m_pGroupInfoMap;
    CHXMapLongToObj*			m_pGroupMap;
    CHXMapStringToOb*			m_pDeferredSourceMap;
    CHXMapStringToOb*			m_pRepeatIDMap;
    CHXSimpleList*			m_pSiteInfoList;
    CHXSimpleList*			m_pPlayToAssocList;
    CHXSimpleList*			m_pEventList;
    CHXSimpleList*			m_pZOrderList;
    LISTPOSITION			m_ulEventListPosition;
    INT16				m_uCurrentGroupIndex;
    INT16				m_nFragmentTracks;
    UINT32				m_ulCurrentTime;
    LONG32				m_lRefCount;
    IUnknown*				m_pContext;
    IHXSiteManager*			m_pSiteMgr;
    IHXStatusMessage*			m_pStatusMessage;
    BOOL				m_bFirstTimeSync;
    BOOL				m_bSettingFragment;
    BOOL				m_bInHyperlink;
    BOOL				m_bShowDependencies;
    BOOL				m_bSiteLayoutComplete;
    BOOL				m_bStatusMessageSet;
    double				m_dResizeXScale;
    double				m_dResizeYScale;
    UINT32                              m_ulPktnum;
    UINT16                              m_usOldXPos;
    UINT16                              m_usOldYPos;
    ProcessElementCallback*		m_pProcessElementCallback;

#ifdef _WINDOWS
    HCURSOR 				m_hHyperlinkCursor;
    HCURSOR				m_hPreHyperlinkCursor;
    BOOL				m_bNeedToSetHyperlinkCursor;
#endif
#if defined(_MACINTOSH) || defined(_MAC_UNIX)
    BOOL				m_bResetCursor;
    CursHandle				m_hHyperlinkCursor;
    CResourceLoader*			m_pResourceLoader;
#endif

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    // needed for background drawing
    XVisualInfo*                        m_pVisualInfo;
    Cursor                              m_hHyperlinkCursor;
    Cursor                              m_hCurrentCursor;
    Display*                            m_pDisplay;          
    Window                              m_Window;
    Display*                            m_pPixmapDisplay;
    CHXMapPtrToPtr                      m_siteToXDataMap;
#endif

    BOOL				m_bRootLayoutWidthSet;
    BOOL				m_bRootLayoutHeightSet;
    UINT32				m_ulRootLayoutHeight;
    UINT32				m_ulRootLayoutWidth;
    HXxColor				m_ulRootLayoutBGColor;

    UINT32		    m_ulGroupIndex;
    UINT32		    m_ulTrackIndex;
    UINT16		    m_uGroupIndexWithin;
    BOOL		    m_bSitesDetached;
    BOOL		    m_bInRAM20;
    BOOL		    m_bLastGroupInRAM20;
    INT32		    m_ulPersistentComponentDelay;
    UINT32		    m_ulPersistentComponentID;
    UINT16		    m_uPersistentGroupID;
    UINT16		    m_uPersistentTrackID;
    ElementWithinTag	    m_elementWithinTag;
    IHXValues*		    m_pPersistentProperties;
    IHXPersistentRenderer* m_pPersistentParentRenderer;
    BOOL                    m_bCloseCalled;

    HX_RESULT		    InitPersistent(UINT32		    ulPersistentComponentID,
					   UINT16		    uPersistentGroupID,
					   UINT16		    uPersistentTrackID,
					   IHXPersistentRenderer*  pPersistentParent);

    HX_RESULT		    setupRootLayout();
    BOOL		    IsNestedMetaSupported(UINT16& uSupportedType);
    void		    PersistentDurationSet(UINT32 ulDuration, UINT32 ulDelay, BOOL bIsLive);
};

class CSmil1SiteWatcher: public CHXBaseCountingObject,
                         public IHXSiteWatcher
{
public:
    CSmil1SiteWatcher		    (CSmil1DocumentRenderer* pDoc, 
				    const char* pID,
				    BOOL bIsChildSite);
    ~CSmil1SiteWatcher		    ();

    HX_RESULT close		    ();

    IHXSite*			    GetSite() { return m_pSite; }
    void			    SiteChangingSize(BOOL bFlag) { m_bChangingSize = bFlag; }

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	    (THIS_
				    REFIID riid,
				    void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)	    (THIS);
    STDMETHOD_(ULONG32, Release)    (THIS);

    /*
     * IHXSiteWatcher methods
     */
    STDMETHOD(AttachSite)	    (THIS_
				    IHXSite* pSite);

    STDMETHOD(DetachSite)	    (THIS);
				    
    STDMETHOD(ChangingPosition)	    (THIS_
				    HXxPoint posOld,
				    REF(HXxPoint) posNew);

    STDMETHOD(ChangingSize)	    (THIS_
				    HXxSize sizeOld,
				    REF(HXxSize) posNew);
private:
    CHXString		    	    m_id;
    CSmil1DocumentRenderer*  	    m_pDoc;
    IHXSite*		    	    m_pSite;
    BOOL			    m_bIsChildSite;
    BOOL			    m_bChangingSize;
    LONG32		    	    m_lRefCount;
    BOOL                            m_bFirstSetSize;
};

class CSmil1EventHook: public CHXBaseCountingObject,
                       public IHXEventHook
{
public:
    CSmil1EventHook		    (CSmil1DocumentRenderer* pDoc,
				    const char* pRegionName,
				    const char* pChannelName,
				    BOOL bNoRegion);
    virtual ~CSmil1EventHook	    ();

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	    (THIS_
				    REFIID riid,
				    void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)	    (THIS);
    STDMETHOD_(ULONG32, Release)    (THIS);

    /*
     * IHXEventHook methods
     */
    STDMETHOD(HandleEvent)	    (IHXSite* pSite,
				    HXxEvent* pEvent);
    STDMETHOD(SiteAdded)	    (IHXSite* pSite);
    STDMETHOD(SiteRemoved)	    (IHXSite* pSite);
    
    char*			    m_pChannelName;

private:
    CSmil1DocumentRenderer*	    m_pDoc;
    char*			    m_pRegionName;
    IHXSite*			    m_pSite;
    BOOL			    m_bNoRegion;
    CSmil1PassiveSiteWatcher*	    m_pSiteWatcher;
    LONG32			    m_lRefCount;
};

class CSmil1PassiveSiteWatcher: public CHXBaseCountingObject,
                                public IHXPassiveSiteWatcher
{
public:
    CSmil1PassiveSiteWatcher	    (CSmil1DocumentRenderer* pDoc,
				    const char* pRegionName);
    ~CSmil1PassiveSiteWatcher	    ();

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	    (THIS_
				    REFIID riid,
				    void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)	    (THIS);
    STDMETHOD_(ULONG32, Release)    (THIS);

    /*
     * IHXPassiveSiteWatcher methods
     */
    STDMETHOD(PositionChanged)	    (THIS_
				    HXxPoint* pPoint);
    STDMETHOD(SizeChanged)	    (THIS_
				    HXxSize* pSize);

private:
    LONG32			    m_lRefCount;
    CSmil1DocumentRenderer*	    m_pDoc;
    char*			    m_pRegionName;
};

class CSmil1SiteUser: public CHXBaseCountingObject,
                      public IHXSiteUser
{
public:
    CSmil1SiteUser		    (CSmil1DocumentRenderer* pDoc,
				    HXxColor ulBGColor);
    ~CSmil1SiteUser		    ();

    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)	    (THIS_
				    REFIID riid,
				    void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)	    (THIS);
    STDMETHOD_(ULONG32, Release)    (THIS);

    /*
     * IHXSiteUser methods
     */
    STDMETHOD(AttachSite)	    (THIS_
				    IHXSite* pSite);
    STDMETHOD(DetachSite)	    (THIS);
    STDMETHOD(HandleEvent)	    (THIS_
				    HXxEvent* pEvent);
    STDMETHOD_(BOOL,NeedsWindowedSites)	(THIS);

private:
    LONG32			    m_lRefCount;
    HXxColor			    m_ulBGColor;
    CSmil1DocumentRenderer*	    m_pDoc;
    IHXSite*			    m_pSite;
};

/*
 * CSmil1BasicRegion methods
 */

class CSmil1BasicRegion : public CHXBaseCountingObject
{
public:
    CSmil1BasicRegion		    (const char* pName, 
				    HXxRect rect, 
				    INT32 lZindex, 
				    const char* pFit, 
				    HXxColor ulBgColor,
				    BOOL bBgColorSet, 
				    BOOL bImplicitRegion,
				    BOOL bWidthUnspecified,
				    BOOL bHeightUnspecified);
    ~CSmil1BasicRegion();

    HXxRect m_rect;
    HXxRect m_originalRect;
    HXxSize m_mediaSize;
    HXxSize m_originalMediaSize;
    BOOL    m_bMediaSizeSet;
    IHXSite* m_pSite;
    IHXSiteUser* m_pSiteUser;
    INT32 m_lZIndex;
    CHXString m_region;
    CHXString m_fit;
    HXxColor m_ulBgColor;
    BOOL m_bBgColorSet;
    BOOL m_bImplicitRegion;
    BOOL m_bWidthUnspecified;
    BOOL m_bHeightUnspecified;
};

class ProcessElementCallback : public IHXCallback
{
public:
    CHXString			m_elementID;
    CSmil1DocumentRenderer*	m_pOwner;
    CallbackHandle		m_PendingHandle;
    BOOL			m_bIsCallbackPending;

			ProcessElementCallback();
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)	(THIS_
				REFIID riid,
				void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)	(THIS);
    STDMETHOD_(ULONG32,Release)	(THIS);

    /*
     *	IHXCallback methods
     */
    STDMETHOD(Func)		(THIS);

protected:
			~ProcessElementCallback();
    LONG32		m_lRefCount;
};

#endif /* _SM1DOC_H_ */
