/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: imghelpr.h,v 1.1.24.1 2004/07/09 01:51:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef IMGHELPR_H
#define IMGHELPR_H

class PXImageHelper : public CHXBaseCountingObject,
                      public CUnknownIMP
{
    DECLARE_UNKNOWN(PXImageHelper)
public:
    HX_RESULT Init(IHXErrorMessages* pErrorMessages, UINT32 ulHandle, UINT32 ulFileLength,
                   IUnknown* m_pCodec, UINT32 ulOpaqueSize, UINT32 ulDispWidth, UINT32 ulDispHeight,
                   UINT32 ulFormat, UINT32 ulBpp, BOOL bRowsInverted);
    HX_RESULT OnImageDataPacket(IHXBuffer* pOpaque, IHXBuffer* pData);

    UINT32    GetHandle()           const { return m_ulHandle;              }
    UINT32    GetFileLength()       const { return m_ulFileLength;          }
    UINT32    GetOpaqueSize()       const { return m_ulOpaqueSize;          }
    UINT32    GetPacketsProcessed() const { return m_ulNumPacketsProcessed; }
    UINT32    GetBytesProcessed()   const { return m_ulFileBytesProcessed;  }
    BOOL      DecodeFailed()        const { return m_bDecodeFailed;         }
    UINT32    GetWidth()            const { return (UINT32) m_cImageDim.cx; }
    UINT32    GetHeight()           const { return (UINT32) m_cImageDim.cy; }
    UINT32    GetNumFrames()        const { return m_ulNumFrames;           }
    HX_RESULT GetFrame(UINT32 i, PXImage** ppFrame);
    HX_RESULT GetFrameInfo(UINT32 i, IHXValues** ppFrameInfo);
    HX_RESULT GetFrameDim(UINT32 i, REF(HXxRect) rFrameDim);
    BOOL      AllBytesDecoded()     const;
    BOOL      GetIgnoreDataPackets() const     { return m_bIgnoreDataPackets;  }
    void      SetIgnoreDataPackets(BOOL bFlag) { m_bIgnoreDataPackets = bFlag; }
protected:
    PXImageHelper();
    virtual ~PXImageHelper();

    void      Reset();
    void      Deallocate();
    UINT32    GetPacketBufferSize(IHXPacket* pPacket);
    HX_RESULT CreateNestedBuffer(IHXBuffer* pBuffer, UINT32 ulOffset,
                                 UINT32 ulSize, IHXBuffer** ppBuffer);
    HX_RESULT InitHeader(IHXBuffer* pData, IHXBuffer* pOpaque);
    void      DeallocateImages();

    struct FrameData
    {
        PXImage*    m_pFrame;
        IHXValues* m_pFrameInfo;
        HXxRect     m_cFrameDim;
        BOOL        m_bNeedAlphaCheck;
    };

    IHXRealPixRendererCodec* m_pCodec;
    IHXErrorMessages*        m_pErrorMessages;
    UINT32                    m_ulNumFrames;
    HXxSize                   m_cImageDim;
    IHXValues*               m_pImageInfo;
    FrameData*                m_pFrameData;
    UINT32                    m_ulHandle;
    UINT32                    m_ulFileLength;
    UINT32                    m_ulDisplayWidth;
    UINT32                    m_ulDisplayHeight;
    UINT32                    m_ulFormat;
    UINT32                    m_ulBitsPerPixel;
    BOOL                      m_bRowsInverted;
    UINT32                    m_ulNumPacketsProcessed;
    UINT32                    m_ulFileBytesProcessed;
    UINT32                    m_ulSessionHandle;
    BOOL                      m_bDecodeFailed;
    UINT32                    m_ulOpaqueSize;
    BOOL                      m_bIgnoreDataPackets;
};

#endif
