/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpfilobj.h,v 1.2.24.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CIMF_FILE_OBJECT_H
#define _CIMF_FILE_OBJECT_H

#include "hxformt.h"
#include "hxplugn.h"
#include "hxfiles.h"

#include "gstring.h"
#include "glist.h"
#include "image.h"
#include "effect.h"

class CIMFEffect;
class PXRealPixFile;

class CIMFFileObject : public CHXBaseCountingObject
{
public:
    static char m_pszTagStart[];
    static char m_pszTagEnd[];
    static char m_pszFillTag[];
    static char m_pszFadeinTag[];
    static char m_pszFadeoutTag[];
    static char m_pszCrossfadeTag[];
    static char m_pszWipeTag[];
    static char m_pszViewchangeTag[];
    static char m_pszExternalEffectTag[];
    static char m_pszAnimateTag[];
protected:
    enum
    {
        kTimeFormatDHMS         = 0,
        kTimeFormatMilliseconds = 1
    };

    GString     m_cTitle;
    GString     m_cAuthor;
    GString     m_cCopyright;
    ULONG32     m_ulStartTime;
    ULONG32     m_ulDuration;
    ULONG32     m_ulPreroll;
    ULONG32     m_ulBitrate;
    ULONG32     m_ulDisplayWidth;
    ULONG32     m_ulDisplayHeight;
    ULONG32     m_ulTimeFormat;
    BOOL        m_bAspectFlag;
    GString     m_cURL;
    GList       m_cImageList;
    GList       m_cEffectList;
	ULONG32     m_ulMaxFps;
    UINT32      m_ulContentVersion;
    UINT32      m_ulBackgroundColor;
    UINT32      m_ulOpacity;

    static char m_pszIMFStartTag[];
    static char m_pszIMFEndTag[];
    static char m_pszHeadTag[];
    static char m_pszHeadTitleAttribute[];
    static char m_pszHeadAuthorAttribute[];
    static char m_pszHeadCopyrightAttribute[];
    static char m_pszHeadStartAttribute[];
    static char m_pszHeadDurationAttribute[];
    static char m_pszHeadPrerollAttribute[];
    static char m_pszHeadBitrateAttribute[];
    static char m_pszHeadWidthAttribute[];
    static char m_pszHeadHeightAttribute[];
    static char m_pszHeadAspectAttribute[];
    static char m_pszHeadURLAttribute[];
	static char m_pszHeadMaxFps[];
    static char m_pszHeadTimeFormatAttribute[];
    static char m_pszHeadVersionAttribute[];
    static char m_pszHeadBackgroundColorAttr[];
    static char m_pszHeadOpacityAttr[];
    static char m_pszImageTag[];
    static char m_pszImageHandleAttribute[];
    static char m_pszImageNameAttribute[];
    static char m_pszWhitespace[];

    void      InsertEffectIntoList(CIMFEffect *pEffect);
    void      InsertImageIntoList(CIMFImage *pImage);
    HX_RESULT InitImageUseFlags();

public:
    CIMFFileObject();
    ~CIMFFileObject();
    
    void    RenderText(GString &rText);
    BOOL    InitFromText(GString &rText, UINT32& rulErrorID, CHXString& rErrText);

    GString & GetTitle()		{ return m_cTitle; }
    GString & GetAuthor()		{ return m_cAuthor; }
    GString & GetCopyright()		{ return m_cCopyright; }
    ULONG32         GetStartTime()      const { return m_ulStartTime; }
    ULONG32         GetDuration()       const { return m_ulDuration; }
    ULONG32         GetPreroll()        const { return m_ulPreroll; }
    ULONG32         GetBitrate()        const { return m_ulBitrate; }
    ULONG32         GetDisplayWidth()   const { return m_ulDisplayWidth; }
    ULONG32         GetDisplayHeight()  const { return m_ulDisplayHeight; }
	BOOL            GetAspectFlag()     const { return m_bAspectFlag; }
    GString & GetURL()			{ return m_cURL; } 
	ULONG32         GetMaxFps()         const { return m_ulMaxFps; }
    ULONG32         GetTimeFormat()     const { return m_ulTimeFormat; }
    UINT32          GetContentVersion() const { return m_ulContentVersion; }

    ULONG32         GetNumImages()       { return m_cImageList.Size(); }
    CIMFImage      *GetImage(ULONG32 i)  { return (CIMFImage *) m_cImageList[i]; }
    ULONG32         GetNumEffects()      { return m_cEffectList.Size(); }
    CIMFEffect     *GetEffect(ULONG32 i) { return (CIMFEffect *) m_cEffectList[i]; }

    const char     *GetNameFromHandle(ULONG32 ulHandle);
    CIMFImage      *GetImageFromHandle(ULONG32 ulHandle);
	int				GetImageIndexFromHandle(ULONG32 ulHandle);

    void SetTitle(const char *pszTitle)         { m_cTitle = pszTitle; }
    void SetAuthor(const char *pszAuthor)       { m_cAuthor = pszAuthor; }
    void SetCopyright(const char *pszCopyright) { m_cCopyright = pszCopyright; }
    void SetStartTime(ULONG32 ulStartTime)      { m_ulStartTime = ulStartTime; }
    void SetDuration(ULONG32 ulDuration)        { m_ulDuration = ulDuration; }
    void SetPreroll(ULONG32 ulPreroll)          { m_ulPreroll= ulPreroll; }
    void SetBitrate(ULONG32 ulBitrate)          { m_ulBitrate = ulBitrate; }
    void SetDisplayWidth(ULONG32 ulWidth)       { m_ulDisplayWidth = ulWidth; }
    void SetDisplayHeight(ULONG32 ulHeight)     { m_ulDisplayHeight = ulHeight; }
    void SetAspectFlag(BOOL bAspectFlag)        { m_bAspectFlag = bAspectFlag; }
    void SetURL(const char *pszURL)             { m_cURL = pszURL; }

    static BOOL GetAttributeSubstring(GString &rStr, const char *pszAttribute, GString &rSubstr);
    static BOOL SetAttributeValue(GString &rStr,     const char *pszAttribute, GString &rStrTarget);
    static BOOL SetAttributeValue(GString &rStr,     const char *pszAttr,      INT32   &rlTarget);
    static BOOL SetAttributeValue(GString &rStr,     const char *pszAttribute, ULONG32 &rulTarget);
    static BOOL SetAttributeValueBOOL(GString &rStr,     const char *pszAttribute, BOOL    &rbTarget);
    static HX_RESULT SetAttributeTimeValue(GString &rStr, const char *pszAttribute,
                                           ULONG32 ulFormat, ULONG32 &rulTimeTarget);
    static BOOL ConvertTimeStringToULONG32(char *pTimeBuf, ULONG32 timeBufLen, ULONG32 &timeValInMillisec);


    static void RenderAttribute(const char *pszAttrStr, GString &rValue,  GString &rText);
    static void RenderAttribute(const char *pszAttrStr, ULONG32        ulValue, GString &rText);
    static void RenderAttribute(const char *pszAttrStr, BOOL           bValue,  GString &rText);

    ULONG32 GetMaxPacketLength(){return 700;};
	ULONG32 GetAvgPacketLength(){return 110;};

    HX_RESULT ConvertToNewFileObject(PXRealPixFile* pFile);
};

#endif

