/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rect.h,v 1.2.24.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CIMFRECT_H
#define _CIMFRECT_H

#include "gstring.h"

class CIMFRect : public CHXBaseCountingObject
{
protected:
    ULONG32 m_ulX;
    ULONG32 m_ulY;
    ULONG32 m_ulW;
    ULONG32 m_ulH;

    static char m_pszSrcX[];
    static char m_pszSrcY[];
    static char m_pszSrcW[];
    static char m_pszSrcH[];
    static char m_pszDstX[];
    static char m_pszDstY[];
    static char m_pszDstW[];
    static char m_pszDstH[];

    enum {kBinaryLength = 16};

    ULONG32 RenderBinaryType(unsigned char *pBuffer, ULONG32 ulValue)
    {
        pBuffer[0] = (unsigned char) ((ulValue >> 24) & 0x000000FF);
        pBuffer[1] = (unsigned char) ((ulValue >> 16) & 0x000000FF);
        pBuffer[2] = (unsigned char) ((ulValue >>  8) & 0x000000FF);
        pBuffer[3] = (unsigned char) ( ulValue        & 0x000000FF);

        return 4;
    };

    ULONG32 InitFromBinaryType(unsigned char *pBuffer, ULONG32 &rulValue)
    {
        rulValue = ((pBuffer[0] << 24) & 0xFF000000) |
                   ((pBuffer[1] << 16) & 0x00FF0000) |
                   ((pBuffer[2] <<  8) & 0x0000FF00) |
                   ( pBuffer[3]        & 0x000000FF);

        return 4;
    };
public:
    CIMFRect();

    CIMFRect(const CIMFRect &rRect);

    CIMFRect(ULONG32 ulX, ULONG32 ulY, ULONG32 ulW, ULONG32 ulH);

    ~CIMFRect();

    ULONG32 GetX()      const { return m_ulX; }
    ULONG32 GetY()      const { return m_ulY; }
    ULONG32 GetWidth()  const { return m_ulW; }
    ULONG32 GetHeight() const { return m_ulH; }

    void    SetX(ULONG32 ulX)      { m_ulX = ulX; }
    void    SetY(ULONG32 ulY)      { m_ulY = ulY; }
    void    SetWidth(ULONG32 ulW)  { m_ulW = ulW; }
    void    SetHeight(ULONG32 ulH) { m_ulH = ulH; }

    void    Set(ULONG32 ulX, ULONG32 ulY, ULONG32 ulW, ULONG32 ulH)
    {
        m_ulX = ulX;
        m_ulY = ulY;
        m_ulW = ulW;
        m_ulH = ulH;
    }

    const CIMFRect & operator = (const CIMFRect &rRect)
    {
        Set(rRect.m_ulX, rRect.m_ulY, rRect.m_ulW, rRect.m_ulH);

        return *this;
	};

    BOOL IsNull() const
    {
        return (m_ulX | m_ulY | m_ulW | m_ulH ? FALSE : TRUE);
    }

    BOOL IsFullScreen(UINT32 ulW, UINT32 ulH) const
    {
        return ((m_ulX == 0 &&
                 m_ulY == 0 &&
                 (m_ulW == 0 || m_ulW == ulW) &&
                 (m_ulH == 0 || m_ulH == ulH)) ? TRUE : FALSE);
    }

    ULONG32 GetBinaryLength() { return kBinaryLength; }

    ULONG32 RenderBinary(unsigned char *pBuffer)
    {
        ULONG32 ulCurPos = 0;

        ulCurPos += RenderBinaryType(pBuffer + ulCurPos, m_ulX);
        ulCurPos += RenderBinaryType(pBuffer + ulCurPos, m_ulY);
        ulCurPos += RenderBinaryType(pBuffer + ulCurPos, m_ulW);
        ulCurPos += RenderBinaryType(pBuffer + ulCurPos, m_ulH);

        return ulCurPos;
    };

    ULONG32 InitFromBinary(unsigned char *pBuffer)
    {
        ULONG32 ulCurPos = 0;

        ulCurPos += InitFromBinaryType(pBuffer + ulCurPos, m_ulX);
        ulCurPos += InitFromBinaryType(pBuffer + ulCurPos, m_ulY);
        ulCurPos += InitFromBinaryType(pBuffer + ulCurPos, m_ulW);
        ulCurPos += InitFromBinaryType(pBuffer + ulCurPos, m_ulH);

        return ulCurPos;
    };

    virtual void RenderText(GString &rText)         = 0;
    virtual BOOL InitFromText(GString &rText) = 0;
};


class CIMFSrcRect : public CIMFRect
{
public:
    CIMFSrcRect() : CIMFRect() {};

	CIMFSrcRect(const CIMFSrcRect &rRect) : CIMFRect(rRect) {};

	CIMFSrcRect(ULONG32 ulX, ULONG32 ulY, ULONG32 ulW, ULONG32 ulH) : CIMFRect(ulX, ulY, ulW, ulH) {};

    ~CIMFSrcRect() {};

    const CIMFSrcRect & operator = (const CIMFRect &rRect)
    {
        CIMFRect::operator=(rRect);

        return *this;
    };

    void RenderText(GString &rText);
    BOOL InitFromText(GString &rText);
};


class CIMFDstRect : public CIMFRect
{
public:
    CIMFDstRect() : CIMFRect() {};

	CIMFDstRect(const CIMFDstRect &rRect) : CIMFRect(rRect) {};

	CIMFDstRect(ULONG32 ulX, ULONG32 ulY, ULONG32 ulW, ULONG32 ulH) : CIMFRect(ulX, ulY, ulW, ulH) {};

    ~CIMFDstRect() {};

    const CIMFDstRect & operator = (const CIMFRect &rRect)
    {
        CIMFRect::operator=(rRect);

        return *this;
    };

    void RenderText(GString &rText);
    BOOL InitFromText(GString &rText);
};

#endif
