/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: jbuffsrc.c,v 1.1.26.1 2004/07/09 01:53:22 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/*
 * jbuffsrc.c
 *
 * This file contains decompression data source routines for the case of
 * reading the entire JFIF data file from a single buffer.
 */

/* this is not a core library module, so it doesn't define JPEG_INTERNALS */
#include "jinclude.h"
#include "jpeglib.h"
#include "jerror.h"


/* Expanded data source object for single-buffer input */
typedef struct
{
    struct jpeg_source_mgr m_cPublicSrcManager; /* public fields */
    unsigned char         *m_pEntireBuffer;     /* start of buffer */
    unsigned long          m_ulTotalBytes;      /* number total bytes in buffer */
}
buffer_src_mgr;

typedef buffer_src_mgr * buffer_src_ptr;

/*
 * Initialize source --- called by jpeg_read_header
 * before any data is actually read.
 */

METHODDEF(void) init_source (j_decompress_ptr cinfo)
{
    /* No work to do here */
}


/*
 * Fill the input buffer --- called whenever buffer is emptied.
 * Since the entire buffer is loaded into the manager, this
 * should never be called. Therefore, we will issue an ERREXIT()
 * if we are called.
 */

METHODDEF(boolean) fill_input_buffer (j_decompress_ptr cinfo)
{
    ERREXIT(cinfo, JERR_INPUT_EMPTY);

    return TRUE;
}


/*
 * Skip data --- used to skip over a potentially large amount of
 * uninteresting data (such as an APPn marker).
 */

METHODDEF(void) skip_input_data (j_decompress_ptr cinfo, long num_bytes)
{
    buffer_src_ptr src = (buffer_src_ptr) cinfo->src;

    if (num_bytes > 0 && num_bytes <= (long) src->m_cPublicSrcManager.bytes_in_buffer)
    {
        src->m_cPublicSrcManager.next_input_byte += (size_t) num_bytes;
        src->m_cPublicSrcManager.bytes_in_buffer -= (size_t) num_bytes;
    }
}

/*
 * Terminate source --- called by jpeg_finish_decompress
 * after all data has been read.  Often a no-op.
 */
METHODDEF(void) term_source (j_decompress_ptr cinfo)
{
    /* no work necessary here */
}


/*
 * Prepare for input from a single buffer. The buffer is assume to
 * be allocated and filled to at least the length specified in
 * the input.
 */

GLOBAL(void) jpeg_buffer_src(j_decompress_ptr cinfo, unsigned char *pBuf, unsigned long ulLen)
{
    buffer_src_ptr src;

    if (cinfo->src == NULL)
    {
        cinfo->src = (struct jpeg_source_mgr *) (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo,
                                                                            JPOOL_PERMANENT,
                                                                            SIZEOF(buffer_src_mgr));
        src        = (buffer_src_ptr) cinfo->src;
    }

    src = (buffer_src_ptr) cinfo->src;
    src->m_cPublicSrcManager.init_source       = init_source;
    src->m_cPublicSrcManager.fill_input_buffer = fill_input_buffer;
    src->m_cPublicSrcManager.skip_input_data   = skip_input_data;
    src->m_cPublicSrcManager.resync_to_restart = jpeg_resync_to_restart; /* use default method */
    src->m_cPublicSrcManager.term_source       = term_source;
    src->m_cPublicSrcManager.bytes_in_buffer   = ulLen;
    src->m_cPublicSrcManager.next_input_byte   = pBuf;
    src->m_ulTotalBytes                        = ulLen;
    src->m_pEntireBuffer                       = pBuf;
}
