/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxrect.cpp,v 1.1.26.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxresult.h"
#include "ihxpckts.h"

// hxcont
#include "hxbuffer.h"
#include "hxstring.h"

// hxmisc
#include "unkimp.h"
#include "baseobj.h"

// pxcomlib
#include "gstring.h"
#include "pxutil.h"
#include "pxrect.h"

// hxdebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

BEGIN_INTERFACE_LIST(PXRect)
END_INTERFACE_LIST

void PXRect::Pack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    if (ulMajVer <= 1 && ulMinVer <= 1)
    {
        Pack32(pBuffer, m_ulX);
        Pack32(pBuffer, m_ulY);
        Pack32(pBuffer, m_ulW);
        Pack32(pBuffer, m_ulH);
    }
    else
    {
        Pack16(pBuffer, (UINT16) m_ulX);
        Pack16(pBuffer, (UINT16) m_ulY);
        Pack16(pBuffer, (UINT16) m_ulW);
        Pack16(pBuffer, (UINT16) m_ulH);
    }
}

void PXRect::UnPack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    if (ulMajVer <= 1 && ulMinVer <= 1)
    {
        UnPack32(pBuffer, m_ulX);
        UnPack32(pBuffer, m_ulY);
        UnPack32(pBuffer, m_ulW);
        UnPack32(pBuffer, m_ulH);
    }
    else
    {
        UINT16 usTmp;
        UnPack16(pBuffer, usTmp);
        m_ulX = usTmp;
        UnPack16(pBuffer, usTmp);
        m_ulY = usTmp;
        UnPack16(pBuffer, usTmp);
        m_ulW = usTmp;
        UnPack16(pBuffer, usTmp);
        m_ulH = usTmp;
    }
}

#define LINEAR_PARAM(x1, x2, t, d, d2)  ((x1) + (((x2) - (x1)) * (t) + (d2)) / (d))

void PXRect::InterpolateRect(UINT32 ulTime, UINT32 ulStart, UINT32 ulEnd,
                             const PXRect& rStart, const PXRect& rEnd)
{
    if (ulTime <= ulStart)
    {
        m_ulX = rStart.m_ulX;
        m_ulY = rStart.m_ulY;
        m_ulW = rStart.m_ulW;
        m_ulH = rStart.m_ulH;
    }
    else if (ulTime > ulStart && ulTime < ulEnd)
    {
        HXxRect cStart, cEnd, cMid;
        cStart.left   = rStart.GetX();
        cStart.top    = rStart.GetY();
        cStart.right  = rStart.GetX() + rStart.GetWidth();
        cStart.bottom = rStart.GetY() + rStart.GetHeight();
        cEnd.left     = rEnd.GetX();
        cEnd.top      = rEnd.GetY();
        cEnd.right    = rEnd.GetX() + rEnd.GetWidth();
        cEnd.bottom   = rEnd.GetY() + rEnd.GetHeight();

        INT32 lDur    = (INT32) (ulEnd - ulStart);
        INT32 lDur2   = lDur >> 1;
        INT32 lTime   = (INT32) (ulTime - ulStart);
        cMid.left     = LINEAR_PARAM(cStart.left,   cEnd.left,   lTime, lDur, lDur2);
        cMid.top      = LINEAR_PARAM(cStart.top,    cEnd.top,    lTime, lDur, lDur2);
        cMid.right    = LINEAR_PARAM(cStart.right,  cEnd.right,  lTime, lDur, lDur2);
        cMid.bottom   = LINEAR_PARAM(cStart.bottom, cEnd.bottom, lTime, lDur, lDur2);

        m_ulX         = cMid.left;
        m_ulY         = cMid.top;
        m_ulW         = HXxRECT_WIDTH(cMid);
        m_ulH         = HXxRECT_HEIGHT(cMid);
    }
    else if (ulTime >= ulEnd)
    {
        m_ulX = rEnd.m_ulX;
        m_ulY = rEnd.m_ulY;
        m_ulW = rEnd.m_ulW;
        m_ulH = rEnd.m_ulH;
    }
}

