/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxeffect.cpp,v 1.1.26.1 2004/07/09 01:54:51 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxresult.h"
#include "ihxpckts.h"

// hxcont
#include "hxstring.h"

// hxmisc
#include "unkimp.h"
#include "baseobj.h"

// pxcomlib
#include "gstring.h"
#include "pxutil.h"
#include "pxrect.h"
#include "pxcolor.h"
#include "pxeffect.h"

// hxdebug
#include "hxassert.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

BEGIN_INTERFACE_LIST(PXEffect)
END_INTERFACE_LIST

UINT32 PXEffect::PackedSize(UINT32 ulMajVer, UINT32 ulMinVer)
{
    UINT32 ulOpaqueSize = 0;
    if (ulMajVer <= 1 && ulMinVer <= 4)
    {
        // Get the size of the opaque data
        UINT32 ulFixedSize[8] = {42, 66, 46, 66, 74, 58, 74, 67};
        ulOpaqueSize          = ulFixedSize[m_ucEffectType] + m_cURL.GetLength();
        if (m_ucEffectType == kEffectTypeExternal)
        {
            ulOpaqueSize += m_cPackage.GetLength() + m_cName.GetLength() +
                            m_cData.GetLength()    + m_cFile.GetLength();
        }
    }
#if defined(_DEBUG)
    else
    {
        HX_ASSERT(FALSE);
    }
#endif

    return ulOpaqueSize;
}

void PXEffect::Pack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    if (ulMajVer <= 1 && ulMinVer <= 4)
    {
        // Pack the common parts of the packet at the beginning
        Pack32(pBuffer,     2);
        UINT32 ulFlags = 0;
        if (m_bLastUse)
        {
            ulFlags |= 1;
        }
        if (m_bDisplayImmediately)
        {
            ulFlags |= 4;
        }
        if (m_bPostBackChannel)
        {
            ulFlags |= 8;
        }
        Pack32(pBuffer,     ulFlags);
        Pack32(pBuffer,     m_ucEffectType);
        Pack32(pBuffer,     m_ulStart);
        Pack32(pBuffer,     m_ulMaxFps);
        PackStringNoNullTerm(pBuffer, m_cURL);

        // Now here's the tricky part
        switch (m_ucEffectType)
        {
            case kEffectTypeFill:
                m_cColor.Pack(pBuffer,   ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                break;
            case kEffectTypeFadeIn:
            case kEffectTypeCrossFade:
                Pack32(pBuffer, m_ulDuration);
                Pack32(pBuffer, m_ulTarget);
                m_cSrcRect.Pack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                Pack32(pBuffer, (UINT32) m_bAspectFlag);
                break;
            case kEffectTypeFadeOut:
                Pack32(pBuffer, m_ulDuration);
                m_cColor.Pack(pBuffer,   ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                break;
            case kEffectTypeWipe:
                Pack32(pBuffer, m_ulDuration);
                Pack32(pBuffer, m_ucWipeType);
                Pack32(pBuffer, m_ucWipeDirection);
                Pack32(pBuffer, m_ulTarget);
                m_cSrcRect.Pack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                Pack32(pBuffer, (UINT32) m_bAspectFlag);
                break;
            case kEffectTypeViewChange:
                Pack32(pBuffer, m_ulDuration);
                m_cSrcRect.Pack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                break;
            case kEffectTypeExternal:
                Pack32(pBuffer, m_ulDuration);
                Pack32(pBuffer, m_ulTarget);
                m_cSrcRect.Pack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                Pack32(pBuffer, (UINT32) m_bAspectFlag);
                PackString(pBuffer, m_cPackage);
                PackString(pBuffer, m_cName);
                PackString(pBuffer, m_cData);
                PackString(pBuffer, m_cFile);
                break;
            case kEffectTypeAnimate:
                Pack32(pBuffer, m_ulDuration);
                Pack32(pBuffer, m_ulTarget);
                m_cSrcRect.Pack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.Pack(pBuffer, ulMajVer, ulMinVer);
                Pack32(pBuffer, (UINT32) m_bAspectFlag);
                break;
        }
    }
#if defined(_DEBUG)
    else
    {
        HX_ASSERT(FALSE);
    }
#endif
}

void PXEffect::UnPack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer)
{
    if (ulMajVer <= 1 && ulMinVer <= 4)
    {
        // Pack the common parts of the packet at the beginning
        UINT32 ulTmp;
        UnPack32(pBuffer,     ulTmp); // packet type
        UnPack32(pBuffer,     ulTmp); // flags
        m_bLastUse            = (ulTmp & 1 ? TRUE : FALSE);
        m_bDisplayImmediately = (ulTmp & 4 ? TRUE : FALSE);
        m_bPostBackChannel    = (ulTmp & 8 ? TRUE : FALSE);
        UnPack32(pBuffer,     ulTmp); // effect type
        m_ucEffectType = (BYTE) ulTmp;
        UnPack32(pBuffer,     m_ulStart);
        UnPack32(pBuffer,     m_ulMaxFps);
        UnPackStringNoNullTerm(pBuffer, m_cURL);

        // Now here's the tricky part
        switch (m_ucEffectType)
        {
            case kEffectTypeFill:
                m_cColor.UnPack(pBuffer,   ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_bHasTarget = FALSE;
                break;
            case kEffectTypeFadeIn:
            case kEffectTypeCrossFade:
                UnPack32(pBuffer, m_ulDuration);
                UnPack32(pBuffer, m_ulTarget);
                m_cSrcRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                UnPack32(pBuffer, ulTmp);
                m_bAspectFlag = (BOOL) ulTmp;
                m_bHasTarget  = TRUE;
                break;
            case kEffectTypeFadeOut:
                UnPack32(pBuffer, m_ulDuration);
                m_cColor.UnPack(pBuffer,   ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_bHasTarget  = FALSE;
                break;
            case kEffectTypeWipe:
                UnPack32(pBuffer, m_ulDuration);
                UnPack32(pBuffer, ulTmp);
                m_ucWipeType = (BYTE) ulTmp;
                UnPack32(pBuffer, ulTmp);
                m_ucWipeDirection = (BYTE) ulTmp;
                UnPack32(pBuffer, m_ulTarget);
                m_cSrcRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                UnPack32(pBuffer, ulTmp);
                m_bAspectFlag = (BOOL) ulTmp;
                m_bHasTarget  = TRUE;
                break;
            case kEffectTypeViewChange:
                UnPack32(pBuffer, m_ulDuration);
                m_cSrcRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_bHasTarget  = TRUE;
                break;
            case kEffectTypeExternal:
                UnPack32(pBuffer, m_ulDuration);
                UnPack32(pBuffer, m_ulTarget);
                m_cSrcRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                UnPack32(pBuffer, ulTmp);
                m_bAspectFlag = (BOOL) ulTmp;
                UnPackStringNoNullTerm(pBuffer, m_cPackage);
                UnPackStringNoNullTerm(pBuffer, m_cName);
                UnPackStringNoNullTerm(pBuffer, m_cData);
                UnPackStringNoNullTerm(pBuffer, m_cFile);
                m_bHasTarget  = TRUE;
                break;
            case kEffectTypeAnimate:
                UnPack32(pBuffer, m_ulDuration);
                UnPack32(pBuffer, m_ulTarget);
                m_cSrcRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                m_cDstRect.UnPack(pBuffer, ulMajVer, ulMinVer);
                UnPack32(pBuffer, ulTmp);
                m_bAspectFlag = (BOOL) ulTmp;
                m_bHasTarget  = TRUE;
                break;
        }
    }
#if defined(_DEBUG)
    else
    {
        HX_ASSERT(FALSE);
    }
#endif
}

BOOL PXEffect::IsOverlapped(PXEffect* pEffect)
{
    BOOL bOverlap = FALSE;
    if (pEffect)
    {
        // Let's first make sure this is not the same effect
        if (m_ulHandle != pEffect->m_ulHandle)
        {
            if (m_ulStart                < pEffect->m_ulStart + pEffect->m_ulDuration &&
                m_ulStart + m_ulDuration > pEffect->m_ulStart) // XXXMEH - should these be >= && <=??
            {
                // These two effects ARE overlapped in time. Now, are they
                // overlapped in space?
                // or the overlap returns
                if (m_cDstRect.IsNull()          ||
                    pEffect->m_cDstRect.IsNull() ||
                    m_cDstRect.IsOverlapped(pEffect->m_cDstRect))
                {
                    bOverlap = TRUE;
                }
            }
        }

    }
    return bOverlap;
}

