/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpfile.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef RPFILE_H
#define RPFILE_H

class CHXMapLongToObj;
class CHXSimpleList;

class PXRealPixFile : public CHXBaseCountingObject,
                      public CUnknownIMP
{
    DECLARE_UNKNOWN(PXRealPixFile)
public:
    enum
    {
        kTimeFormatDHMS         = 0,
        kTimeFormatMilliseconds = 1
    };

    HX_RESULT   SetTitle(const char* pszTitle);
    HX_RESULT   SetTitle(IHXBuffer* pTitleStr);
    HX_RESULT   GetTitle(IHXBuffer** ppTitleStr);

    HX_RESULT   SetAuthor(const char* pszAuthor);
    HX_RESULT   SetAuthor(IHXBuffer* pAuthorStr);
    HX_RESULT   GetAuthor(IHXBuffer** ppAuthorStr);

    HX_RESULT   SetCopyright(const char* pszCopyright);
    HX_RESULT   SetCopyright(IHXBuffer* pCopyrightStr);
    HX_RESULT   GetCopyright(IHXBuffer** ppCopyrightStr);

    void        SetStart(UINT32 ulStart);
    UINT32      GetStart() const;

    void        SetDuration(UINT32 ulDuration);
    UINT32      GetDuration() const;

    void        SetPreroll(UINT32 ulPreroll);
    UINT32      GetPreroll() const;

    void        SetBitrate(UINT32 ulBitrate);
    UINT32      GetBitrate() const;

    void        SetDisplayWidth(UINT32 ulWidth);
    UINT32      GetDisplayWidth() const;

    void        SetDisplayHeight(UINT32 ulHeight);
    UINT32      GetDisplayHeight() const;

    HX_RESULT   SetTimeFormat(UINT32 ulTimeFormat);
    UINT32      GetTimeFormat() const;

    void        SetBackgroundColor(UINT32 ulColor); // in 0x00RRGGBB register format
    void        SetBackgroundColor(BYTE ucRed, BYTE ucGreen, BYTE ucBlue);
    UINT32      GetBackgroundColor() const;

    void        SetBackgroundOpacity(UINT32 ulOpacity);
    UINT32      GetBackgroundOpacity() const;

    void        SetDefaultMaxFps(UINT32 ulMaxFps);
    UINT32      GetDefaultMaxFps() const;

    void        SetDefaultAspectFlag(BOOL bAspectFlag);
    BOOL        GetDefaultAspectFlag() const;

    void        SetDefaultCenterFlag(BOOL bCenterFlag);
    BOOL        GetDefaultCenterFlag() const;

    HX_RESULT   SetDefaultURL(const char* pszDefaultURL);
    HX_RESULT   SetDefaultURL(IHXBuffer* pDefaultURLStr);
    HX_RESULT   GetDefaultURL(IHXBuffer** ppDefaultURLStr);

    void        SetContentVersion(UINT32 ulVersion);
    void        SetContentVersionToAtLeast(UINT32 ulVersion);
    UINT32      GetContentVersion() const;


    HX_RESULT   AddImage(UINT32 ulHandle, const char* pszName);
    HX_RESULT   AddImage(UINT32 ulHandle, IHXBuffer* pName);
    UINT32      GetNumImages() const;
    UINT32      GetNumImagesWithNoSize() const;
    HX_RESULT   GetImageIterator(REF(void*) rpIterator);
    HX_RESULT   GetNextImageHandle(REF(void*) rpIterator, REF(UINT32) rulHandle);
    BOOL        IsImagePresent(UINT32 ulHandle);
    HX_RESULT   GetImageName(UINT32 ulHandle, REF(IHXBuffer*) rpNameStr);
    HX_RESULT   GetImageName(UINT32 ulHandle, REF(const char*) rpszName);
    const char* GetImageName(UINT32 ulHandle);
    HX_RESULT   SetImageName(UINT32 ulHandle, IHXBuffer* pNameStr);
    HX_RESULT   SetImageName(UINT32 ulHandle, const char* pszName);
    HX_RESULT   GetImageErrorStatus(UINT32 ulHandle, REF(HX_RESULT) rlStatus);
    HX_RESULT   SetImageErrorStatus(UINT32 ulHandle, HX_RESULT lStatus);
    HX_RESULT   GetImageSize(UINT32 ulHandle, REF(UINT32) rulSize);
    UINT32      GetImageSize(UINT32 ulHandle);
    HX_RESULT   SetImageSize(UINT32 ulHandle, UINT32 ulSize);
    BOOL        IsImageSizeInitialized(UINT32 ulHandle);
    HX_RESULT   GetImageFileMimeType(UINT32 ulHandle, REF(IHXBuffer*) rpMimeStr);
    HX_RESULT   GetImageFileMimeType(UINT32 ulHandle, REF(const char*) rpszMime);
    const char* GetImageFileMimeType(UINT32 ulHandle);
    HX_RESULT   SetImageFileMimeType(UINT32 ulHandle, IHXBuffer* pMimeStr);
    HX_RESULT   SetImageFileMimeType(UINT32 ulHandle, const char* pszMime);
    HX_RESULT   GetImageStreamMimeType(UINT32 ulHandle, REF(IHXBuffer*) rpMimeStr);
    HX_RESULT   GetImageStreamMimeType(UINT32 ulHandle, REF(const char*) rpszMime);
    const char* GetImageStreamMimeType(UINT32 ulHandle);
    HX_RESULT   SetImageStreamMimeType(UINT32 ulHandle, IHXBuffer* pMimeStr);
    HX_RESULT   SetImageStreamMimeType(UINT32 ulHandle, const char* pszMime);
    HX_RESULT   GetAllImageInfo(UINT32 ulHandle, REF(UINT32) rulSize, REF(IHXBuffer*) rpNameStr,
                                REF(IHXBuffer*) rpFileMimeStr, REF(IHXBuffer*) rpStreamMimeStr);
    HX_RESULT   GetAllImageInfo(UINT32 ulHandle, REF(UINT32) rulSize, REF(const char*) rpszName,
                                REF(const char*) rpszFileMime, REF(const char*) rpszStreamMime);
    BOOL        AllImageSizesInitialized();
    BOOL        AllImageSizesOK();
    HX_RESULT   GetFailedImageName(REF(IHXBuffer*) rpFailedNameStr);

    HX_RESULT   AddEffect(PXEffect* pEffect);
    UINT32      GetNumEffects() const;
    HX_RESULT   GetEffectHeadIterator(REF(void*) rpIterator);
    HX_RESULT   GetEffectTailIterator(REF(void*) rpIterator);
    HX_RESULT   GetAtNextEffect(REF(void*) rpIterator, REF(PXEffect*) rpEffect);
    HX_RESULT   GetNextEffect(REF(void*) rpIterator, REF(PXEffect*) rpEffect);
    HX_RESULT   GetPrevEffect(REF(void*) rpIterator, REF(PXEffect*) rpEffect);
    HX_RESULT   GetCurrentEffect(void* pIterator, REF(PXEffect*) rpEffect);

    HX_RESULT   SetFileName(const char* pszFileName);
    HX_RESULT   SetFileName(IHXBuffer* pFileNameStr);
    HX_RESULT   GetFileName(IHXBuffer** ppFileNameStr);
    const char* GetFileName();

    HX_RESULT   PostParseInit();
protected:
    PXRealPixFile();
    virtual ~PXRealPixFile();

    // private enums
    enum
    {
        kMinDuration = 100
    };

    class PXImageInfo
    {
    public:
        PXImageInfo()
        {
            m_ulHandle       = 0;
            m_ulSize         = 0xFFFFFFFF;
            m_pNameStr       = NULL;
            m_pFileMimeStr   = NULL;
            m_pStreamMimeStr = NULL;
            m_lErrorStatus   = HXR_NOT_INITIALIZED;
        };

        ~PXImageInfo()
        {
            HX_RELEASE(m_pNameStr);
            HX_RELEASE(m_pFileMimeStr);
            HX_RELEASE(m_pStreamMimeStr);
        };

        UINT32      m_ulHandle;
        UINT32      m_ulSize;
        IHXBuffer* m_pNameStr;
        IHXBuffer* m_pFileMimeStr;
        IHXBuffer* m_pStreamMimeStr;
        HX_RESULT   m_lErrorStatus;
    };

    void            ClearImageMap();
    void            ClearEffectsList();
    HX_RESULT       SetString(const char* pszStr, IHXBuffer** ppStr);
    HX_RESULT       SetString(IHXBuffer* pStr, IHXBuffer** ppStr);
    HX_RESULT       GetString(IHXBuffer* pInStr, IHXBuffer** ppOutStr);
    HX_RESULT       GetImageInfo(UINT32 ulHandle, REF(PXImageInfo*) rpInfo);

    IHXBuffer*       m_pTitleStr;
    IHXBuffer*       m_pAuthorStr;
    IHXBuffer*       m_pCopyrightStr;
    UINT32           m_ulStart;
    UINT32           m_ulDuration;
    UINT32           m_ulPreroll;
    UINT32           m_ulBitrate;
    UINT32           m_ulWidth;
    UINT32           m_ulHeight;
    UINT32           m_ulTimeFormat;
    UINT32           m_ulBackgroundColor;
    UINT32           m_ulBackgroundOpacity;
    UINT32           m_ulDefaultMaxFps;
    BOOL             m_bDefaultAspectFlag;
    BOOL             m_bDefaultCenterFlag;
    IHXBuffer*       m_pDefaultURLStr;
    UINT32           m_ulContentVersion;
    CHXMapLongToObj* m_pImageMap;
    CHXSimpleList*   m_pEffectsList;
    IHXBuffer*       m_pFileNameStr;
};

inline HX_RESULT PXRealPixFile::SetString(const char* pszStr, IHXBuffer** ppStr)
{
    HX_RESULT retVal = HXR_OK;

    if (pszStr && ppStr)
    {
        HX_RELEASE(*ppStr);
        *ppStr = (IHXBuffer*) new CHXBuffer();
        if (*ppStr)
        {
            (*ppStr)->AddRef();
            retVal = (*ppStr)->SetSize(strlen(pszStr) + 1);
            if (SUCCEEDED(retVal))
            {
                strcpy((char*) (*ppStr)->GetBuffer(), pszStr); /* Flawfinder: ignore */
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }
    else
    {
        return HXR_INVALID_PARAMETER;
    }

    return retVal;
}

inline HX_RESULT PXRealPixFile::SetString(IHXBuffer* pStr, IHXBuffer** ppStr)
{
    HX_RESULT retVal = HXR_OK;

    if (pStr && ppStr)
    {
        if (pStr->GetBuffer())
        {
            if (strlen((const char*) pStr->GetBuffer()) > 0)
            {
                HX_RELEASE(*ppStr);
                *ppStr = pStr;
                (*ppStr)->AddRef();
            }
            else
            {
                retVal = HXR_FAIL;
            }
        }
        else
        {
            retVal = HXR_FAIL;
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }
    
    return retVal;
}

inline HX_RESULT PXRealPixFile::GetString(IHXBuffer* pInStr, IHXBuffer** ppOutStr)
{
    HX_RESULT retVal = HXR_OK;

    if (ppOutStr)
    {
        if (pInStr)
        {
            *ppOutStr = pInStr;
            (*ppOutStr)->AddRef();
        }
        else
        {
            retVal = HXR_NOT_INITIALIZED;
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

inline HX_RESULT PXRealPixFile::SetTitle(const char* pszTitle)
{
    return SetString(pszTitle, &m_pTitleStr);
}

inline HX_RESULT PXRealPixFile::SetTitle(IHXBuffer* pTitleStr)
{
    return SetString(pTitleStr, &m_pTitleStr);
}

inline HX_RESULT PXRealPixFile::GetTitle(IHXBuffer** ppTitleStr)
{
    return GetString(m_pTitleStr, ppTitleStr);
}

inline HX_RESULT PXRealPixFile::SetAuthor(const char* pszAuthor)
{
    return SetString(pszAuthor, &m_pAuthorStr);
}

inline HX_RESULT PXRealPixFile::SetAuthor(IHXBuffer* pAuthorStr)
{
    return SetString(pAuthorStr, &m_pAuthorStr);
}

inline HX_RESULT PXRealPixFile::GetAuthor(IHXBuffer** ppAuthorStr)
{
    return GetString(m_pAuthorStr, ppAuthorStr);
}

inline HX_RESULT PXRealPixFile::SetCopyright(const char* pszCopyright)
{
    return SetString(pszCopyright, &m_pCopyrightStr);
}

inline HX_RESULT PXRealPixFile::SetCopyright(IHXBuffer* pCopyrightStr)
{
    return SetString(pCopyrightStr, &m_pCopyrightStr);
}

inline HX_RESULT PXRealPixFile::GetCopyright(IHXBuffer** ppCopyrightStr)
{
    return GetString(m_pCopyrightStr, ppCopyrightStr);
}

inline HX_RESULT PXRealPixFile::SetDefaultURL(const char* pszDefaultURL)
{
    return SetString(pszDefaultURL, &m_pDefaultURLStr);
}

inline HX_RESULT PXRealPixFile::SetDefaultURL(IHXBuffer* pDefaultURLStr)
{
    return SetString(pDefaultURLStr, &m_pDefaultURLStr);
}

inline HX_RESULT PXRealPixFile::GetDefaultURL(IHXBuffer** ppDefaultURLStr)
{
    return GetString(m_pDefaultURLStr, ppDefaultURLStr);
}

inline void PXRealPixFile::SetStart(UINT32 ulStart)
{
    m_ulStart = ulStart;
}

inline UINT32 PXRealPixFile::GetStart() const
{
    return m_ulStart;
}

inline void PXRealPixFile::SetDuration(UINT32 ulDuration)
{
    m_ulDuration = ulDuration;
}

inline UINT32 PXRealPixFile::GetDuration() const
{
    return m_ulDuration;
}

inline void PXRealPixFile::SetPreroll(UINT32 ulPreroll)
{
    m_ulPreroll = ulPreroll;
}

inline UINT32 PXRealPixFile::GetPreroll() const
{
    return m_ulPreroll;
}

inline void PXRealPixFile::SetBitrate(UINT32 ulBitrate)
{
    m_ulBitrate = ulBitrate;
}

inline UINT32 PXRealPixFile::GetBitrate() const
{
    return m_ulBitrate;
}

inline void PXRealPixFile::SetDisplayWidth(UINT32 ulWidth)
{
    m_ulWidth = ulWidth;
}

inline UINT32 PXRealPixFile::GetDisplayWidth() const
{
    return m_ulWidth;
}

inline void PXRealPixFile::SetDisplayHeight(UINT32 ulHeight)
{
    m_ulHeight = ulHeight;
}

inline UINT32 PXRealPixFile::GetDisplayHeight() const
{
    return m_ulHeight;
}

inline HX_RESULT PXRealPixFile::SetTimeFormat(UINT32 ulTimeFormat)
{
    HX_RESULT retVal = HXR_OK;

    if (ulTimeFormat == kTimeFormatDHMS ||
        ulTimeFormat == kTimeFormatMilliseconds)
    {    
        m_ulTimeFormat = ulTimeFormat;
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

inline UINT32 PXRealPixFile::GetTimeFormat() const
{
    return m_ulTimeFormat;
}

inline void PXRealPixFile::SetBackgroundColor(UINT32 ulColor)
{
    m_ulBackgroundColor = ulColor;
}

inline void PXRealPixFile::SetBackgroundColor(BYTE ucRed, BYTE ucGreen, BYTE ucBlue)
{
    m_ulBackgroundColor = (ucRed << 16) | (ucGreen << 8) | ucBlue;
}

inline UINT32 PXRealPixFile::GetBackgroundColor() const
{
    return m_ulBackgroundColor;
}

inline void PXRealPixFile::SetBackgroundOpacity(UINT32 ulOpacity)
{
    m_ulBackgroundOpacity = (ulOpacity > 255 ? 255 : ulOpacity);
}

inline UINT32 PXRealPixFile::GetBackgroundOpacity() const
{
    return m_ulBackgroundOpacity;
}

inline void PXRealPixFile::SetDefaultMaxFps(UINT32 ulMaxFps)
{
    m_ulDefaultMaxFps = ulMaxFps;
}

inline UINT32 PXRealPixFile::GetDefaultMaxFps() const
{
    return m_ulDefaultMaxFps;
}

inline void PXRealPixFile::SetDefaultAspectFlag(BOOL bAspectFlag)
{
    m_bDefaultAspectFlag = bAspectFlag;
}

inline BOOL PXRealPixFile::GetDefaultAspectFlag() const
{
    return m_bDefaultAspectFlag;
}

inline void PXRealPixFile::SetDefaultCenterFlag(BOOL bCenterFlag)
{
    m_bDefaultCenterFlag = bCenterFlag;
}

inline BOOL PXRealPixFile::GetDefaultCenterFlag() const
{
    return m_bDefaultCenterFlag;
}

inline void PXRealPixFile::SetContentVersion(UINT32 ulVersion)
{
    m_ulContentVersion = ulVersion;
}

inline void PXRealPixFile::SetContentVersionToAtLeast(UINT32 ulVersion)
{
    if (m_ulContentVersion < ulVersion)
    {
        m_ulContentVersion = ulVersion;
    }
}

inline UINT32 PXRealPixFile::GetContentVersion() const
{
    return m_ulContentVersion;
}

inline HX_RESULT PXRealPixFile::SetFileName(const char* pszFileName)
{
    return SetString(pszFileName, &m_pFileNameStr);
}

inline HX_RESULT PXRealPixFile::SetFileName(IHXBuffer* pFileNameStr)
{
    return SetString(pFileNameStr, &m_pFileNameStr);
}

inline HX_RESULT PXRealPixFile::GetFileName(IHXBuffer** ppFileNameStr)
{
    return GetString(m_pFileNameStr, ppFileNameStr);
}

inline const char* PXRealPixFile::GetFileName()
{
    const char* pszRet = NULL;
    if (m_pFileNameStr)
    {
        pszRet = (const char*) m_pFileNameStr->GetBuffer();
    }
    return pszRet;
}

#endif
