/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxrndcod.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXRNDCOD_H
#define PXRNDCOD_H

/****************************************************************************
 *
 *  Typical Usage of IHXRealPixRendererCodec:
 *
 *  Assume: a) We have an image file which is broken up into N contiguous
 *             IHXBuffers, labelled buffer 0 to buffer N-1.
 *          b) We have already identified the correct codec for our image format
 *             by calling GetRendererCodecInfo() and/or ValidInputData().
 *          c) The image in the file has F frames, labelled frame 0 through
 *             frame F-1
 *
 *  1. Call GetHeaderInfo(), passing in buffer 0
 *  2. Call GetFrameInfo() F times (with ulFrameNum going from 0 to F-1)
 *  3. Allocate F output buffers, each of the appropriate size.
 *  4. Call SetDecompressParam() F times.
 *  5. Call Decompress() N times, passing in buffers 0 through N-1.
 *  6. Call FinishDecompress().
 *
 ****************************************************************************/
typedef _INTERFACE IHXRealPixRendererCodec  IHXRealPixRendererCodec;
typedef _INTERFACE IHXValues  IHXValues;

#define DECOMPRESS_STATUS_INPROGRESS  0
#define DECOMPRESS_STATUS_FINISHED    1
#define DECOMPRESS_STATUS_ABORTED    -1

/****************************************************************************
 *
 *  Interface: IHXRealPixRendererCodec
 *
 *  Purpose:   Interface between RealPix renderer and codec
 *
 *  IID_IHXRealPixRendererCodec: {10552E61-C6F1-11d2-8A4F-28909A000000}
 *
 ****************************************************************************/
DEFINE_GUID(IID_IHXRealPixRendererCodec, 0x10552e61, 0xc6f1, 0x11d2, 0x8a, 0x4f,
            0x28, 0x90, 0x9a, 0x0, 0x0, 0x0);

#undef  INTERFACE
#define INTERFACE IHXRealPixRendererCodec

DECLARE_INTERFACE_(IHXRealPixRendererCodec, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)  (THIS) PURE;

    STDMETHOD_(UINT32,Release) (THIS) PURE;

    /*
     * IHXRealPixRendererCodec Methods
     */

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::GetRendererCodecInfo()
     *  Purpose:
     *      Returns the information about the codec: an array of mime types
     *      which this codec supports, and the highest supported content and
     *      stream version.
     */
    STDMETHOD(GetRendererCodecInfo) (THIS_ REF(const char**) rppszFileMimeType,
                                           REF(UINT32)       rulHighestSupportedContentVersion,
                                           REF(UINT32)       rulHighestSupportedStreamVersion) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::ValidInputData()
     *  Purpose:
     *      Determines whether the input buffer contains data which can
     *      be decoded by this codec.
     */
    STDMETHOD(ValidInputData) (THIS_ IHXBuffer* pBuffer, REF(BOOL) rbValid) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::GetHeaderInfo()
     *  Purpose:
     *      This method passes in the header of the compressed
     *      image and finds out information about the image, such as the
     *      number of frames. Also, a session handle is
     *      returned as an out parameter. This session handle should be used
     *      for all successive calls regarding this image.
     *      Special-case or codec-specific header info may be returned in rpImageInfo
     *      if necessary.
     */
    STDMETHOD(GetHeaderInfo) (THIS_ IHXBuffer*      pBuffer,
                                    IHXBuffer*      pOpaqueImageData,
                                    REF(HXxSize)     rImageDim,
                                    REF(UINT32)      rulNumFrames,
                                    REF(IHXValues*) rpImageInfo,
                                    REF(UINT32)      rulSessionHandle) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::GetFrameInfo()
     *  Purpose:
     *      This method finds out information about each
     *      frame in a multi-frame image. Special or codec-specific information
     *      about each frame may be returned in rpFrameInfo.
     */
    STDMETHOD(GetFrameInfo) (THIS_ UINT32           ulSessionHandle,
                                   UINT32           ulFrameNum,
                                   REF(HXxRect)     rFrameDim,
                                   REF(IHXValues*) rpFrameInfo) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::SetDecompressParam()
     *  Purpose:
     *      This methods sets the decompression parameters, such as the
     *      output width and height. It also sets the output buffer and
     *      gives the color and pixel format to which the image should be
     *      decoded. Additional codec-specific decompression parameters
     *      can be set in pMoreParam.
     */
    STDMETHOD(SetDecompressParam) (THIS_ UINT32      ulSessionHandle,
                                         UINT32      ulFrameNum,
                                         IHXBuffer* pOutputBuffer,
                                         HXxSize     cFrameDim,
                                         UINT32      ulRowStride,
                                         UINT32      ulBitsPerPixel,
                                         UINT32      ulColorFormat,
                                         BOOL        bRowsInverted,
                                         IHXValues* pMoreParam) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::Decompress()
     *  Purpose:
     *      This method actually decodes the compressed data in pBuffer into
     *      the appropriate output buffer. 
     */
    STDMETHOD(Decompress) (THIS_ UINT32      ulSessionHandle,
                                 IHXBuffer* pBuffer,
                                 IHXBuffer* pOpaquePacketData) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::GetDecompressStatus()
     *  Purpose:
     *      This method gets returns the status of the decompression. If the
     *      status returns DECODE_STATUS_INPROGRESS, then decompression is
     *      progressing OK and the codec is expecting more data. If the status
     *      is DECODE_STATUS_FINISHED, then the end of the image has been
     *      reached and the codec is not expecting any more data. If the
     *      status is DECODE_STATUS_ABORTED, then the decompression was
     *      aborted and the codec will not accept any more data for this
     *      decompression session.
     */
    STDMETHOD(GetDecompressStatus) (THIS_ UINT32     ulSessionHandle,
                                          REF(INT32) rlStatus) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixRendererCodec::FinishDecompress()
     *  Purpose:
     *      This method informs the codec that the caller is finished
     *      with this decompression session and the codec can release
     *      any resources allocated for this session. The codec should
     *      be prepared to accept FinishDecompress() at any time after
     *      GetHeaderInfo().
     */
    STDMETHOD(FinishDecompress) (THIS_ UINT32 ulSessionHandle) PURE;
};

#endif

