/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: wmbufctl.h,v 1.2.8.1 2004/07/09 02:05:58 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef WMBUFCTL_H
#define WMBUFCTL_H

#include "hxbufctl.h"

class HXWatermarkBufferControl : public IHXWatermarkBufferControl
{
public:
    HXWatermarkBufferControl();
    
    /*
     *	IUnknown methods
     */
    STDMETHOD(QueryInterface)   (THIS_
                                REFIID riid,
                                void** ppvObj);

    STDMETHOD_(ULONG32,AddRef)  (THIS);

    STDMETHOD_(ULONG32,Release) (THIS);

    /*
     * IHXBufferControl method
     */

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::Init
     *	Purpose:
     *      Initialize the buffer control object with a context
     *      so it can find the interfaces it needs to do buffer
     *      control
     */
    STDMETHOD(Init) (THIS_ IUnknown* pContext);

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnBuffering
     *	Purpose:
     *      Called while buffering
     */
    STDMETHOD(OnBuffering) (THIS_ UINT32 ulRemainingInMs,
			    UINT32 ulRemainingInBytes);

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnBufferingDone
     *	Purpose:
     *      Called when buffering is done
     */
    STDMETHOD(OnBufferingDone)(THIS);


    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnResume
     *	Purpose:
     *      Called when playback is resumed
     */
    STDMETHOD(OnResume) (THIS);
    
    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnPause
     *	Purpose:
     *      Called when playback is paused
     */
    STDMETHOD(OnPause) (THIS);

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnSeek
     *	Purpose:
     *      Called when a seek occurs
     */
    STDMETHOD(OnSeek) (THIS);

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::OnClipEnd
     *	Purpose:
     *      Called when we get the last packet in the clip
     */
    STDMETHOD(OnClipEnd) (THIS);

    /************************************************************************
     *	Method:
     *	    IHXBufferControl::Close()
     *	Purpose:
     *      Called when the owner of this object wishes to shutdown
     *      and destroy this object. This call causes the buffer control
     *      object to release all it's interfaces references.
     */
    STDMETHOD(Close)(THIS);

    /*
     * IHXWatermarkBufferControl method
     */

    /************************************************************************
     *	Method:
     *	    IHXWatermarkBufferControl::SetSource
     *	Purpose:
     *      Tells the object what HXSource object it is associated with.
     */
    STDMETHOD(SetSource)(THIS_ HXSource* pSource);

    /************************************************************************
     *	Method:
     *	    IHXWatermarkBufferControl::OnBufferReport
     *	Purpose:
     *      Initiates control operations based on buffering information.
     *      
     */
    STDMETHOD(OnBufferReport)(THIS_ UINT32 ulBufferInMs,
			      UINT32 ulBuffer);

    /************************************************************************
     *	Method:
     *	    IHXWatermarkBufferControl::ClearChillState
     *	Purpose:
     *      Sets the chill state to NONE
     *      
     */
    STDMETHOD(ClearChillState)(THIS);

private:
    ~HXWatermarkBufferControl();
    HX_RESULT ChangeAccelerationStatus(BOOL bMayBeAccelerated,
				       BOOL bUseAccelerationFactor,
				       UINT32 ulAccelerationFactor);
    HX_RESULT ResetAccelState();

    ULONG32 m_lRefCount;
    HXSource* m_pSource;

    enum ChillState { HX_NONE, CHILL, HALF, HUNDRETH };

    enum ChillState m_ChillState;
};

#endif /* WMBUFCTL_H */
