/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxbufstate.h,v 1.1.22.4 2004/07/09 02:05:57 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */
#ifndef HXBUFSTATE_H
#define HXBUFSTATE_H

#include "hxtypes.h"
#include "hxresult.h"
#include "hxcom.h"
#include "hxsmbw.h" // IHXASMProps
#include "hxslist.h" // CHXSimpleList

class HXBufferingState
{
public:
    HXBufferingState();
    ~HXBufferingState();

    void OnStreamHeader(UINT32 ulPreroll,
			UINT32 ulPredata,
			BOOL preDataAtStart,
			BOOL preDataAfterSeek,
			BOOL prerollAtStart,
			BOOL prerollAfterSeek,
			ULONG32 ulAvgBitRate);

    void OnStream(IUnknown* pStream);

    void Init(ULONG32 ulPerfectPlayTime);
    
    void SetMinimumPreroll(UINT32 ulSourcePreroll, 
			   UINT32 ulInitialAudioPreroll,
			   UINT32 ulPerfectPlayTime,
			   BOOL   bIsRebuffering);
    void Stop();
    void Reset(BOOL bIsSeeking, UINT32 ulSeekTime);
    void GetRemainToBuffer(REF(UINT32)	ulRemainToBufferInMs,
			   REF(UINT32)	ulRemainToBuffer);

    ULONG32 GetMinPrerollInMs() { return m_ulMinimumPrerollInMs;}
    UINT16 GetPercentDone(BOOL bIsSeekPerformed);

    void SetPreroll(ULONG32 ulPreroll) { m_ulPreroll = ulPreroll;}
    void UpdatePreroll(ULONG32 ulPreroll);

    void SetPredata(ULONG32 ulPredata) { m_ulPredata = ulPredata;}

    BOOL HasPreroll(BOOL bIsSeekPerformed);
    BOOL HasPredata(BOOL bIsSeekPerformed);

    INT64 CreateINT64Timestamp(UINT32 ulTime);
    INT64 CreateINT64Timesync(UINT32 ulTime);

    void OnPacket(UINT32 ulTimestamp, UINT32 ulPacketSize, 
		  UINT32 ulElapsedTime, BOOL bIsLive,
		  BOOL bIsBufferedPlayMode);

    void UpdateBufferingInMs(INT64 llRefLowTimestamp,
			     INT64 llHighTimestamp, 
			     BOOL bIsBufferedPlayMode,
			     BOOL bIsTimestampDelivery,
			     UINT32 ulElapsedTime);

    void UpdateTransportStats(INT64 llLowTSAtTransport,
			      INT64 llHighTSAtTransport,
			      ULONG32 ulBytesAtTransport,
			      BOOL bDoneAtTransport);

    HX_RESULT GetBufferingStats(REF(INT64) llLowTimestamp, 
				REF(INT64) llHighTimestamp,
				REF(UINT32) ulBytesBuffered,
				BOOL bUseTransportStats);

    void GetExcessBufferInfo(INT64 llTheLowestTS,
			     INT64 llTheHighestTS,
			     BOOL bIsSeekPerformed,
			     REF(UINT32) ulRemainToBufferInMs,
			     REF(UINT32) ulRemainToBuffer,
			     REF(UINT32)	ulExcessBufferInMs,
			     REF(UINT32)	ulExcessBuffer,
			     REF(UINT32) ulExcessForThisStreamInMs,
			     REF(UINT32) ulExcessForThisStream);
    
    UINT32 LastPacketTimestamp() {return m_ulLastPacketTimeStamp;}
    
    INT64 LowTS() { return m_llLowestTimeStamp;}

    UINT32 AvgBandwidth() { return m_ulAvgBandwidth;}

    void OnTimeSync(UINT32 ulCurrentTime);

    // Should remove
    void SetAvgBWToASMBw();
    BOOL DoneAtTransport() { return ((m_ulNumBytesAtTransport == 0) &&
				     m_bDoneAtTransport);}
private:
    void SetMinPrerollInMs(ULONG32 ulMinPrerollInMs, 
			   ULONG32 ulMinBufferingInMs);
    void UpdateCurrentBufferingInMs(INT64 llLowestTimeStamp, 
				    INT64 llHighestTimeStamp);

    void SetMinPreroll();
    void SetMinPreroll(UINT32 ulMinPreroll, UINT32 ulMinBuffering);

    void UpdateMinPredata();

    BOOL DataBasedPreroll() { return (m_preDataAtStart || m_preDataAfterSeek);}

    ULONG32 MsToBytes(UINT32 ulValueInMs, UINT32 ulBw) const;
    
    void CalcRemainingToBufferInMs();
    void CalcRemainingToBufferInMs(ULONG32 ulElapsedTime);
    void CalcRemainingToBuffer();
    void CalcRemainingToBuffer(ULONG32 ulDenom);

    UINT32 CalcRemaining(UINT32 ulMinimumBuffering,
			 UINT32 ulCurrentBuffering,
			 UINT32 ulMinimumPreroll,
			 UINT32 ulDenom) const;
    
    /* Functions for tracking the amount of data
     * buffered in the renderer
     */
    void ClearPktInfo(); /* Clears out information about buffered packets */
    void AddPktInfo(INT64 llTimestamp, UINT32 ulPacketSize); /* Called when
							      * a packet is 
							      * sent to the
							      * renderer 
							      */
    UINT32 GetBufferedData(); /* Get the current amount of data buffered
			       * in the renderer
			       */

    ULONG32		m_ulPreroll;
    ULONG32		m_ulPredata;

    UINT32		m_ulMinimumPrerollInMs;
    UINT32		m_ulMinimumPreroll;

    UINT32		m_ulMinimumBufferingInMs;
    UINT32		m_ulMinimumBuffering;

    UINT32		m_ulRemainingToBufferInMs;
    UINT32		m_ulRemainingToBuffer;

    UINT32		m_ulCurrentBufferingInMs;
    UINT32		m_ulCurrentBuffering;

    HX_BITFIELD		m_bIsFirstPacket : 1;
    HX_BITFIELD		m_preDataAtStart : 1;
    HX_BITFIELD		m_prerollAtStart : 1;
    HX_BITFIELD		m_preDataAfterSeek : 1;
    HX_BITFIELD		m_prerollAfterSeek : 1;   

    INT64		m_llLowestTimeStamp;
    INT64		m_llHighestTimeStamp;

    INT64		m_llLowestTimestampAtTransport; 
    INT64		m_llHighestTimestampAtTransport; 
    UINT32		m_ulNumBytesAtTransport;
    BOOL		m_bDoneAtTransport;

    UINT32		m_ulTSRollOver;
    ULONG32		m_ulLastPacketTimeStamp;
    ULONG32		m_ulAvgBandwidth;
    IHXASMProps*	m_pASMProps;
    UINT32              m_ulLastTimeSync;
    INT64               m_llFirstLivePacketTimestamp;
    UINT32              m_ulTimeSyncRollOver;    
    // These variable keep track of the amount of
    // data buffered in the renderer
    BOOL                m_bCurrentTimeSet;
    INT64               m_llCurrentPlaybackTime; /* Cached value of last
						  * OnTimeSync() call
						  */

    UINT32              m_ulBufferedData; /* Data buffered in renderer.
					   * Always use GetBufferedData()
					   * to retreive the value
					   */
    CHXSimpleList       m_pktInfo; /* List of packet information */
};

inline
BOOL HXBufferingState::HasPreroll(BOOL bIsSeekPerformed) 
{
    return (bIsSeekPerformed) ? (m_prerollAfterSeek) : (m_prerollAtStart);
}

inline
BOOL HXBufferingState::HasPredata(BOOL bIsSeekPerformed) 
{
    return (bIsSeekPerformed) ? (m_preDataAfterSeek) : (m_preDataAtStart);
}


#endif /* HXBUFSTATE_H */
