/*
 * Base pane widget header
 * This is an abstract widget, which provides interface for pane widget.
 * Also, this implements some common features.
 *
 * Naming convention:
 * view: the component that is managed by GDiffWindow.
 *       see gdwin.h about view.
 * pane: pane is one component in view.
 *       but it might be still confused, because logic is almost taken care of
 *       by pane. view is just a container of pane, and almost every operations
 *       to view are handled by pane.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_BASEPANE_H__
#define __GDIFF_BASEPANE_H__

#include <gtk/gtkbin.h>
#include "mbuffer.h"	/* for MBuffer */
#include "properties.h" /* for FViewPref */

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

#define GDIFF_TYPE_BASEPANE				(gdiff_basepane_get_type())
#define GDIFF_BASEPANE(obj)				GTK_CHECK_CAST(obj, gdiff_basepane_get_type(), GdiffBasePane)
#define GDIFF_BASEPANE_CLASS(klass)		GTK_CHECK_CLASS_CAST(klass, gdiff_basepane_get_type(), GdiffBasePaneClass)
#define GDIFF_IS_BASEPANE(obj)			GTK_CHECK_TYPE(obj, gdiff_basepane_get_type())
#define GDIFF_IS_BASEPANE_CLASS(klass)	(GTK_CHECK_CLASS_TYPE((klass), GDIFF_TYPE_BASEPANE))

/* Constant number */
/* marks added line numbers. The lengths of three strings should be same. */
#define MARK_FILE1		"< "
#define MARK_FILE2		"> "
#define MARK_FILE3		"^ "	/* XXX */
#define MARK_COMMON		"  "
#define MARK_LENGTH		(sizeof(MARK_COMMON)-1)


typedef struct _GdiffBasePane       GdiffBasePane;
typedef struct _GdiffBasePaneClass  GdiffBasePaneClass;

struct _GdiffBasePane {
	GtkBin bin;

	/* Back-end data */
	char *filename[MAX_NUM_COMPARE_FILES];

	/* For reference */
	DiffDir *diffdir;
	DiffFiles *dfiles;

	/* This points to one node of dfiles->dlines_list.
	   Keep the current difference during navigation. */
	const GList *cur_dlines_node;

	/* MBuffer is internally related to mmap'ed buffer */
	MBuffer *mbuf[MAX_NUM_COMPARE_FILES];

	/* preference */
	FViewPref pref;/*XXX*/
};

struct _GdiffBasePaneClass {
	GtkBinClass parent_class;

	/* Interfaces */
	/* As long as I don't need a signal handler, I don't use signal. */
	void (*display)(GdiffBasePane *basepane);
	void (*show_linenum)(GdiffBasePane *basepane, gboolean to_show);
	void (*show_fill)(GdiffBasePane *basepane, gboolean to_show);
	gboolean (*toggle_textwrap)(GdiffBasePane *basepane);
	void (*set_highlight)(GdiffBasePane *basepane, gboolean to_highlight);
	void (*move_diff)(GdiffBasePane *basepane, MoveDiff mv_diff);/* signal */
	void (*select_dlines)(GdiffBasePane *basepane, WhichFile whichfile, int ln);/* signal */
	gboolean (*search_string)(GdiffBasePane *basepane, const char *string, WhichFile whichfile);
};


GtkType gdiff_basepane_get_type(void);
void _gdiff_basepane_set_backend(GdiffBasePane *basepane, DiffDir *diffdir, DiffFiles *dfiles);

void gdiff_basepane_display(GdiffBasePane *basepane);
void gdiff_basepane_show_linenum(GdiffBasePane *basepane, gboolean to_show);
void gdiff_basepane_show_fill(GdiffBasePane *basepane, gboolean to_show);
gboolean gdiff_basepane_toggle_textwrap(GdiffBasePane *basepane);
void gdiff_basepane_set_highlight(GdiffBasePane *basepane, gboolean to_highlight);
void gdiff_basepane_move_diff(GdiffBasePane *basepane, MoveDiff mv_diff);
void gdiff_basepane_select_dlines(GdiffBasePane *basepane, WhichFile whichfile, int ln);
gboolean gdiff_basepane_search_string(GdiffBasePane *basepane, const char *string, WhichFile whichfile);

/* Macros */
/* every derived type can use these macros */
#define PANE_DIFFDIR(x_pane)	(GDIFF_BASEPANE(x_pane)->diffdir)
#define PANE_DFILES(x_pane)		(GDIFF_BASEPANE(x_pane)->dfiles)
#define PANE_PREF(x_pane)		(GDIFF_BASEPANE(x_pane)->pref)
#define PANE_MBUF(x_pane, whichfile)	(GDIFF_BASEPANE(x_pane)->mbuf[whichfile])


/* Function table to find different portion */
typedef struct {
	MoveDiff mv_diff;
	DiffFindFunc find_fn;
} FindFunc;
extern const FindFunc findfn_table[];
extern const int NUM_FTABLE;


#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_BASEPANE_H__ */
