#include "gis.h"
#include "ps_map.h"

static char *explanation[] =
{
"",
"you may specify the map scale in one of the following ways:",
"",
"  1 : n",
"  1 inch equals n <units>    <units> can be miles, meters, or kilometers",
"  n inches                   absolute horizontal width of output",
"  n panels                   output will fill n panels",
"",
0};

int ask_scale (FILE *fd)
{
    char **c;
    char buf[200];

    fprintf (stdout,"\nSCALE\n");
    while(1)
    {
	fprintf (stdout,"enter map scale: ");
	input (buf);
	if (scan_scale (buf))
	    break;
	for (c = explanation; *c; c++)
	    fprintf (stdout,"%s\n", *c);
    }
    fprintf (fd, "scale %s\n", buf);
    begin_record ("SCALE:");
    add_record (buf);
    end_record();

    return 0;
}
