
/*****

DATA DICTIONARY MODULES:

general:

  all DD entries are hard-coded and supplied by the software, except the
  following:

  Data dictionary/definition module:

	 Definitions for GRASS_ENT, ATTR_NUM, ATTR_LABEL may be supplied by the
	 user (via v.sdts.meta); otherwise default definitions are supplied by
	 v.out.sdts.
 
  Data dictionary/domain module:

	 Minimum and maximum values for ATTR_NUM are generated by v.out.sdts
	 based on the GRASS data.

  Data dictionary/schema module:

	 Length of field for OTHER_INFO attribute varies according to GRASS version
	 number.
	 Length of field for ATTR_NUM and ATTR_LABEL ditto

	 ENTITY_LABEL field content may be supplied via v.sdts.meta 

  DDDF:   GRASS_ENT  hard-coded default or user-supplied via metadata file
		  ATTR_NUM  hard-coded default or user-supplied via metadata file
		  ATTR_LABEL  hard-coded default or user-supplied via metadata file

  DDOM:   ATTR_NUM MIN  - minimum dig_atts value, derived from mapset
		  ATTR_NUM MAX  - maximum dig_atts value, derived from mapset

  DDSH:   OTHER_INFO - length of field - determined according to version number
  DDSH:   ENTITY_LABEL for both ATTR_NUM and ATTR_LABEL -


			  hard-coded default or user-supplied via metadata file

DDDF: Data dictionary/Definition

 fld  subfld  len  type contents               source
--------------------------------------------------------------
DDDF   Module Name  A    "DDDF"                              profile
DDDF   Record ID    I    defined by order in this module     generated
DDDF   Entity or Attr.    "ENV" or "ATT"                      profile
DDDF   E/A Label         name of attribute or entity label   generated 
DDDF  [SRCE]         A    source for dictionary external
DDDF   Definition        free text                            generated or
                                                              user-supplied
DDDF   Attribute authority   USACERL                          generated
DDDF   Attr. Authority Description USA Con Eng Laboratires    generated


DDOM: Data dictionary/domain

 fld  subfld  len  type contents               source
--------------------------------------------------------------
DDOM   Module Name  A    "DDOM"                  profile
DDOM   Record ID    I    record id               generated
DDOM   ATLB    3    A    att label               external
DDOM   AUTH         A    attr authority (max 8 chars) profile
DDOM   ATYP         A    attr domain type        profile
DDOM   ADVF         A    attr domain val fmt     profile
DDOM  [ADMU]        A    attr dom val meas unit  depend on attrib
DDOM   RAVA         A    "MIN" "MAX" or "VALUE"  depends on attrib
DDOM   DVAL         A    domain value            valid values
DDOM  [DVDF]        A    domain value definition  external

DDSH: Data schema

 fld  subfld  len  type contents               source
--------------------------------------------------------------
DDSH   Module Name  A    "DDSH"                  profile
DDSH   Record ID    I    record id               generated
DDSH   NAME    3    A    name of relevant module            profile 
DDSH  [TYPE]        A    primary field name of relevant mod profile
DDSH  [ETLB]        A    entity label            GRASS   
DDSH  [EUTH]        A    entity authority        profile
DDSH   ATLB         A    name of attrib label    depend on attrib
DDSH   AUTH         A    attr authority (max 8 char)   depends on attrib
DDSH   FMT         A     format of attrib subfld depends on attrib
DDSH  [UNIT]        A    measurement unit        depends on attrib
DDSH   MXLN         I    max subfield length     generated
DDSH  [KEY]        A     key code                external

****/

#include "gis.h"
#include "Vect.h"
#include "defines.h"
#include "externs.h"
#include "stc123.h"
#include "dict_structs.h"



write_SDTS_dict_mods(map, sdts_prefix, sdts_path, layer_name)
  struct Map_info *map;
  char *sdts_prefix;
  char *sdts_path;
  char *layer_name;
{

	int stat = 1;

    fprintf (stderr, "Writing DDDF Module\n");
    if (!write_dddf_mod (map, sdts_prefix, sdts_path, DDDF))
	   stat = 0;

    fprintf (stderr, "Writing DDOM Module\n");
    if (!write_ddom_mod (map, sdts_prefix, sdts_path, DDOM))
	   stat = 0;

    fprintf (stderr, "Writing DDSH Module\n");
    if (!write_ddsh_mod (map, sdts_prefix, sdts_path, DDSH))
	   stat = 0;
	
    return (stat);
}

write_dddf_mod (map, sdts_prefix, sdts_path, mod_id)
  struct Map_info *map;
  char *sdts_prefix;
  char *sdts_path;
  int mod_id;
{
   FILE *fpout;
   char file_base[100];
    char name_str [100];
    char tmp_str[200];
	char i;

	Mod[DDDF].rec_cnt = 0;

    sprintf (file_base, "%4s%4s.DDF", sdts_prefix, Mod[mod_id].name);

    if (!Open_sdtsfile (sdts_path, file_base, &fpout, 'W'))
         return (0);


	if (!begin_sdts_ddr (file_base, fpout))
	{
        end123file (&fpout);
		return (0);
	}

    sprintf (name_str, "1600;&%s", Mod[mod_id].type);

    if (!write_dd_fld (file_base, fpout, Mod[mod_id].name, name_str, Ddr_elem[DDDF].label_str[0], Ddr_elem[DDDF].control_str[0], 3))
    {
	   end123file (&fpout);
	   return (0);
    }

    if (!end_dd_rec (file_base, fpout))
    {
	   end123file (&fpout);
	   return (0);
    }

    for (i = 1; Dddf[i].rcid != 0; i++)
	{
		if (!begin_data_rec (file_base, fpout))
        {
	       end123file (&fpout);
		   Mod[DDDF].rec_cnt = 0;
	       return (0);
        }

		sprintf (tmp_str, "%6d", i);
		write_data_fld (file_base, fpout, DDF_ID, LEAD_ID, tmp_str, RCID_LEN, 2);

		sprintf (tmp_str, "%s\037%d\037%s\037%s\037%s\037%s\037%s\037%s",
		   Mod[DDDF].name,
		   i,
		   Dddf[i].eora,
		   Dddf[i].ealb,
		   Dddf[i].srce,
		   Dddf[i].dfin,
		   Dddf[i].auth,
		   Dddf[i].adsc);

		if (Dddf[i+1].rcid == 0)
			write_data_fld (file_base, fpout, Mod[DDDF].name, LEAD_ID, tmp_str, strlen (tmp_str),4);
		else
			write_data_fld (file_base, fpout, Mod[DDDF].name, LEAD_ID, tmp_str, strlen (tmp_str),3);
	    Mod[DDDF].rec_cnt++;
	 }

	 if ( (get_err_stat() != 1) ||  (!end_data_rec (file_base, fpout)))
	 {
        end123file (&fpout);
		Mod[DDDF].rec_cnt = 0;
		return (0);
     }

     if (end_sdtsfile(file_base, &fpout))
		return (1);
     else
	 {
		Mod[DDDF].rec_cnt = 0;
		return (0);
	 }

}

write_ddom_mod (map, sdts_prefix, sdts_path, mod_id)
  struct Map_info *map;
  char *sdts_prefix;
  char *sdts_path;
  int mod_id;
{
   FILE *fpout;
   char file_base[100];
    char name_str [100];
    char tmp_str[200];
	char i;

	Mod[DDOM].rec_cnt = 0;

    sprintf (file_base, "%4s%4s.DDF", sdts_prefix, Mod[mod_id].name);

    if (!Open_sdtsfile (sdts_path, file_base, &fpout, 'W'))
         return (0);

	if (!begin_sdts_ddr (file_base, fpout))
	{
	    end123file (&fpout);
		return (0);
	}

    sprintf (name_str, "1600;&%s", Mod[mod_id].type);

    if (!write_dd_fld (file_base, fpout, Mod[mod_id].name, name_str, Ddr_elem[DDOM].label_str[0], Ddr_elem[DDOM].control_str[0], 3))
    {
	   end123file (&fpout);
	   return (0);
	}

    if (!end_dd_rec (file_base, fpout))
    {
	   end123file (&fpout);
	   return (0);
    }

    for (i = 1; Ddom[i].rcid != 0; i++)
	{
		if (!begin_data_rec (file_base, fpout))
        {
	       end123file (&fpout);
		   Mod[DDOM].rec_cnt = 0;
	       return (0);
        }

		sprintf (tmp_str, "%6d", i);
		write_data_fld (file_base, fpout, DDF_ID, LEAD_ID, tmp_str, RCID_LEN, 2);

		sprintf (tmp_str, "%s\037%d\037%s\037%s\037%s\037%s\037%s\037%s\037%s\037%s",
		   Mod[mod_id].name,
		   i,
		   Ddom[i].atlb,
		   Ddom[i].auth,
		   Ddom[i].atyp,
		   Ddom[i].advf,
		   Ddom[i].admu,
		   Ddom[i].rava,
		   Ddom[i].dval,
		   Ddom[i].dvdf );

		if (Ddom[i+1].rcid == 0)
			write_data_fld (file_base, fpout, Mod[DDOM].name, LEAD_ID, tmp_str, strlen (tmp_str), 4);
		else
			write_data_fld (file_base, fpout, Mod[DDOM].name, LEAD_ID, tmp_str, strlen (tmp_str), 3);

	    Mod[DDOM].rec_cnt++;
	 }

	 if ( (get_err_stat() != 1) ||  (!end_data_rec (file_base, fpout)))
	 {
        end123file (&fpout);
		Mod[DDOM].rec_cnt = 0;
		return (0);
     }

     if (end_sdtsfile(file_base, &fpout))
		return (1);
     else
	 {
		Mod[DDOM].rec_cnt = 0;
		return (0);
	 }

}

write_ddsh_mod (map, sdts_prefix, sdts_path, mod_id)
  struct Map_info *map;
  char *sdts_prefix;
  char *sdts_path;
  int mod_id;
{
    FILE *fpout;
    char file_base[100];
    char name_str [100];
    char tmp_str[200];
	char i;

	Mod[DDSH].rec_cnt = 0;

    sprintf (file_base, "%4s%4s.DDF", sdts_prefix, Mod[mod_id].name);

    if (!Open_sdtsfile (sdts_path, file_base, &fpout, 'W'))
         return (0);

	if (!begin_sdts_ddr (file_base, fpout))
	{
	    end123file (&fpout);
		return (0);
	}

    sprintf (name_str, "1600;&%s", Mod[mod_id].type);

    if (!write_dd_fld (file_base, fpout, Mod[mod_id].name, name_str, Ddr_elem[mod_id].label_str[0], Ddr_elem[mod_id].control_str[0], 3))
    {
	   end123file (&fpout);
	   return (0);
	}

    if (!end_dd_rec (file_base, fpout))
    {
	   end123file (&fpout);
	   return (0);
    }

    for (i = 1; Ddsh[i].rcid != 0; i++)
	{
		if (!begin_data_rec (file_base, fpout))
        {
	       end123file (&fpout);
		   Mod[DDSH].rec_cnt = 0;
	       return (0);
        }

		sprintf (tmp_str, "%6d", i);
		write_data_fld (file_base, fpout, DDF_ID, LEAD_ID, tmp_str, RCID_LEN, 2);

		sprintf (tmp_str, "%s\037%d\037%s\037%s\037%s\037%s\037%s\037%s\037%s\037%s\037%s\037%s",
		   Mod[mod_id].name,
		   i,
		   Ddsh[i].name,
		   Ddsh[i].type,
		   Ddsh[i].etlb,
		   Ddsh[i].euth,
		   Ddsh[i].atlb,
		   Ddsh[i].auth,
		   Ddsh[i].fmt,
		   Ddsh[i].unit,
		   Ddsh[i].mxln,
		   Ddsh[i].key);

		if (Ddsh[i+1].rcid == 0)
			write_data_fld (file_base, fpout, Mod[mod_id].name, LEAD_ID, tmp_str, strlen (tmp_str), 4);
		else
			write_data_fld (file_base, fpout, Mod[mod_id].name, LEAD_ID, tmp_str, strlen (tmp_str), 3);
	    Mod[DDSH].rec_cnt++;
	 }

	 if ( (get_err_stat() != 1) ||  (!end_data_rec (file_base, fpout)))
	 {
        end123file (&fpout);
		Mod[DDSH].rec_cnt = 0;
		return (0);
     }

     if (end_sdtsfile(file_base, &fpout))
		return (1);
     else
	 {
		Mod[DDSH].rec_cnt = 0;
		return (0);
	 }

}

