/*
** Copyright 2001 Double Precision, Inc.
** See COPYING for distribution information.
**
*/

#include "config.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <libintl.h>
#include <unistd.h>

#include "superfloppy.h"

static const char rcsid[]="$Id: misc.c,v 1.1 2001/07/12 03:42:01 mrsam Exp $";

unsigned long kilobytes(unsigned long nblocks, unsigned long blocksize)
{
	if (blocksize <= 1024)
	{
		nblocks = nblocks / (1024 / blocksize);
	}
	else
	{
		nblocks = nblocks * (blocksize / 1024);
	}
	return (nblocks);
}

const char *fmtsize(unsigned long nblocks, unsigned long blocksize)
{
	static char buf[100];

	nblocks=kilobytes(nblocks, blocksize);

	/* nblocks is now in kilobytes */

	if (nblocks >= 1024)
	{
		unsigned long mega = nblocks / 1024;
		unsigned kilo = nblocks % 1024;

		sprintf(buf, _("%lu.%02u Mb"), mega,
			(kilo * 100) / 1024);
	}
	else
	{
		sprintf(buf, _("%u Kb"), (unsigned)nblocks);
	}

	return (buf);
}
