/***************************************************************************
 *   Copyright (C) 2004 by Gav Wood                                        *
 *   gav@cs.york.ac.uk                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GEDDEINITE_H
#define GEDDEINITE_H

#define __GEDDEI_BUILD

#include "processorgroup.h"
using namespace Geddei;

#include <qvaluelist.h>
#include <qptrlist.h>
#include <qpoint.h>

#include "geddeinitebase.h"

class QDockWindow;
class QTable;
class QCanvas;
class QCanvasItem;

class BobsView;
class Bob;
class WatchProcessor;
class ProcessorView;

/** @internal
 * @author Gav Wood <gav@cs.york.ac.uk>
 */
class GeddeiNite: public GeddeiNiteBase
{
	Q_OBJECT

	QString theFilename;

	QPrinter *printer;
	QString filename;
	QCanvas *theCanvas;
	QCanvasItem *theActive;
	QDockWindow *theDockSelector, *theDockProperties;
	QTable *theProperties;
	ProcessorView *theSelector;
	WatchProcessor *theWatch;
	QPtrList<Bob> theBobs;
	ProcessorGroup theGroup;
	bool theRunning, theTested, theConnected, theIgnoreNext, theModified;
	int theDefaultBufferSize;

	void updateItems();
	void doSave(const QString &filename);
	void doLoad(const QString &filename);
	const bool connectAll();
	void disconnectAll();

	virtual void updateProperties();
	virtual void editRemove();

private slots:
	void slotPropertyChanged(int row, int column);
	void slotRunToggled(bool testing);
	void fileOpen();
	void fileSave();
	void fileSaveAs();
	void filePrint();
	void slotDeployPlayer();
	void slotTest();

protected:
	void closeEvent(QCloseEvent *);

public:
	const QString makeUniqueName(const QString &type);
	void setActive(QCanvasItem *item = NULL);
	void setModified(bool modified = true);

	const int defaultBufferSize() const { return theDefaultBufferSize; }
	const bool tested() const { return theTested; }
	const bool connected() const { return theConnected; }

	ProcessorGroup &group() { return theGroup; }
	WatchProcessor *watch() { return theWatch; }

	const bool bobCollision(Bob *b);
	void addBob(Bob *b);
	void removeBob(Bob *b);
	Bob *getBob(const QString &name);

	GeddeiNite();
	~GeddeiNite();
};

#endif
