/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class Main {
    static final String DEBUG = "-debug";
    static final String VM = "-vm";
    static final String VMARGS = "-vmargs";
    static final String LAUNCHER = "-launcher";
    static final String NAME = "-name";
    static final String SHOWSPLASH = "-showsplash";
    static final String EXITDATA = "-exitdata";
    static boolean debug = false;
    static String vm = null;
    static String[] vmArgs = null;
    static String launcher = null;
    static String name = null;
    static String splashTimeOut = null;
    static String exitData = null;
    static Process splashProcess = null;

    static void setSharedData(String data) {
        String[] cmdArray = new String[]{launcher, NAME, name, EXITDATA, exitData, data};
        try {
            System.out.println("STARTUP: launching Eclipse to write shared data");
            int i = 0;
            while (i < cmdArray.length) {
                System.out.println(i + "] <" + cmdArray[i] + ">");
                ++i;
            }
            Runtime.getRuntime().exec(cmdArray).waitFor();
            System.out.println("STARTUP: done");
        }
        catch (Exception e) {
            System.out.println("Eclipse: Exception in showSplash\n" + e);
        }
    }

    public static void main(String[] args) {
        System.out.println("STARTUP: arguments received from launcher");
        int i = 0;
        while (i < args.length) {
            System.out.println(i + "] <" + args[i] + ">");
            ++i;
        }
        int index = 0;
        while (index < args.length) {
            if (args[index].equals(DEBUG)) {
                debug = true;
            } else if (args[index].equals(VM)) {
                vm = args[++index];
            } else {
                if (args[index].equals(VMARGS)) {
                    vmArgs = new String[args.length - ++index];
                    System.arraycopy(args, index, vmArgs, 0, vmArgs.length);
                    break;
                }
                if (args[index].equals(LAUNCHER)) {
                    launcher = args[++index];
                } else if (args[index].equals(NAME)) {
                    name = args[++index];
                } else if (args[index].equals(SHOWSPLASH)) {
                    splashTimeOut = args[++index];
                } else if (args[index].equals(EXITDATA)) {
                    exitData = args[++index];
                }
            }
            ++index;
        }
        String splashPath = new File("splash.bmp").getAbsoluteFile().toString();
        String[] cmdArray = new String[]{launcher, NAME, name, SHOWSPLASH, splashTimeOut, splashPath};
        try {
            System.out.println("STARTUP: launching Eclipse to show splash screen");
            int i2 = 0;
            while (i2 < cmdArray.length) {
                System.out.println(cmdArray[i2]);
                ++i2;
            }
            splashProcess = Runtime.getRuntime().exec(cmdArray);
        }
        catch (Exception e) {
            System.out.println("STARTUP: exception in launch\n" + e);
        }
        System.out.print("STARTUP: Enter return to remove splash screen");
        try {
            System.in.read();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("STARTUP: Removing splash screen");
        if (splashProcess != null) {
            splashProcess.destroy();
        }
        System.out.println("STARTUP: Special exit codes are:");
        System.out.println("STARTUP: 0     - normal exit");
        System.out.println("STARTUP: 23    - restart launcher with same arguments");
        System.out.println("STARTUP: 24    - restart launcher with extra argument -newData=newValue in shared data");
        System.out.println("STARTUP: other - error occured, error message set in shared data");
        System.out.println("STARTUP: enter desired exit value:");
        int exitCode = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        while (!done) {
            try {
                String str = br.readLine();
                exitCode = Integer.parseInt(str);
                done = true;
            }
            catch (Exception str) {
                // empty catch block
            }
        }
        switch (exitCode) {
            case 0: 
            case 23: {
                break;
            }
            case 24: {
                String data = String.valueOf(vm) + '\n';
                int i3 = 0;
                while (i3 < vmArgs.length) {
                    data = String.valueOf(data) + vmArgs[i3] + '\n';
                    ++i3;
                }
                i3 = 0;
                while (i3 < args.length) {
                    data = String.valueOf(data) + args[i3] + '\n';
                    ++i3;
                }
                data = String.valueOf(data) + "-DNEW_ARGUMENT=NEW_VALUE\n";
                Main.setSharedData(data);
                break;
            }
            default: {
                Main.setSharedData("Test Error Message for exit code " + exitCode);
            }
        }
        System.out.print("STARTUP: Press a key to exit with value <" + exitCode + ">");
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(exitCode);
    }
}

