/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    Tree parent;
    boolean resizable = true;

    public TreeColumn(Tree parent, int style) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getColumnCount());
    }

    public TreeColumn(Tree parent, int style, int index) {
        super(parent, TreeColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return TreeColumn.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return 0;
        }
        int hwndHeader = this.parent.hwndHeader;
        if (hwndHeader == 0) {
            return 0;
        }
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 1;
        OS.SendMessage(hwndHeader, OS.HDM_GETITEM, index, hdItem);
        return hdItem.cxy;
    }

    public void pack() {
        Rectangle bounds;
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int columnWidth = 0;
        int hwnd = this.parent.handle;
        int hDC = OS.GetDC(hwnd);
        int oldFont = 0;
        int newFont = OS.SendMessage(hwnd, 49, 0, 0);
        if (newFont != 0) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        int cp = this.parent.getCodePage();
        RECT rect = new RECT();
        int flags = 3072;
        TVITEM tvItem = new TVITEM();
        tvItem.mask = 4;
        int hItem = OS.SendMessage(hwnd, 4362, 0, 0);
        while (hItem != 0) {
            String string;
            Image image;
            tvItem.hItem = hItem = OS.SendMessage(hwnd, 4362, 6, hItem);
            OS.SendMessage(hwnd, OS.TVM_GETITEM, 0, tvItem);
            TreeItem item = this.parent.items[tvItem.lParam];
            if (index == 0) {
                rect.left = item.handle;
                if (OS.SendMessage(hwnd, 4356, 1, rect) == 0) continue;
                columnWidth = Math.max(columnWidth, rect.right);
                continue;
            }
            int imageWidth = 0;
            int textWidth = 0;
            Image image2 = image = item.images != null ? item.images[index] : null;
            if (image != null) {
                bounds = image.getBounds();
                imageWidth = bounds.width;
            }
            String string2 = string = item.strings != null ? item.strings[index] : null;
            if (string != null) {
                TCHAR buffer = new TCHAR(cp, string, false);
                OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
                textWidth = rect.right - rect.left;
            }
            columnWidth = Math.max(columnWidth, imageWidth + textWidth + 9);
        }
        TCHAR buffer = new TCHAR(cp, this.text, true);
        OS.DrawText(hDC, buffer, buffer.length(), rect, flags);
        int headerWidth = rect.right - rect.left + 10;
        if (this.image != null) {
            int margin = 0;
            int hwndHeader = this.parent.hwndHeader;
            margin = hwndHeader != 0 && OS.COMCTL32_VERSION >= OS.VERSION(5, 80) ? OS.SendMessage(hwndHeader, 4629, 0, 0) : OS.GetSystemMetrics(45) * 3;
            bounds = this.image.getBounds();
            headerWidth += bounds.width + margin * 2;
        }
        if (newFont != 0) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(hwnd, hDC);
        this.setWidth(Math.max(headerWidth, columnWidth));
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int hwndHeader = this.parent.hwndHeader;
        if (hwndHeader == 0) {
            return;
        }
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 36;
        OS.SendMessage(hwndHeader, OS.HDM_GETITEM, index, hdItem);
        hdItem.fmt &= 0xFFFFFFFC;
        if ((this.style & 0x4000) == 16384) {
            hdItem.fmt |= 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            hdItem.fmt |= 2;
        }
        if ((this.style & 0x20000) == 131072) {
            hdItem.fmt |= 1;
        }
        OS.SendMessage(hwndHeader, OS.HDM_SETITEM, index, hdItem);
        if (index != 0) {
            int hwnd = this.parent.handle;
            RECT rect = new RECT();
            RECT itemRect = new RECT();
            OS.GetClientRect(hwnd, rect);
            OS.SendMessage(hwndHeader, 4615, index, itemRect);
            rect.left = itemRect.left;
            rect.right = itemRect.right;
            OS.InvalidateRect(hwnd, rect, true);
        }
    }

    public void setImage(Image image) {
        int index;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        int hwndHeader = this.parent.hwndHeader;
        if (hwndHeader == 0) {
            return;
        }
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 36;
        OS.SendMessage(hwndHeader, OS.HDM_GETITEM, index, hdItem);
        if (image != null) {
            hdItem.fmt |= 0x800;
            hdItem.iImage = this.parent.imageIndex(image);
        } else {
            hdItem.fmt &= 0xFFFFF7FF;
        }
        OS.SendMessage(hwndHeader, OS.HDM_SETITEM, index, hdItem);
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.resizable = resizable;
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        int hHeap = OS.GetProcessHeap();
        TCHAR buffer = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string), true);
        int byteCount = buffer.length() * TCHAR.sizeof;
        int pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        int hwndHeader = this.parent.hwndHeader;
        if (hwndHeader == 0) {
            return;
        }
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 2;
        hdItem.pszText = pszText;
        int result = OS.SendMessage(hwndHeader, OS.HDM_SETITEM, index, hdItem);
        if (pszText != 0) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (result == 0) {
            this.error(13);
        }
    }

    public void setWidth(int width) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        int hwndHeader = this.parent.hwndHeader;
        if (hwndHeader == 0) {
            return;
        }
        HDITEM hdItem = new HDITEM();
        hdItem.mask = 1;
        hdItem.cxy = width;
        OS.SendMessage(hwndHeader, OS.HDM_SETITEM, index, hdItem);
        this.parent.setScrollWidth();
    }
}

