;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;;
;;;; CMUCL 19a Patch 001: Fix a bug in the pretty-printer for
;;;; MULTIPLE-VALUE-BIND, reported by Gareth McCaughan, cmucl-imp,
;;;; 2006-01-09.
;;;;
;;;; (pprint '(multiple-value-bind 1)) causes an error.

(pushnew :cmucl-19c-patch-001 *features*)

(in-package "PP")

#+(and :cmu19c (not cmucl-19c-patch-001))
(ext:without-package-locks 
(defun pprint-multiple-value-bind (stream list &rest noise)
    (declare (ignore noise))
    (funcall (formatter "~:<~^~W~^~5I ~:_~W~^~3I ~:@_~W~1I~@{ ~:@_~W~}~:>")
	     stream list))
)

#+(and :cmu19c (not cmucl-19c-patch-001))
(set-pprint-dispatch `(cons (eql multiple-value-bind))
			   #'pprint-multiple-value-bind)
