#include <time.h>
#include <unistd.h>

/* Utility library. */

#include "msg.h"

/* Application-specific. */

#include "time_mono.h"

time_t time_mono(void)
{
    const char *myname = "time_monotonic";
#if defined(_POSIX_TIMERS) && (_POSIX_TIMERS > 0)
    struct timespec tp;
#endif

#if defined(_POSIX_TIMERS) && (_POSIX_TIMERS > 0)
#if defined(_POSIX_MONOTONIC_CLOCK) && (_POSIX_MONOTONIC_CLOCK >= 0)
    if (clock_gettime(CLOCK_MONOTONIC, &tp))
        msglog(MSG_FATAL|LOG_ERRNO, "%s: clock_gettime failed", myname);
#else
#warning "CLOCK_MONOTONIC not available. using CLOCK_REALTIME"
    if (clock_gettime(CLOCK_REALTIME, &tp))
        msglog(MSG_FATAL|LOG_ERRNO, "%s: clock_gettime failed", myname);
#endif
    return (tp.tv_sec);
#else
#warning "time_mono using time() interface"
    return (time(0));
#endif
}

/*For use with pthread_cond_timedwait*/
struct timespec *thread_cond_timespec(struct timespec *tp, time_t sec)
{
#if defined _POSIX_CLOCK_SELECTION && _POSIX_CLOCK_SELECTION >= 0
#if defined(_POSIX_TIMERS) && (_POSIX_TIMERS > 0)
#if defined(_POSIX_MONOTONIC_CLOCK) && (_POSIX_MONOTONIC_CLOCK >= 0)
    if (clock_gettime(CLOCK_MONOTONIC, tp))
        msglog(MSG_FATAL|LOG_ERRNO, "thread_cond_timespec: " \
                "clock_gettime failed");
#else
    if (clock_gettime(CLOCK_REALTIME, tp))
        msglog(MSG_FATAL|LOG_ERRNO, "thread_cond_timespec: " \
                "clock_gettime failed");
#endif
#endif
#else
    tp->tv_sec = time(0);
    tp->tv_nsec = 0;
#endif
    tp->tv_sec += sec;
    return (tp);
}

struct timespec *mono_timespec(struct timespec *tp, time_t sec)
{
#if defined(_POSIX_TIMERS) && (_POSIX_TIMERS > 0)
#if defined(_POSIX_MONOTONIC_CLOCK) && (_POSIX_MONOTONIC_CLOCK >= 0)
    if (clock_gettime(CLOCK_MONOTONIC, tp))
        msglog(MSG_FATAL|LOG_ERRNO, "mono_timespec: clock_gettime failed");
#else
    if (clock_gettime(CLOCK_REALTIME, tp))
        msglog(MSG_FATAL|LOG_ERRNO, "mono_timespec: clock_gettime failed");
#endif
#else
    tp->tv_sec = time(0);
    tp->tv_nsec = 0;
#endif
    tp->tv_sec += sec;
    return (tp);
}

void time_mono_init(void)
{
    /*call for the first time to see any fatal errors*/
    time_mono();
}
