%define version		0.92.1
%define name		autodir

Name: %{name}
Version: %{version}
Release: 12
Summary: Creates directories on demand
License: GPL
Group: System Environment/Daemons
Source: autodir-%{version}.tar.gz
URL: http://www.intraperson.com/autodir.html
Prefix: /usr
Prefix: /etc
Buildroot: %{_tmppath}/%{name}
ExclusiveOS: linux

%description

Autodir is for creating directories transparently to the applications
accessing them  based on available information from
sources like password database, group database.

Autodir depends on linux autofs kernel module to transparently detect
directory requests and create them on demand.

Autodir also supports calling backup programs transparently when
specific direcotory not in use so that whole system  does not need to
bring offline for backup purpose.
 
For more information see Autodir-HOWTO.

%prep
%setup -q

%build
./configure --prefix=$RPM_BUILD_ROOT/usr CFLAGS="$RPM_OPT_FLAGS"
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d
mkdir -p $RPM_BUILD_ROOT/etc/sysconfig

install -m 755 misc/init.scripts/autogroup $RPM_BUILD_ROOT/etc/rc.d/init.d/
install -m 755 misc/init.scripts/autohome $RPM_BUILD_ROOT/etc/rc.d/init.d/
install -m 644 misc/init.scripts/sysconfig/autohome $RPM_BUILD_ROOT/etc/sysconfig/
install -m 644 misc/init.scripts/sysconfig/autogroup $RPM_BUILD_ROOT/etc/sysconfig/

make install

%files
%defattr(-,root,root)

/usr/lib/autodir/
/usr/sbin/autodir

%config /etc/rc.d/init.d/autohome
%config /etc/rc.d/init.d/autogroup
%config /etc/sysconfig/autohome
%config /etc/sysconfig/autogroup

%doc README AUTHORS COPYING doc/Autodir-HOWTO.html doc/Autodir-HOWTO.xml

%post
/sbin/chkconfig --add autohome
/sbin/chkconfig --add autogroup

%preun
/sbin/service autohome stop > /dev/null 2>&1
/sbin/service autogroup stop > /dev/null 2>&1
chkconfig --del autohome
chkconfig --del autogroup
