/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "ianjuta-editor.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_append:
 * @obj: Self
 * @text: Text to append.
 * @length: Length of @text to use.
 * @err: Error propagation and reporting
 *
 * Appends @length characters from @text buffer at the end of editor
 * buffer. If @length is -1, the whole @text is used.
 */
void
ianjuta_editor_append (IAnjutaEditor *obj, const gchar *text, gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	g_return_if_fail (text != NULL);
	IANJUTA_EDITOR_GET_IFACE (obj)->append (obj, text, length, err);
}

/**
 * ianjuta_editor_can_redo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Can the editor redo the last operation?
 *
 * Returns true if editor can redo, else FALSE
 */
gboolean
ianjuta_editor_can_redo (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), FALSE);
	return IANJUTA_EDITOR_GET_IFACE (obj)->can_redo (obj, err);
}

/**
 * ianjuta_editor_can_undo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Can the editor undo the last operation?
 *
 * Returns true if editor can undo, else FALSE
 */
gboolean
ianjuta_editor_can_undo (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), FALSE);
	return IANJUTA_EDITOR_GET_IFACE (obj)->can_undo (obj, err);
}

/**
 * ianjuta_editor_erase_all:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Empties the whole editor buffer. There will be zero characters.
 */
void
ianjuta_editor_erase_all (IAnjutaEditor *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->erase_all (obj, err);
}

/**
 * ianjuta_editor_get_attributes:
 * @obj: Self
 * @start: Begining position
 * @end: End position
 * @err: Error propagation and reporting
 *
 * Gets the character attributes for characters between begining
 * position and end position (including themselves). Character attributes
 * are really only meaningful in the editor context from which it was
 * taken. Therefore, the returned data is mainly to be passed back to
 * the editor.
 *
 * Character attributes chould contain display information of the
 * character, such as font, size, color, highlight information etc.
 * 
 * Returns: A buffer of character attributes, indexed in sequence for
 * characters starting at begining position and ending at end position.
 * The returned buffer must be freed when no longer required.
 */
gchar*
ianjuta_editor_get_attributes (IAnjutaEditor *obj, gint start, gint end, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_attributes (obj, start, end, err);
}

/**
 * ianjuta_editor_get_current_column:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains number of the current column in the editor.
 *
 * Return value: Current column.
 */
gint
ianjuta_editor_get_column (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_column (obj, err);
}

/**
 * ianjuta_editor_get_current_word:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains the word on which carat is currently on.
 *
 * Return value: Current word.
 */
gchar*
ianjuta_editor_get_current_word (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_current_word (obj, err);
}

/**
 * ianjuta_editor_get_filename:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Allows obtaining of the filename the editor was loaded from.
 *
 * Return value: The name of the file. Not to be freed by caller.
 */
const gchar*
ianjuta_editor_get_filename (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_filename (obj, err);
}

/**
 * ianjuta_editor_get_length:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get length of complete text in editor. This will be the total
 * number of characters in the file or buffer.
 *
 * Return value: Text length.
 */
gint
ianjuta_editor_get_length (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_length (obj, err);
}

/**
* ianjuta_editor_get_line_begin_position:
* @obj: Self
* @line: fixme
* @err: Error propagation and reporting.
*
* fixme
*
* Returns: fixme
*/
gint
ianjuta_editor_get_line_begin_position (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_begin_position (obj, line, err);
}

/**
* ianjuta_editor_get_line_end_position:
* @obj: Self
* @line: fixme
* @err: Error propagation and reporting.
* 
* fixme
* 
* Returns: fixme
*/
gint
ianjuta_editor_get_line_end_position (IAnjutaEditor *obj, gint line, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_end_position (obj, line, err);
}

/**
 * ianjuta_editor_line_from_position:
 * @obj: Self
 * @position: Position you want to know the line from
 * @err: Error propagation and reporting
 *
 * Get the line number in which @position locates.
 * Returns: Line which corresponds to @position
 *
 */
int
ianjuta_editor_get_line_from_position (IAnjutaEditor *obj, int position, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), 0);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_line_from_position (obj, position, err);
}

/**
 * ianjuta_editor_get_lineno:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains current line number on which carat is.
 *
 * Return value: Line number.
 */
gint
ianjuta_editor_get_lineno (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_lineno (obj, err);
}

/**
 * ianjuta_editor_get_overwrite:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Obtains editor overwirte mode: TRUE = Override, FALSE = Insert.
 *
 * Return value: editor mode.
 */
gboolean
ianjuta_editor_get_overwrite (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), FALSE);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_overwrite (obj, err);
}

/**
 * ianjuta_editor_get_position:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Get current caret position
 *
 * Returns: Current character position since the begining of file.
 */
gint
ianjuta_editor_get_position (IAnjutaEditor *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), -1);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_position (obj, err);
}

/**
 * ianjuta_editor_get_text:
 * @obj: Self
 * @start: Begining position
 * @end: End position
 * @err: Error propagation and reporting
 *
 * Gets the text characters between beginning position and end position
 * (including themselves). The characters are utf-8 encoded.
 *
 * Returns: A buffer of utf-8 characters.
 * The returned buffer must be freed when no longer required.
 */
gchar*
ianjuta_editor_get_text (IAnjutaEditor *obj, gint start, gint end, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR(obj), NULL);
	return IANJUTA_EDITOR_GET_IFACE (obj)->get_text (obj, start, end, err);
}

/**
 * ianjuta_editor_goto_line:
 * @obj: Self
 * @lineno: line number where carat will be moved.
 * @err: Error propagation and reporting
 *
 * Carat is moved to the given @lineno line and text view is scrolled to
 * bring it in viewable area of the editor.
 */
void
ianjuta_editor_goto_line (IAnjutaEditor *obj, gint lineno, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->goto_line (obj, lineno, err);
}

/**
 * ianjuta_editor_goto_position:
 * @obj: Self
 * @position: Character position where carat will be moved.
 * @err: Error propagation and reporting
 *
 * Carat is moved to the given @position and text view is scrolled to
 * bring @position in viewable area of the editor.
 */
void
ianjuta_editor_goto_position (IAnjutaEditor *obj, gint position, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->goto_position (obj, position, err);
}

/**
 * ianjuta_editor_insert:
 * @obj: Self
 * @position: Character position in editor where insert will take place.
 * @text: Text to append.
 * @length: Length of @text to use.
 * @err: Error propagation and reporting
 *
 * Inserts @length characters from @text buffer at given @position of
 * editor buffer. If @length is -1, the whole @text is used.
 */
void
ianjuta_editor_insert (IAnjutaEditor *obj, int position, const gchar *text, gint length, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	g_return_if_fail (text != NULL);
	IANJUTA_EDITOR_GET_IFACE (obj)->insert (obj, position, text, length, err);
}

/**
 * ianjuta_editor_redo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Redo last undo operation
 */
void
ianjuta_editor_redo (IAnjutaEditor *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->redo (obj, err);
}

/**
 * ianjuta_editor_set_popup_menu:
 * @obj: Self
 * @menu: Popupmenu
 * @err: Error propagation and reporting
 *
 * Set Editor popup menu. This is the menu shown in the editor when one
 * right-clicks on it.
 *
 */
void
ianjuta_editor_set_popup_menu (IAnjutaEditor *obj, GtkWidget *menu, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	g_return_if_fail (GTK_IS_WIDGET(menu));
	IANJUTA_EDITOR_GET_IFACE (obj)->set_popup_menu (obj, menu, err);
}

/**
 * ianjuta_editor_undo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Undo last operation
 */
void
ianjuta_editor_undo (IAnjutaEditor *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR(obj));
	IANJUTA_EDITOR_GET_IFACE (obj)->undo (obj, err);
}

static void
ianjuta_editor_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("char-added",
			IANJUTA_TYPE_EDITOR,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorIface, char_added),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__INT_CHAR,
			G_TYPE_NONE,
			2,
			G_TYPE_INT,
			G_TYPE_CHAR);

		/* Signal */
		g_signal_new ("update-ui",
			IANJUTA_TYPE_EDITOR,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaEditorIface, update_ui),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		initialized = TRUE;
	}
}

GType
ianjuta_editor_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorIface),
			ianjuta_editor_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditor", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_editor_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_EDITOR_DOESNT_EXIST, "IANJUTA_EDITOR_DOESNT_EXIST", "doesnt-exist" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaEditorError", values);
	}

	return type;
}
