/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger.h -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _IANJUTA_DEBUGGER_H_
#define _IANJUTA_DEBUGGER_H_

#include <glib-object.h>

G_BEGIN_DECLS

#define IANJUTA_TYPE_DEBUGGER (ianjuta_debugger_get_type ())
#define IANJUTA_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebugger))
#define IANJUTA_IS_DEBUGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IANJUTA_TYPE_DEBUGGER))
#define IANJUTA_DEBUGGER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IANJUTA_TYPE_DEBUGGER, IAnjutaDebuggerIface))

#define IANJUTA_DEBUGGER_ERROR ianjuta_debugger_error_quark()

typedef struct _IAnjutaDebugger IAnjutaDebugger;
typedef struct _IAnjutaDebuggerIface IAnjutaDebuggerIface;

struct _IAnjutaDebuggerIface {
	GTypeInterface g_iface;
	
	/* Signal */
	void (*busy) (IAnjutaDebugger *obj, gboolean busy_state);

	void (*breakpoint_delete) (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);
	void (*breakpoint_set) (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);
	void (*breakpoint_toggle) (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);
	gboolean (*is_busy) (IAnjutaDebugger *obj, GError **err);
	void (*load) (IAnjutaDebugger *obj, const gchar *prog_uri, const GList *source_search_directories, GError **err);
	void (*run_continue) (IAnjutaDebugger *obj, GError **err);
	void (*run_to_position) (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);
	void (*step_in) (IAnjutaDebugger *obj, GError **err);
	void (*step_out) (IAnjutaDebugger *obj, GError **err);
	void (*step_over) (IAnjutaDebugger *obj, GError **err);

};

GQuark ianjuta_debugger_error_quark     (void);
GType  ianjuta_debugger_get_type        (void);

void ianjuta_debugger_breakpoint_delete (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);

void ianjuta_debugger_breakpoint_set (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);

void ianjuta_debugger_breakpoint_toggle (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);

gboolean ianjuta_debugger_is_busy (IAnjutaDebugger *obj, GError **err);

void ianjuta_debugger_load (IAnjutaDebugger *obj, const gchar *prog_uri, const GList *source_search_directories, GError **err);

void ianjuta_debugger_run_continue (IAnjutaDebugger *obj, GError **err);

void ianjuta_debugger_run_to_position (IAnjutaDebugger *obj, const gchar *uri, gint line, GError **err);

void ianjuta_debugger_step_in (IAnjutaDebugger *obj, GError **err);

void ianjuta_debugger_step_out (IAnjutaDebugger *obj, GError **err);

void ianjuta_debugger_step_over (IAnjutaDebugger *obj, GError **err);


G_END_DECLS

#endif
